
-- @author  acert
-- @date  08/2012
--

ladungshelfer = {};

function ladungshelfer.prerequisitesPresent(specializations)
 return true;
end;

function ladungshelfer:load(xmlFile)
		self.links1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ladehelfer.links1#index"));
		self.links2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ladehelfer.links2#index"));
		self.rechts1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ladehelfer.rechts1#index"));
		self.rechts2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ladehelfer.rechts2#index"));
		
		self.ladungStateR = false;
		self.ladungStateL = false;
end;

function ladungshelfer:delete()

end;

function ladungshelfer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ladungshelfer:keyEvent(unicode, sym, modifier, isDown)
end;

function ladungshelfer:update(dt)
	if self:getIsActive() and self:getIsActiveForInput() then
		
	
		if InputBinding.hasEvent(InputBinding.ladunglinks) then
		   	if self.ladungStateL == true then
				self.ladungStateL = false;
			elseif self.ladungStateL == false then	
				self.ladungStateL = true;
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.ladungrechts) then
		   	if self.ladungStateR == true then
				self.ladungStateR = false;
			elseif self.ladungStateR == false then	
				self.ladungStateR = true;
			end;
		end;
		
		if self.ladungStateR == true then	
			setTranslation(self.rechts1, 0, 0.7, 0); 
			setTranslation(self.rechts2, 0, 1.8, 0);
		end;
		if self.ladungStateR == false then	
			setTranslation(self.rechts1, 0, 0, 0); 
			setTranslation(self.rechts2, 0, 0, 0);
		end;
		
		if self.ladungStateL == true then	
			setTranslation(self.links1, 0, 0.7, 0); 
			setTranslation(self.links2, 0, 1.8, 0);
		end;
		if self.ladungStateL == false then	
			setTranslation(self.links1, 0, 0, 0); 
			setTranslation(self.links2, 0, 0, 0);
		end;
	end;	
   	
end;

function ladungshelfer:draw()
	renderText(0.72, 0.30, 0.02, "Taste n - Ladungshilfe Links ein/aus");	
	renderText(0.72, 0.32, 0.02, "Taste m - Ladungshilfe Rechts ein/aus");	
	
	if self.ladungStateR == true then
    g_currentMission:addHelpButtonText(g_i18n:getText("stateR"), InputBinding.ladungrechts);
	end;
	
	if self.ladungStateL == true then
	g_currentMission:addHelpButtonText(g_i18n:getText("stateL"), InputBinding.ladunglinks);
	end;
end;


function ladungshelfer:onAttach(attacherVehicle)
end;

function ladungshelfer:onDetach()

end;




