SetHitchEvent = {};
SetHitchEvent_mt = Class(SetHitchEvent, Event);

InitEventClass(SetHitchEvent, "SetHitchEvent");

function SetHitchEvent:emptyNew()
    local self = Event:new(SetHitchEvent_mt);
    self.className="SetHitchEvent";
    return self;
end;

function SetHitchEvent:new(vehicle, isHitchState)
    local self = SetHitchEvent:emptyNew()
    self.vehicle = vehicle;
	self.isHitchState = isHitchState;
    return self;
end;

function SetHitchEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isHitchState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetHitchEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isHitchState);
end;

function SetHitchEvent:run(connection)   
	self.vehicle:SetHitch(self.isHitchState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetHitchEvent:new(self.vehicle, self.isHitchState), nil, connection, self.vehicle);
    end;
end;

function SetHitchEvent.sendEvent(vehicle, isHitchState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetHitchEvent:new(vehicle, isHitchState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetHitchEvent:new(vehicle, isHitchState));
		end;
	end;
end;