--
-- Hitch
Hitch = {};

function Hitch.prerequisitesPresent(specializations)
    return true
end;

function Hitch:load(xmlFile)
	self.SetHitch = SpecializationUtil.callSpecializationsFunction("SetHitch")
	-- Animation --
	self.HitchAnimation = getXMLString(xmlFile, "vehicle.Hitch#animationName");	
	self.Hitch = true;		
	
end;

function Hitch:delete()
end;

function Hitch:readStream(streamId, connection)
    self:SetHitch(streamReadBool(streamId), true);
end;

function Hitch:writeStream(streamId, connection)
    streamWriteBool(streamId, self.Hitch);
end;

function Hitch:readUpdateStream(streamId, timestamp, connection)
end;

function Hitch:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Hitch:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Hitch:keyEvent(unicode, sym, modifier, isDown)
end;

function Hitch:update(dt)	
	-- Manage key events --
	if self.inrange then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self:SetHitch(not self.Hitch);
		end;
	end;
	-- Display key when in range --
	if self.inrange then
		if self.Hitch then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Lower_Hitch"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Raise_Hitch"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		end;
	end;	
end;

function Hitch:updateTick(dt)	
	if self.attacherVehicle and g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;
end;

function Hitch:SetHitch(isHitch,noEventSend)
	SetHitchEvent.sendEvent(self, isHitch, noEventSend);
	-- Play Hitch animation if inRange --
		if isHitch then
			if self.HitchAnimation ~= nil and self.playAnimation ~= nil then
				self:playAnimation(self.HitchAnimation, -1, nil, true);
				self.Hitch = true;
			end;
		else
			if self.HitchAnimation ~= nil and self.playAnimation ~= nil then
				self:playAnimation(self.HitchAnimation, 1, nil, true);
				self.Hitch = false;
			end;
		end;
end;


function Hitch:draw()
end;

