SetLightEvent = {};
SetLightEvent_mt = Class(SetLightEvent, Event);

InitEventClass(SetLightEvent, "SetLightEvent");

function SetLightEvent:emptyNew()
    local self = Event:new(SetLightEvent_mt);
    self.className="SetLightEvent";
    return self;
end;

function SetLightEvent:new(vehicle, isLightActive)
    local self = SetLightEvent:emptyNew()
    self.vehicle = vehicle;
	self.isLightActive = isLightActive;
    return self;
end;

function SetLightEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLightActive = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLightEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLightActive);
end;

function SetLightEvent:run(connection)   
	self.vehicle:LightState(self.isLightActive, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLightEvent:new(self.vehicle, self.isLightActive), nil, connection, self.vehicle);
    end;
end;

function SetLightEvent.sendEvent(vehicle, isLightActive, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLightEvent:new(vehicle, isLightActive), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLightEvent:new(vehicle, isLightActive));
		end;
	end;
end;