-- Script is Open Source
-- Lights
-- @H-P-J3000 - Part Of DJ Modding
-- @Date 11/03/11 
-- Notes added for beginer scripters and the script is not to be copied for use on other mods. 
-- Big Thanks To Bayn for helping convert original script and a big thanks to Sven777B for his help on making this very script MP capable.

Lights = {};

function Lights.prerequisitesPresent(specializations)
		print("Specialization For Lights By H-P-J3000 , Thanks To Sven777B For His Help");
    return true;
end;

function Lights:load(xmlFile)
--Warning Light
	self.WarningLight = {};
	self.SetLightState = SpecializationUtil.callSpecializationsFunction("SetLightState");-- Function 
	self.WarningLight[1] = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.WarningLight.WarningLights#index1"));-- XML call for light 
	self.intervall = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.WarningLight#intervall"), 0.5) * 1000;-- XML call for the intervall on blink
	self.currentTime = self.intervall;-- used to keep time and variable seperate
	self.isLightActive = false;-- Set the light visabilty on game start or trailer bought
--Indicators
--Left Light
	self.Left = {};
	self.SetLeftState = SpecializationUtil.callSpecializationsFunction("SetLeftState");
	self.Left = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Indicators.Left#index1"));
	self.intervallLeft = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Indicators#intervall"), 0.5) * 1000;
	self.currentTimeLeft = self.intervallLeft;
	self.isLeftActive = false;
--Right Light
	self.Right = {};
	self.SetRightState = SpecializationUtil.callSpecializationsFunction("SetRightState");
	self.Right = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Indicators.Right#index1"));
	self.intervallRight = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Indicators#intervall"), 0.5) * 1000;
	self.currentTimeRight = self.intervallRight;
	self.isRightActive = false;
--Hazzards
	-- no xml call is needed for the lights as it uses the left and right
	self.SetHazzardsState = SpecializationUtil.callSpecializationsFunction("SetHazzardsState");
	self.intervallHazzards = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Indicators#intervall"), 0.5) * 1000;
	self.currentTimeHazzards = self.intervallHazzards;
	self.isHazzardsActive = false;


end;

function Lights:delete()    
end;

function Lights:mouseEvent(posX, posY, isDown, isUp, button)    
end;

function Lights:keyEvent(unicode, sym, modifier, isDown)
end;

function Lights:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_BEACON_LIGHTS) then
			self:SetLightState(not self.isLightActive);
		end;	
		if InputBinding.hasEvent(InputBinding.IndicatorsLeft) then
			self:SetLeftState(not self.isLeftActive);  -- calling the function
			self.isRightActive = false; -- Stoping Function when active
			self.isHazzardsActive = false;
			setVisibility(self.Right, false);
		end;
		if InputBinding.hasEvent(InputBinding.IndicatorsRight) then
			self:SetRightState(not self.isRightActive);
			self.isLeftActive = false;
			self.isHazzardsActive = false;
			setVisibility(self.Left, false);
		end;	
		if InputBinding.hasEvent(InputBinding.Hazzards) then
			self:SetHazzardsState(not self.isHazzardsActive);
			self.isRightActive = false;
			self.isLeftActive = false;				
		end;
	end;
end;

function Lights:updateTick(dt) 
--Warning Light
	if self.isLightActive == true then
		if self.currentTime < 0 then -- if the current time is les than 0 then he light will work
			setVisibility(self.WarningLight[1], not getVisibility(self.WarningLight[1])); --(dt) uses to get time measurements
			self.currentTime = self.intervall;
		end;
		self.currentTime = self.currentTime - dt;
	else
		self.currentTime = self.intervall;
	end;
--Left	
	if self.isLeftActive == true then
		if self.currentTimeLeft < 0 then
			setVisibility(self.Left, not getVisibility(self.Left));
			self.currentTimeLeft = self.intervallLeft;
		end;
		self.currentTimeLeft = self.currentTimeLeft - dt;
	else
		self.currentTimeLeft = self.intervallLeft;
	end;
--Right	
	if self.isRightActive == true then
		if self.currentTimeRight < 0 then
			setVisibility(self.Right, not getVisibility(self.Right));
			self.currentTimeRight = self.intervallRight;
		end;
		self.currentTimeRight = self.currentTimeRight - dt;
	else
		self.currentTimeRight = self.intervallRight;
	end;
--Hazzards	
	if self.isHazzardsActive == true then
		if self.currentTimeHazzards < 0 then
			setVisibility(self.Right, not getVisibility(self.Right));
			setVisibility(self.Left, not getVisibility(self.Left));
			self.currentTimeHazzards = self.intervallHazzards;
		end;
		self.currentTimeHazzards = self.currentTimeHazzards - dt;
	else
		self.currentTimeHazzards = self.intervallHazzards;
	end;
end;

function Lights:onDetach()
self.isLightActive = false;
self.isLeftActive = false;
self.isRightActive = false;
self.isHazzardsActive = false;
end;	

function Lights:draw()
end;

--Wanring light Mp Event
function Lights:SetLightState(isActive, noEventSend)
	if self.isLightActive ~= isActive then  -- is active is shortend vairiable to send to make it less confusing for the engine to read 
		LightStateEvent.sendEvent(self, isActive, noEventSend);
		self.isLightActive = isActive;		
		setVisibility(self.WarningLight[1], isActive); -- isActive is used instead of true/false beacuse the MP Event script is set
													   -- up to read it as a boolen meaning it will always be either true/false
	end;
end;
--Left
function Lights:SetLeftState(isLeft, noEventSend)
	if self.isLeftActive ~= isLeft then
		LightStateEvent.sendEvent(self, isActive, isLeft, isRight, isHazzards, noEventSend);
		self.isLeftActive = isLeft;		
		setVisibility(self.Left, isLeft);
	end;
end;
--Right
function Lights:SetRightState(isRight, noEventSend)
	if self.isRightActive ~= isRight then
		LightStateEvent.sendEvent(self, isActive, isLeft, isRight, isHazzards, noEventSend);
		self.isRightActive = isRight;		
		setVisibility(self.Right, isRight);
	end;
end;
--Hazzards
function Lights:SetHazzardsState(isHazzards, noEventSend)
	if self.isHazzardsActive ~= isHazzards then
		LightStateEvent.sendEvent(self, isActive, isLeft, isRight, isHazzards, noEventSend);
		self.isHazzardsActive = isHazzards;		
		setVisibility(self.Right, isHazzards);
		setVisibility(self.Left, isHazzards);
	end;
end;
 LightStateEvent = {};
  LightStateEvent_mt = Class(LightStateEvent, Event);
  
  InitEventClass(LightStateEvent, "LightStateEvent");
  
  function LightStateEvent:emptyNew()
      local self = Event:new(LightStateEvent_mt);
      self.className="LightStateEvent";
      return self;
  end;
  
  function LightStateEvent:new(object, isActive, isLeft, isRight, isHazzards)
      local self = LightStateEvent:emptyNew()
      self.object = object;
	  self.isActive = isActive; 
	  self.isLeft = isLeft;
	  self.isRight = isRight;
	  self.isHazzards = isHazzards;
      return self;
  end;
  
  function LightStateEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
			self.isActive = streamReadBool(streamId);
			self.isLeft = streamReadBool(streamId);
			self.isRight = streamReadBool(streamId);
			self.isHazzards = streamReadBool(streamId);
			self:run(connection);
  end;
  
  function LightStateEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
  	streamWriteBool(streamId, self.isActive);--streamReadBool meaning it will always be either trues/false
  	streamWriteBool(streamId, self.isLeft);
  	streamWriteBool(streamId, self.isRight);
  	streamWriteBool(streamId, self.isHazzards);
  end;
  
  function LightStateEvent:run(connection)
      self.object:SetLightState(self.isActive, self.isLeft, self.isRight, self.isHazzards,true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(LightStateEvent:new(self.object, self.isActive, self.isLeft, self.isRight, self.isHazzards), nil, connection, self.object);
      end;
  end;
  
  function LightStateEvent.sendEvent(vehicle, isActive, isLeft, isRight, isHazzards, noEventSend)
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(LightStateEvent:new(vehicle, isActive, isLeft, isRight, isHazzards), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(LightStateEvent:new(vehicle, isActive, isLeft, isRight, isHazzards));
              end;
          end;
  end;