-- SetWeightSelectionGroupEvent
-- Specialisation to send the current weightstate
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  07/08/2011

SetWeightSelectionGroupEvent = {};
SetWeightSelectionGroupEvent_mt = Class(SetWeightSelectionGroupEvent, Event);

InitEventClass(SetWeightSelectionGroupEvent, "SetWeightSelectionGroupEvent");

function SetWeightSelectionGroupEvent:emptyNew()
    local self = Event:new(SetWeightSelectionGroupEvent_mt);
    self.className="SetWeightSelectionGroupEvent";
    return self;
end;

function SetWeightSelectionGroupEvent:new(vehicle, newSelectionGroup)
    local self = SetWeightSelectionGroupEvent:emptyNew()
    self.vehicle = vehicle;
	self.newSelectionGroup = newSelectionGroup;
    return self;
end;

function SetWeightSelectionGroupEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.newSelectionGroup = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetWeightSelectionGroupEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.newSelectionGroup);
end;

function SetWeightSelectionGroupEvent:run(connection)
	self.vehicle:setWeightSelectionGroup(self.newSelectionGroup, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetWeightSelectionGroupEvent:new(self.vehicle, self.newSelectionGroup), nil, connection, self.vehicle);
	end;
end;

function SetWeightSelectionGroupEvent.sendEvent(vehicle, newSelectionGroup, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetWeightSelectionGroupEvent:new(vehicle, newSelectionGroup), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetWeightSelectionGroupEvent:new(vehicle, newSelectionGroup));
		end;
	end;
end;