--
-- cab
-- LS UK Modteam
--
-- author Henly20
-- date  20/11/2010
--

cab = {};

function cab.prerequisitesPresent(specializations)
    return true;
end;

function cab:load(xmlFile)

	self.setCabVisibility = SpecializationUtil.callSpecializationsFunction("setCabVisibility");

      self.cabShows = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.cabShows.cabShow(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, true);
              table.insert(self.cabShows, {node=node});
          end;
          i = i + 1;
      end;
	  

end;

function cab:delete()

end;

function cab:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setCabVisibility(visibility, true);

	
end;

function cab:writeStream(streamId, connection)
	streamWriteBool(streamId, self.cabShowsActive);

	
end;

function cab:mouseEvent(posX, posY, isDown, isUp, button)
end;

function cab:keyEvent(unicode, sym, modifier, isDown)
end;

function cab:update(dt)

      if self:getIsActiveForInput() and self.isClient then
          if InputBinding.hasEvent(InputBinding.CAB7000) then
              self:setCabVisibility(not self.cabShowsActive);
          end;
	end;
end;

function cab:updateTick(dt)



end;

function cab:onLeave()

end;

function cab:draw()

end;

function cab:setCabVisibility(visibility, noEventSend)
      if visibility ~= self.cabShowsActive then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetCabEvent:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(SetCabEvent:new(self, visibility));
              end;
          end;
  
          self.cabShowsActive = visibility;
  
          for _, cabShow in pairs(self.cabShows) do
             setVisibility(cabShow.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setCabVisibility ~= nil then
                 v.setCabVisibility(self, visibility);
              end;
          end;
      end;
end;