--
-- Duels7000
-- LS UK Modteam
--
-- author Henly20
-- date  20/11/2010
--

Duels7000 = {};

function Duels7000.prerequisitesPresent(specializations)
    return true;
end;

function Duels7000:load(xmlFile)

	self.setDuelWheelsVisibility = SpecializationUtil.callSpecializationsFunction("setDuelWheelsVisibility");
	self.setDuelFWheelsVisibility = SpecializationUtil.callSpecializationsFunction("setDuelFWheelsVisibility");
	
      self.duelWheels = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.duelWheels.duelWheel(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, true);
              table.insert(self.duelWheels, {node=node});
          end;
          i = i + 1;
      end;

      self.duelFWheels = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.duelFWheels.duelFWheel(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, true);
              table.insert(self.duelFWheels, {node=node});
          end;
          i = i + 1;
      end;
end;

function Duels7000:delete()

end;

function Duels7000:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setDuelWheelsVisibility(visibility, true);
	local visibilityfront = streamReadBool(streamId);
	self:setDuelFWheelsVisibility(visibilityfront, true);
	
end;

function Duels7000:writeStream(streamId, connection)
	streamWriteBool(streamId, self.duelWheelsActive);
	streamWriteBool(streamId, self.duelFWheelsActive);
	
end;

function Duels7000:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Duels7000:keyEvent(unicode, sym, modifier, isDown)
end;

function Duels7000:update(dt)

      if self:getIsActiveForInput() and self.isClient then
          if InputBinding.hasEvent(InputBinding.MYDUELS7000) then
              self:setDuelWheelsVisibility(not self.duelWheelsActive);
          end;
          if InputBinding.hasEvent(InputBinding.MYFDUELS) then
              self:setDuelFWheelsVisibility(not self.duelFWheelsActive);
          end;
	end;
end;

function Duels7000:updateTick(dt)



end;

function Duels7000:onLeave()

end;

function Duels7000:draw()

end;

function Duels7000:setDuelWheelsVisibility(visibility, noEventSend)
      if visibility ~= self.duelWheelsActive then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetDuelRWheelsEvent:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(SetDuelRWheelsEvent:new(self, visibility));
              end;
          end;
  
          self.duelWheelsActive = visibility;
  
          for _, duelWheel in pairs(self.duelWheels) do
             setVisibility(duelWheel.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setDuelWheelsVisibility ~= nil then
                 v.setDuelWheelsVisibility(self, visibility);
              end;
          end;
      end;
end;

function Duels7000:setDuelFWheelsVisibility(visibilityfront, noEventSend)
      if visibilityfront ~= self.duelFWheelsActive then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetDuelFWheelsEvent:new(self, visibilityfront), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(SetDuelFWheelsEvent:new(self, visibilityfront));
              end;
          end;
  
          self.duelFWheelsActive = visibilityfront;
  
          for _, duelFWheel in pairs(self.duelFWheels) do
             setVisibility(duelFWheel.node, visibilityfront);
          end;
          for _,v in pairs(self.specializations) do
              if v.setDuelFWheelsVisibility ~= nil then
                 v.setDuelFWheelsVisibility(self, visibilityfront);
              end;
          end;
      end;
end;