---Made By @poc@lypse.

---For ls-modteam-France

renault = {};

function renault.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function renault:load(xmlFile)

    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;

    self.numtravails = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.travails#count"), 0);
    self.travails = {};
    for i=1, self.numtravails do
        local travailnamei = string.format("vehicle.travails.travail" .. "%d", i);
        self.travails[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, travailnamei .. "#index"));
        setVisibility(self.travails[i], false);
    end;
    
    local rotationPartNodebackwindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.backwindow#index"));
    if rotationPartNodebackwindow ~= nil then
        self.rotationPartbackwindow = {};
        self.rotationPartbackwindow.node = rotationPartNodebackwindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbackwindow#minRot"));
        self.rotationPartbackwindow.minRot = {};
        self.rotationPartbackwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backwindow#maxRot"));
        self.rotationPartbackwindow.maxRot = {};
        self.rotationPartbackwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbackwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#rotTime"), 2)*1000;
        self.rotationPartbackwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#touchRotLimit"), 10));
    end;

     local rotationPartNodeporte = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.porteg#index"));
    if rotationPartNodeporte ~= nil then
        self.rotationPartporte = {};
        self.rotationPartporte.node = rotationPartNodeporte;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartporteg#minRot"));
        self.rotationPartporte.minRot = {};
        self.rotationPartporte.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartporte.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartporte.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.porteg#maxRot"));
        self.rotationPartporte.maxRot = {};
        self.rotationPartporte.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartporte.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartporte.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartporte.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.porteg#rotTime"), 2)*1000;
        self.rotationPartporte.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.porteg#touchRotLimit"), 10));
    end;

  	   local rotationPartNodeporte1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ported#index"));
    if rotationPartNodeporte1 ~= nil then
        self.rotationPartporte1 = {};
        self.rotationPartporte1.node = rotationPartNodeporte1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartported#minRot"));
        self.rotationPartporte1.minRot = {};
        self.rotationPartporte1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartporte1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartporte1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ported#maxRot"));
        self.rotationPartporte1.maxRot = {};
        self.rotationPartporte1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartporte1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartporte1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartporte1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ported#rotTime"), 2)*1000;
        self.rotationPartporte1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ported#touchRotLimit"), 10));
    end;
	       
    self.numjumWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.jumWheels#count"), 0);
    self.jumWheels = {};
    for i=1, self.numjumWheels do
        local jumWheelnamei = string.format("vehicle.jumWheels.jumWheel" .. "%d", i);
        self.jumWheels[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, jumWheelnamei .. "#index"));
        setVisibility(self.jumWheels[i], false);
    end;
    
   
    
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
    self.motorBrakeForce = self.motor.brakeForce;
	self.brakeOn = false;
    self.revLimit = 100;
    self.worklightsActive = false;
    self.travailsActive = false;  
    self.jumWheelsActive = false;

     self.bcActive = false;
end;

function renault:delete()
end;

function renault:mouseEvent(posX, posY, isDown, isUp, button)
end;

function renault:keyEvent(unicode, sym, modifier, isDown)
    
    
    if isDown and sym == 48 then -- Key: 0
		self.bcActive = not self.bcActive;
    end;
    
    if isDown and sym == Input.KEY_u then 
		self.rotationMaxbackwindow = not self.rotationMaxbackwindow;
	end; 

     if isDown and sym == Input.KEY_t then 
		self.rotationMaxporte = not self.rotationMaxporte;
	end; 

     if isDown and sym == Input.KEY_y then 
		self.rotationMaxporte1 = not self.rotationMaxporte1;
	end; 

    if isDown and sym == Input.KEY_4 then
		self.worklightsActive = not self.worklightsActive;
	end;
     
    if isDown and sym == Input.KEY_5 then
		self.travailsActive = not self.travailsActive;
	end;

    if isDown and sym == Input.KEY_6 then
		self.jumWheelsActive = not self.jumWheelsActive;      
	end;
   
    if self.isEntered then
      if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input[self.rundumleuchtenKey] then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;
    end;
end;

 
function renault:update(dt)
  

   
  if self.isEntered then
       
        if self.worklightsActive then
		   for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive);
		   end;
	       else
		   for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		   end;
	    end;
              
        if self.travailsActive then
		   for i=1, self.numtravails do
			local travail = self.travails[i];
			setVisibility(travail, self.travailsActive);
		   end;
	       else
		   for i=1, self.numtravails do
			local travail = self.travails[i];
			setVisibility(travail, self.travailsActive, false);
		   end;
	    end;	    

        if not self.jumWheelsActive then
			for i=1, self.numjumWheels do
				local jumWheel = self.jumWheels[i];
				setVisibility(jumWheel, self.jumWheelsActive);
			end;
		else
			for i=1, self.numjumWheels do
				local jumWheel = self.jumWheels[i];
				setVisibility(jumWheel, self.jumWheelsActive, false);
			end;
		end;
    end;
    if self.rotationPartbackwindow ~= nil then
		local x, y, z = getRotation(self.rotationPartbackwindow.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
		setRotation(self.rotationPartbackwindow.node, unpack(newRot));
   end;

  if self.rotationPartporte ~= nil then
		local x, y, z = getRotation(self.rotationPartporte.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartporte.maxRot, self.rotationPartporte.minRot, 3, self.rotationPartporte.rotTime, dt, not self.rotationMaxporte);
		setRotation(self.rotationPartporte.node, unpack(newRot));
   end;

 if self.rotationPartporte1 ~= nil then
		local x, y, z = getRotation(self.rotationPartporte1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartporte1.maxRot, self.rotationPartporte1.minRot, 3, self.rotationPartporte1.rotTime, dt, not self.rotationMaxporte1);
		setRotation(self.rotationPartporte1.node, unpack(newRot));
   end;

  if self.isEntered then
    if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;
  end;
  
 
  
end;

function renault:onLeave()
    self.brakeOn = true;
    self.rotationMaxbackwindow = false;
    self.rotationMaxporte = false;
    self.rotationMaxporte1 = false;
    self.worklightsActive = false;
    self.travailsActive = false;
    self.jumWheelsActive = false; 
    self.rundumleuchtenAn = false;
     for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
   
 
end;
 

function renault:draw()
   if self.hudrenaultOverlay ~= nil then
       if self.bcActive then
        self.hudrenaultOverlay:render();
       end;  
   end;
 
end;