--
-- worklight
-- Class for Claas worklight
--
-- @author  JACK (ICQ brauchst du nicht )
-- @date  21/04/09

worklight = {};

function worklight.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function worklight:load(xmlFile)
    self.setWorklightsActive_v = SpecializationUtil.callSpecializationsFunction("setWorklightsActive_v");
--	self.setWorklightsActive_h = SpecializationUtil.callSpecializationsFunction("setWorklightsActive_h");
	self.joblight_v = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.joblight_v#index"));
	--self.joblight_b = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.joblight_b#index"));
    self.joblightActive_V = false;
	--self.joblightActive_B = false;
end;

function worklight:readStream(streamId, connection)
	self:setWorklightsActive_v(streamReadBool(streamId), true);
	--self:setWorklightsActive_h(streamReadBool(streamId), true);
end;

function worklight:writeStream(streamId, connection)
	streamWriteBool(streamId, self.joblightActive_V);
--	streamWriteBool(streamId, self.joblightActive_B);
end;

function worklight:keyEvent(unicode, sym, modifier, isDown)
--   if isDown and sym == self.keys.joblight_b then
--	 self:setWorklightsActive_h(not self.joblightActive_B);
--end;
end;

function worklight:update(dt)
	if self:getIsActive() then  
		if self.isEntered and InputBinding.hasEvent(InputBinding.joblight_v) then
			self:setWorklightsActive_v(not self.joblightActive_V);
		end;	
		if self.joblight_v ~= nil then
			setVisibility(self.joblight_v, self.joblightActive_V);
		end;
--		if self.joblight_b ~= nil then
--			setVisibility(self.joblight_b, self.joblightActive_B);
--		end;
	end;
end;

function worklight:draw()
end;

function worklight:mouseEvent(posX, posY, isDown, isUp, button)
end;

function worklight:onEnter()
	self.isActor = self.isEntered;
end;

function worklight:delete()
end;

function worklight:onLeave() 
	self:setWorklightsActive_v(false);
  --  self:setWorklightsActive_h(false);
end;


function worklight:setWorklightsActive_v(state, noSendEvent)
	self.joblightActive_V = state;
	setVisibility(self.joblight_v, self.joblightActive_V);
	if noSendEvent ~= true then
		worklightEvent.sendEvent(self, worklightEventType.worklights_v, self.joblightActive_V);
	end;
end;

--function worklight:setWorklightsActive_h(state, noSendEvent)
--	self.joblightActive_B = state;
--	setVisibility(self.joblight_b);
--	if noSendEvent ~= true then
--		worklightEvent.sendEvent(self, worklightEventType.worklights_h, self.joblightActive_B);
--	end;
--end;
