--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ZT320ShowHelp = {};

function ZT320ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ZT320ShowHelp:load(xmlFile)
	self.ZT320ShowHelp = false;
end;

function ZT320ShowHelp:delete()
end;

function ZT320ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ZT320ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ZT320ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.ZT320ShowHelp = not self.ZT320ShowHelp;
		end;
	end;
end;



function ZT320ShowHelp:updateTick(dt)
end;


function ZT320ShowHelp:draw()
	if not self.ZT320ShowHelp then
		renderText(0.75, 0.25, 0.02, " Numpad 0: ZT 320-A Info Ein ");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.75, 0.25, 0.02, "Numpad 0: ZT 320-A Info Aus");
		renderText(0.72, 0.68, 0.025, "- Fortschritt ZT 320-A -");			
		renderText(0.72, 0.65, 0.02, "Key Home: Rundumleuchten ");
		renderText(0.72, 0.63, 0.02, "Key KP 1: Blinker links ");
		renderText(0.72, 0.61, 0.02, "Key KP 2: Warnblinker");
		renderText(0.72, 0.59, 0.02, "Key KP 3: Blinker rechts");
		renderText(0.72, 0.57, 0.02, "Key KP 5: Arbeitslicht vorne ");
		renderText(0.72, 0.55, 0.02, "Key KP 6: Arbeitslicht hinten");
		renderText(0.72, 0.53, 0.02, "Key KP 7: Tuer links");
		renderText(0.72, 0.51, 0.02, "Key KP 8: Hechscheibe ");
		renderText(0.72, 0.49, 0.02, "Key KP 9: Tuer rechts ");
		renderText(0.72, 0.47, 0.02, "Key Page_Up: ESLimiter_PLUS");
		renderText(0.72, 0.45, 0.02, "Key Page_Down: ESLimiter_Minus");
		renderText(0.72, 0.43, 0.02, "Key 5: Zugmaul hoch");
		renderText(0.72, 0.41, 0.02, "Key 6: Zugmaul runter");
		renderText(0.72, 0.39, 0.02, "Key 7: Begrenzungslicht");			
		renderText(0.72, 0.37, 0.02, "Key 8: Zwillingsreifen hi / Warntafeln ");
		renderText(0.72, 0.35, 0.02, "Key 9: Spiegel");
		renderText(0.72, 0.33, 0.02, "Key 0: Hupe");
		renderText(0.72, 0.31, 0.02, "Key F lange gedrueckt: Fernlicht ");
	renderText(0.72, 0.28, 0.025, "- Fortschritt ZT 320-A -");
	end;
end;

function ZT320ShowHelp:onLeave()
	self.ZT320ShowHelp = false;
end;




