-- Script pro 4x4 v LS 11
-- AlesK  


quatro = {};

function quatro.prerequisitesPresent(specializations)
	return true;
end;

function quatro:load(xmlFile)
	
	self.fourWheelMode = false;
	self.isStarted = false;
	
	-- 4x4 symbol--
	
	self.hudfourWheelMode_yesPosX = 0.7557;
    self.hudfourWheelMode_yesWidth = 0.235;
    self.hudfourWheelMode_yesPosY = 0.214;
    self.hudfourWheelMode_yesHeight = 0.037;

	self.infoPanelfourWheelModePath = Utils.getFilename("Textures/Quatro_hud2.png", self.baseDirectory);
	self.hudfourWheelMode_yesOverlay = Overlay:new("hudfourWheelMode_yesOverlay", self.infoPanelfourWheelModePath, self.hudfourWheelMode_yesPosX, self.hudfourWheelMode_yesPosY, self.hudfourWheelMode_yesWidth, self.hudfourWheelMode_yesHeight);

	self.showHudfourWheelMode_yes = false;
	
end;

function quatro:delete()
  -- 4x4 symbol --
    if self.hudfourWheelModeyesOverlay ~= nil then
		self.hudfourWheelMode_yesOverlay:delete();
	end;
end;

function quatro:mouseEvent(posX, posY, isDown, isUp, button)
end;

function quatro:keyEvent(unicode, sym, modifier, isDown)

end;

function quatro:update(dt)
	
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.STEERMODE) then
			self.fourWheelMode = not self.fourWheelMode;
		end;
	end;
	
	-- 4x4 symbol status --
   	if self.fourWheelMode == true then
			self.showHudfourWheelMode_yes = true
		else
			self.showHudfourWheelMode_yes = false
	end;
		
	if self.fourWheelMode then
		for i=1, table.getn(self.wheels) do
			self.wheels[1].driveMode = 1;
			self.wheels[2].driveMode = 1;
			self.wheels[3].driveMode = 1;
			self.wheels[4].driveMode = 1;
		end;
	else
		for i=1, table.getn(self.wheels) do
			self.wheels[1].driveMode = 0;
			self.wheels[2].driveMode = 0;
			self.wheels[3].driveMode = 1;
			self.wheels[4].driveMode = 1;
		end;
	end;
	
end;

function quatro:onLeave()
end;

function quatro:draw()
	if self.fourWheelMode then
		g_currentMission:addHelpButtonText(g_i18n:getText("FendtAllrad"), InputBinding.STEERMODE);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("FendtAllrad2"), InputBinding.STEERMODE);
	end;
	if self.showHudfourWheelMode_yes and self.isEntered then
		self.hudfourWheelMode_yesOverlay:render();
	end;
end;


