SetCondPanelEvent = {};
SetCondPanelEvent_mt = Class(SetCondPanelEvent, Event);

InitEventClass(SetCondPanelEvent, "SetCondPanelEvent");

function SetCondPanelEvent:emptyNew()
    local self = Event:new(SetCondPanelEvent_mt);
    self.className="SetCondPanelEvent";
    return self;
end;

function SetCondPanelEvent:new(vehicle, isCondState)
    local self = SetCondPanelEvent:emptyNew()
    self.vehicle = vehicle;
	self.isCondPanelState = isCondState;
    return self;
end;

function SetCondPanelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isCondPanelState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetCondPanelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isCondPanelState);
end;

function SetCondPanelEvent:run(connection)   
	self.vehicle:setCondPanel(self.isCondPanelState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetCondPanelEvent:new(self.vehicle, self.isCondPanelState), nil, connection, self.vehicle);
    end;
end;

function SetCondPanelEvent.sendEvent(vehicle, isCondState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetCondPanelEvent:new(vehicle, isCondState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetCondPanelEvent:new(vehicle, isCondState));
		end;
	end;
end;