--
-- extrapipeSound
-- Specialization for extrapipeSound
--
-- @version:	v1.0
-- @author:  	janba75
--

extrapipeSound = {};

function extrapipeSound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function extrapipeSound:load(xmlFile)
    local extrapipeSound  = getXMLString(xmlFile, "vehicle.extrapipeSound#file");
    if extrapipeSound  ~= nil and extrapipeSound  ~= "" then
        extrapipeSound  = Utils.getFilename(extrapipeSound, self.baseDirectory);
        self.extrapipeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.extrapipeSound#pitchOffset"), 0);
        self.extrapipeSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.extrapipeSound#radius"), 50);
        self.extrapipeSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.extrapipeSound#innerRadius"), 10);
        self.extrapipeSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.extrapipeSound#volume"), 1);
        self.extrapipeSound = createAudioSource("extrapipeSound", extrapipeSound, self.extrapipeSoundRadius, self.extrapipeSoundInnerRadius, self.extrapipeSoundVolume, 0);
        link(self.components[1].node, self.extrapipeSound);
        setVisibility(self.extrapipeSound, false);
	self.attachedCutter = {};
    end;
end;
function extrapipeSound:delete()
end;
function extrapipeSound:readStream(streamId, connection)
end;
function extrapipeSound:writeStream(streamId, connection)
end;
function extrapipeSound:mouseEvent(posX, posY, isDown, isUp, button)
end;
function extrapipeSound:keyEvent(unicode, sym, modifier, isDown)
end;
function extrapipeSound:update(dt)
end;
function extrapipeSound:updateTick(dt)
    if self.pipeParticleActivated == true then
          self.pipeParticleDeactivateTime = self.time + 2000;
          setVisibility(self.extrapipeSound, true); 
    end;
    if self.pipeParticleDeactivateTime <= self.time == true then
            setVisibility(self.extrapipeSound, false);
    end; 
		if self.attachedCutter.implement ~= nil then	
			self.allowsThreshing = self.attacherJoints[1].moveDown;
			
			if not self.allowsThreshing then
				self.attachedCutter.implement.speedLimit = 1000; 
			else
				self.attachedCutter.implement.speedLimit = self.attachedCutter.speedBackup
			end;			
		end; 
end;
function extrapipeSound:draw()
end;
function extrapipeSound:detachImplement(implementIndex)

	local object = self.attachedImplements[implementIndex].object;
	if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
		object.speedLimit = self.attachedCutter.speedBackup;
		if object.vario1200 ~= nil then
			self.collector.ref = nil;
			self.collector.part.referencePoint = self.collector.part.node;
		end;		
		self.attachedCutter = {};
	end;
end;

function extrapipeSound:attachImplement(implement)

	local object  = implement.object;
	if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
		self.attachedCutter.implement = object;
		self.attachedCutter.speedBackup = object.speedLimit;
		if object.vario1200 ~= nil then
			self.collector.ref = object.vario1200.fixpoint;
			self.collector.part.referencePoint = self.collector.ref;
		end;
	end;
end;

function extrapipeSound:startThreshing()
end;

