--
-- xerion
-- Class for Claas xerion
--
-- @author  JACK (ICQ brauchst du nicht )
-- @date  21/04/09

xerion = {};

function xerion.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function xerion:load(xmlFile)

    local CabIndex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cab#index"));
    if CabIndex ~= nil then
	    self.Cab = {};
	    self.Cab.index = CabIndex;
	    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cab#forwardTrans"));
	    self.Cab.forwardTrans = {};
	    self.Cab.forwardTrans[1] = Utils.getNoNil(x, 0);
	    self.Cab.forwardTrans[2] = Utils.getNoNil(y, 0);
	    self.Cab.forwardTrans[3] = Utils.getNoNil(z, 0);
	
	    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cab#reverseTrans"));
	    self.Cab.reverseTrans = {};
	    self.Cab.reverseTrans[1] = Utils.getNoNil(x, 0);
	    self.Cab.reverseTrans[2] = Utils.getNoNil(y, 0);
	    self.Cab.reverseTrans[3] = Utils.getNoNil(z, 0);
	
	    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile," vehicle.cab#forwardRot"));
	    self.Cab.forwardRot = {};
	    self.Cab.forwardRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	    self.Cab.forwardRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	    self.Cab.forwardRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	
	    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cab#reverseRot"));
	    self.Cab.reverseRot = {};
	    self.Cab.reverseRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	    self.Cab.reverseRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	    self.Cab.reverseRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	
	    self.Cab.timeScale = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cab#timeScale"), 2)*1000;
	  end;

    self.numLightsCab = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cablights#count"), 0);
    self.cablights = {};
    for i=1, self.numLightsCab do
        local lightnamei = string.format("vehicle.cablights.light" .. "%d", i);
        self.cablights[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, lightnamei .. "#index"));
    end;
    self.joblight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.joblight#index"));

    self.exhaustParticleLow = {};
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleLow, "vehicle.exhaustParticleLow", self.rootNode, false, nil, self.baseDirectory);
    self.exhaustParticleHigh = {};
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleHigh, "vehicle.exhaustParticleHigh", self.rootNode, false, nil, self.baseDirectory);
	
	self.trailerAttacherJoints = {};
      local obj = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", 0);
      self.TAJindex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, obj.. "#index"));
      self.TAJdomv = Utils.getNoNil(getXMLBool(xmlFile, obj.. "#moveable"),false);
      self.TAJlow = Utils.getNoNil(getXMLBool(xmlFile, obj.. "#low"),false);
	if self.TAJdomv then
      self.TAJminY = Utils.getNoNil(getXMLFloat(xmlFile, obj.. "#minY"),0);
      self.TAJmaxY = Utils.getNoNil(getXMLFloat(xmlFile, obj.. "#maxY"),0);
	end;

    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
--        print("Keys: " .. inputName .. " = " .. inputKey .. " = " .. Input[inputKey] .. " : " .. self.keys[inputName]);
        i = i+1;
    end;

    self.brakeForce = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeForce"), 10);
    self.motorBrakeForce = self.motor.brakeForce;

    self.speedRotScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.speedRotScale#scale"), 80);
    self.speedRotScaleOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.speedRotScale#offset"), 0.7);

    self.Joint = self.TAJindex;
    self.trailerAttacherJointIndex = 0;
    self.attachedTrailer = nil;

    self.brakeOn = false;
    self.revLimit = 100;
    self.maxRpm3 = self.motor.maxRpm[3];
    self.activeTAJ = 0;
    

    self.drivingDir = 1;
    self.rotatePos = "forward";
    self.translatePos = "forward";
    self.doRotate = false;
    self.doTranslate = false;
    self.stopMoving = false;
    self.xerionRun = false;
    self.joblightActive = false;
    self.steerMode = 1;


    self.showhelp = false;
    self.hudInfo = Utils.getFilename("hud_help_base.png", self.baseDirectory);
    self.hudInfoPoxX = 0.012;
    self.hudInfoPoxY = 0.1825;
    self.hudInfoWidth = 0.425;
    self.hudInfoHeight = 0.1625;
    self.hudInfoOverlay = Overlay:new("hudInfoOverlay", self.hudInfo, self.hudInfoPoxX, self.hudInfoPoxY, self.hudInfoWidth, self.hudInfoHeight);



end;

function xerion:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == self.keys.cabrotate then
      self.drivingDir = self.drivingDir * -1;
      g_currentMission.allowSteerableMoving = false;
	self.cabon = not self.cabon;
      
    end;
    
    if isDown and sym == self.keys.joblight then
      self.joblightActive = not self.joblightActive;
    end;
    
    if self.isEntered then
         if isDown and sym == self.keys.rundumleuchte then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;

    if isDown and sym == self.keys.hilfe then
      if self.hudInfoOverlay ~= nil then
      	self.showhelp = not self.showhelp;
      end;
    end;


    if sym == self.keys.moveAK_up then
      self.moveAK_up = isDown;
      end;

    if sym == self.keys.moveAK_dn then
      self.moveAK_dn = isDown;
      end;

end;

function xerion:update(dt)

    if self.isEntered then

		local inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);

        if Input.isKeyPressed(self.keys.rev_up) and self.revLimit < 100 then
          self.revLimit = self.revLimit + 1;
        elseif Input.isKeyPressed(self.keys.rev_down) and self.revLimit > 10 then
          self.revLimit = self.revLimit - 1;
        end;
        self.motor.maxRpm[3] = string.format("%d",(self.revLimit * self.maxRpm3 / 100));

        local brake = false;
        if self.motor.brakeForce < self.brakeForce and inputAxisY ~= 0 then
          brake = true;
          self.motor.maxRpm[3] = 0;
        end;
        if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then
           brake = true;
           self.brakeOn = true;
           self.motor.brakeForce = self.brakeForce;
        elseif not brake then
           self.motor.brakeForce = self.motorBrakeForce;
        end;
        setVisibility(self.lightsbrake, brake);
        if self.brakeOn and not brake then
            if self.brakeSound ~= nil then
                setSamplePitch(self.brakeSound, self.brakeSoundPitchOffset);
                playSample(self.brakeSound, 1, 1, 0);
            end;
            self.brakeOn = false;
        end;
        if inputAxisY ~= 0 and not brake then
        		Utils.setEmittingState(self.exhaustParticleLow, false);
        		Utils.setEmittingState(self.exhaustParticleHigh, true);
        else
        		Utils.setEmittingState(self.exhaustParticleLow, true);
        		Utils.setEmittingState(self.exhaustParticleHigh, false);
        end;

        if Input.isKeyPressed(self.keys.moveAK_up) or Input.isKeyPressed(self.keys.moveAK_dn) then
            setJointFrame(self.trailerAttacherJointIndex,0,self.Joint);
            local ymod = 0;
            if Input.isKeyPressed(self.keys.moveAK_up) then ymod = 0.01; else ymod = -0.01; end;
                if self.TAJdomv then
                    local x,y,z = getTranslation(self.TAJindex);
                    y = y + ymod;
                    if y > self.TAJminY and y < self.TAJmaxY then
                        setTranslation(self.TAJindex,x,y,z);
                end;
            end;
        end;


end;

	  if self.isEntered then
	    if self.rundumleuchtenAnz > 0 then
	      if self.rundumleuchtenAn then
	        for i=1, self.rundumleuchtenAnz do
	          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
	        end;
	      end;
	    end;
	  end;

    self.firstTimeRun = false;
    local eps = 0.002;
    if self.Cab ~= nil then
				if self.isEntered then
		
		      if self.numLightsCab > 0 then
		          for i=1, self.numLightsCab do
		              setVisibility(self.cablights[i], self.lightsActive);
		          end;
		      end;
		      if self.joblight ~= nil then
		          setVisibility(self.joblight, self.joblightActive);
		      end;

-- bernehmen
		
		      local acceleration = 0;
		      if g_currentMission.allowSteerableMoving and not self.playMotorSound then
		          acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
		          --acceleration = 0.5;
		          if math.abs(acceleration) > 0.8 then
		              self.motor:setSpeedLevel(0, true)
		          end;
		          if self.motor.speedLevel ~= 0 then
		              acceleration = 1.0;
		          end;
		      end;
		      if self.fuelFillLevel == 0 then
		          acceleration = 0;
		      end;

		      if self.xerionRun then
		          WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, (acceleration * self.drivingDir), false, 0)
		      end;

 if self.cabon then
self.lastSpeed = self.lastSpeed*0.2;

                local rotScale = math.max(1.0/(self.lastSpeed*self.speedRotScale+self.speedRotScaleOffset), 1);
                local inputAxisX = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_SIDE);
                if inputAxisX < 0 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1000*inputAxisX*rotScale, self.maxRotTime);
                --elseif Input.isKeyPressed(Input.KEY_d) then
                elseif inputAxisX > 0 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1000*inputAxisX*rotScale, self.minRotTime);
                end;
            
 end;



-- renderText(0.01, 0.06, 0.02, string.format("%f", self.rotatedTime));

		      if(self.drivingDir == -1 and self.translatePos == "forward") then
		        self.doTranslate = true;
		      end;
		      if(self.drivingDir == -1 and self.translatePos == "reverse") then
		        self.doRotate = true;
		      end;
		      if(self.drivingDir == 1 and self.rotatePos == "reverse") then
		        self.doRotate = false;
		      end; 
		      if(self.drivingDir == 1 and self.rotatePos == "forward") then
		        self.doTranslate = false;
		      end;
		      
		      if self.rotatePos == "running" or self.translatePos == "running" then
		         g_currentMission.allowSteerableMoving = false;
		         self.stopMoving = true;
		      else
		         if self.stopMoving and not g_currentMission.allowSteerableMoving then
		            g_currentMission.allowSteerableMoving = true;
		            self.stopMoving = false;
		         end;
		      end;
		      
		      self.rotatePos = "running";
		      local x, y, z = getRotation(self.Cab.index);
		      local rot = {x,y,z};
		      if(math.abs(x - self.Cab.reverseRot[1]) < eps and math.abs(y - self.Cab.reverseRot[2]) < eps and math.abs(z - self.Cab.reverseRot[3]) < eps ) then
		        self.rotatePos = "reverse";
		      end;
		      if(math.abs(x - self.Cab.forwardRot[1]) < eps and math.abs(y - self.Cab.forwardRot[2]) < eps and math.abs(z - self.Cab.forwardRot[3]) < eps ) then
		        self.rotatePos = "forward";
		      end;
		      local newRot = Utils.getMovedLimitedValues(rot, self.Cab.forwardRot, self.Cab.reverseRot, 3, self.Cab.timeScale, dt, self.doRotate);
		      setRotation(self.Cab.index, unpack(newRot));
		
		      self.translatePos = "running";
		      local x, y, z = getTranslation(self.Cab.index);
		      local trans = {x,y,z};
		      if(math.abs(x - self.Cab.reverseTrans[1]) < eps and math.abs(y - self.Cab.reverseTrans[2]) < eps and math.abs(z - self.Cab.reverseTrans[3]) < eps ) then
		        self.translatePos = "reverse";
		      end;
		      if(math.abs(x - self.Cab.forwardTrans[1]) < eps and math.abs(y - self.Cab.forwardTrans[2]) < eps and math.abs(z - self.Cab.forwardTrans[3]) < eps ) then
		        self.translatePos = "forward";
		      end;
		      local newTrans = Utils.getMovedLimitedValues(trans, self.Cab.forwardTrans, self.Cab.reverseTrans, 3, self.Cab.timeScale, dt, self.doTranslate);
		      setTranslation(self.Cab.index, unpack(newTrans));

-- ende bernehmen

				end;
    end;

    self.xerionRun = true;
end;

function xerion:draw()


	setTextBold(true);
	renderText(self.hudBasePoxX, self.hudBasePoxY+0.15, 0.021, string.format("%s%d%%" , "Fordulatszam:", self.revLimit));

    if not self.showhelp then
    	g_currentMission:addExtraPrintText("Taste "..string.upper(string.char(self.keys.hilfe))..":                   Funkciok kiirasa");
    else
    	self.hudInfoOverlay:render();
    	local helptext={};
    	helptext[1] = " "..key_convert(self.keys.rundumleuchte)..": Villogo be/ki kapcsolasa";
    	helptext[2] = " "..key_convert(self.keys.cabrotate)..": Fulke forditasa";
    	helptext[3] = " "..key_convert(self.keys.moveAK_up).."|"..key_convert(self.keys.moveAK_dn)..": Vonofej mozgatas fel/le";
    	helptext[4] = " "..key_convert(self.keys.rev_up).."|"..key_convert(self.keys.rev_down)..": Fordulatszam novelese/csokkentese";
    	helptext[5] = " "..key_convert(self.keys.joblight)..": Munkavilagitas be/ki";
    	helptext[6] = " "..key_convert(self.keys.hilfe)..": Funkciok elrejtese";
    	if self.rundumleuchtenAn then

    		 helptext[1] = helptext[1].." (bekapcsolva)";
    	else
    		 helptext[1] = helptext[1].." (kikapcsolva)";
    	end;

    	if self.joblightActive then

    		 helptext[5] = helptext[5].." (bekapcsolva)";
    	else
    		 helptext[5] = helptext[5].." (kikapcsolva)";
    	end;

    	for i=1, table.getn(helptext) do
    		renderText((self.hudInfoPoxX+0.05),((self.hudInfoPoxY+self.hudInfoHeight) - (0.02*i)),0.02,helptext[i]);
    	end;
    end;

end;

function xerion:mouseEvent(posX, posY, isDown, isUp, button)
end;

function xerion:onEnter()
end;

function xerion:delete()
Utils.deleteParticleSystem(self.exhaustParticleLow);
Utils.deleteParticleSystem(self.exhaustParticleHigh);
end;

function xerion:onLeave() 
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;

    Utils.setEmittingState(self.exhaustParticleLow, false);
    Utils.setEmittingState(self.exhaustParticleHigh, false);
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;

