--
-- BuyableTwinWheelsAttacher
-- Specialization for BuyableTwinWheelsAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
-- Edit By Ufolec

kolarzedoweAttacher = {};

function kolarzedoweAttacher.prerequisitesPresent(specializations)
    return true;
end;

function kolarzedoweAttacher:load(xmlFile)

	self.onAssemblingg = SpecializationUtil.callSpecializationsFunction("onAssemblingg");
	self.onDisassemblingg = SpecializationUtil.callSpecializationsFunction("onDisassemblingg");
	
	self.kolarzedowe = {};
	self.kolarzedowe.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#kolarzedowe1CheckString"), "standart");
	self.kolarzedowe.kolarzedowe1 = nil;
	self.kolarzedowe.wheelsInRange = nil;	
	self.kolo1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kolo1#index"));
	self.kolo2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kolo2#index"));
	self.kolo3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kolo3#index"));
	self.kolo4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kolo4#index"));
end;

function kolarzedoweAttacher:delete()
	if self.kolarzedowe.kolarzedowe1 ~= nil then
		self.kolarzedowe.kolarzedowe1:disassembleeWheels(true);
	end;
end;

function kolarzedoweAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function kolarzedoweAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function kolarzedoweAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.kolarzedowe;
		if wheels.wheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.KOLA_RZEDOWE_ATTACH) then
					if wheels.kolarzedowe1 == nil then
						wheels.wheelsInRange:assembleeWheels(self);
					else
						if wheels.wheelsInRange.kolarzedowe1User == self then
							wheels.wheelsInRange:disassembleeWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function kolarzedoweAttacher:draw()
	local wheels = self.kolarzedowe;
	if wheels.wheelsInRange ~= nil then
		if wheels.kolarzedowe1 ~= nil then
			if wheels.wheelsInRange.kolarzedowe1User == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("kolarzedowe_disassemblee"), InputBinding.KOLA_RZEDOWE_ATTACH);
			end;
		else
			if wheels.wheelsInRange.kolarzedowe1User == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("kolarzedowe_assemblee"), InputBinding.KOLA_RZEDOWE_ATTACH);
			end;
		end;
	end;
end;

function kolarzedoweAttacher:onAssemblingg(kolarzedowe)
	self.kolarzedowe.kolarzedowe1 = kolarzedowe;
	if self.kolo1 ~= nil then
		setVisibility(self.kolo1, false);
	end;
	if self.kolo2 ~= nil then
		setVisibility(self.kolo2, false);
	end;
	if self.kolo3 ~= nil then
		setVisibility(self.kolo3, false);
	end;
	if self.kolo4 ~= nil then
		setVisibility(self.kolo4, false);
	end;
end;

function kolarzedoweAttacher:onDisassemblingg()
	self.kolarzedowe.kolarzedowe1 = nil;
	if self.kolo1 ~= nil then
		setVisibility(self.kolo1, true);
	end;
	if self.kolo2 ~= nil then
		setVisibility(self.kolo2, true);
	end;
	if self.kolo3 ~= nil then
		setVisibility(self.kolo3, true);
	end;
	if self.kolo4 ~= nil then
		setVisibility(self.kolo4, true);
	end;
end;
