--
-- BuyableTwinWheels
-- Specialization for Buyable Twin Wheels
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - added network support, changed update to updateTick
-- Edit By Ufolec

kolarzedowe = {};

function kolarzedowe.prerequisitesPresent(specializations)
    return true;
end;

function kolarzedowe:load(xmlFile)

	self.twinWheelTriggerCallback = kolarzedowe.twinWheelTriggerCallback;
	self.wheelDelete = kolarzedowe.wheelDelete;
	self.assembleeWheels = SpecializationUtil.callSpecializationsFunction("assembleeWheels");
	self.disassembleeWheels = SpecializationUtil.callSpecializationsFunction("disassembleeWheels");

	self.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kolarzedowe1#checkString"), "standart");
	self.usingTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kolarzedowe1#activationTrigger"));
	
	
	addTrigger(self.usingTrigger, "twinWheelTriggerCallback", self);
    self.deleteListenerId = addDeleteListener(self.usingTrigger, "wheelDelete", self);
	
	self.belts = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kolarzedowe1#belts"));
	
    self.kolarzedowe2 = {};
    local i = 0;
    while true do
        local wheelnamei = string.format("vehicle.kolarzedowe1.wheel(%d)", i);
        local wheel = {};
        local wheelIndex = getXMLInt(xmlFile, wheelnamei .. "#wheelIndex");
        if wheelIndex == nil then
            break;
        end;
		
		wheel.wheelIndex = wheelIndex;
		wheel.node = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei .. "#node"));
		wheel.collision = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei .. "#collision"));
		-- collision bug fix: on initial wheel assembling no collision is set
		setRigidBodyType(wheel.collision, "Kinematic");
		setRigidBodyType(wheel.collision, "NoRigidBody");
		wheel.savePosition = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei .. "#savePosition"));
		table.insert(self.kolarzedowe2, wheel);
		i = i + 1;
	end;

	self.loadedCoords = nil;
	self.kolarzedowe1User = nil;
end;

function kolarzedowe:delete()
	if self.kolarzedowe1User ~= nil then
		self.kolarzedowe1User:onDisassemblingg(true);
		for _,twinWheel in pairs(self.kolarzedowe2) do
			delete(twinWheel.node);
			delete(twinWheel.collision);
		end;
		self.kolarzedowe2 = {};
	end;
    removeTrigger(self.usingTrigger);
end;

function kolarzedowe:wheelDelete()
    removeDeleteListener(self.usingTrigger, self.deleteListenerId);
end;

function kolarzedowe:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	if id ~= -1 then
		local kolarzedowe1User = networkGetObject(id);
		if kolarzedowe1User ~= nil then
			self:assembleeWheels(kolarzedowe1User, true);
		end;
	end;
end;

function kolarzedowe:writeStream(streamId, connection)
	local idToWrite = -1;
	if self.kolarzedowe1User ~= nil then
		idToWrite = networkGetObjectId(self.kolarzedowe1User);
	end;
	streamWriteInt32(streamId, idToWrite);
end;

function kolarzedowe:mouseEvent(posX, posY, isDown, isUp, button)
end;

function kolarzedowe:keyEvent(unicode, sym, modifier, isDown)
end;

function kolarzedowe:update(dt)
end;

function kolarzedowe:updateTick(dt)

	-- try to load saved twinwheels
	if self.loadedCoords ~= nil then
		for k,steerable in pairs(g_currentMission.steerables) do
			local a,b,c = getWorldTranslation(steerable.rootNode);
			local distance = Utils.vector3Length(self.loadedCoords.x-a, self.loadedCoords.y-b, self.loadedCoords.z-c);
			if distance < 0.15 then				
				self:assembleeWheels(steerable);
				break;
			end;
		end;
		self.loadedCoords = nil;
	end;
end;

function kolarzedowe:draw()	
end;

function kolarzedowe:twinWheelTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	local vehicle = g_currentMission.controlledVehicle;
	if vehicle ~= nil then
		if onEnter then		
			if vehicle.rootNode == otherId then
				if vehicle.kolarzedowe ~= nil then
					if vehicle.kolarzedowe.checkString == self.checkString then
						if self.kolarzedowe1User ~= nil then
							if self.kolarzedowe1User == vehicle then
								vehicle.kolarzedowe.wheelsInRange = self;
							end;
						else
							vehicle.kolarzedowe.wheelsInRange = self;
						end;
					end;
				end;
			end;
		elseif onLeave then		
			if otherId == vehicle.rootNode then
				if vehicle.kolarzedowe ~= nil then
					vehicle.kolarzedowe.wheelsInRange = nil;
				end;
			end;
		end;
	end;
end;

function kolarzedowe:assembleeWheels(vehicle, noEventSend)
	kolarzedoweAttachEvent.sendEvent(self, vehicle, noEventSend);

	if self.belts ~= nil then
		setVisibility(self.belts, false);
	end;
	if self.kolarzedowe1User == nil then
		if vehicle.kolarzedowe ~= nil then
			self.kolarzedowe1User = vehicle;	
			for k,wheel in pairs(vehicle.wheels) do
				for l,twinWheel in pairs(self.kolarzedowe2) do 
					if k == l then	
						unlink(twinWheel.node);
						unlink(twinWheel.collision);
						link(wheel.driveNode, twinWheel.node);	
						link(getParent(wheel.repr), twinWheel.collision);	
						local x,y,z = getWorldTranslation(wheel.driveNode);
						x,y,z = worldToLocal(getParent(twinWheel.collision), x,y,z);
						setTranslation(twinWheel.collision,x,y,z);
						--setRigidBodyType(twinWheel.collision, "Kinematic");
						break;
					end;
				end;
			end;	
			self.kolarzedowe1User:onAssemblingg(self);
		end;
	end;
end;

function kolarzedowe:disassembleeWheels(noEventSend)
	kolarzedoweDetachEvent.sendEvent(self, noEventSend);

	self.kolarzedowe1User:onDisassemblingg();

	if self.belts ~= nil then
		setVisibility(self.belts, true);
	end;
	
	for k,wheel in pairs(self.kolarzedowe2) do
		setRigidBodyType(wheel.collision, "NoRigidBody");
		unlink(wheel.collision);
		unlink(wheel.node);
		setRotation(wheel.collision, 0,0,0);
		setTranslation(wheel.collision, 0,0,0);
		link(wheel.savePosition, wheel.collision);
		link(wheel.collision, wheel.node);
	end;	
	self.kolarzedowe1User = nil;	
end;


function kolarzedowe:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

	if not resetVehicles then
		local valueStr = getXMLString(xmlFile, key.."#attacherCoords");		
		if valueStr ~= nil then
			local x,y,z = Utils.getVectorFromString(valueStr);
			self.loadedCoords = {x = x,y = y,z = z};			
		end;
	end; 

    return BaseMission.VEHICLE_LOAD_OK;
end;

function kolarzedowe:getSaveAttributesAndNodes(nodeIdent)	
    local attributes = nil;
	
	if self.kolarzedowe1User ~= nil then
		local x,y,z = getWorldTranslation(self.kolarzedowe1User.rootNode);
		attributes = 'attacherCoords="'.. x .. " " .. y .. " " .. z ..'"';
	end;
	
    return attributes, nil;
end;




