--
-- xerionzbiornik
-- Specialization for xerionzbiornik
--
-- @author Felix "Outlaw" Sorge
-- @date  25/05/09
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--

xerionzbiornik = {};

function xerionzbiornik.prerequisitesPresent(specializations)
    return true;
	end;


function xerionzbiornik:load(xmlFile)
self.checkfL = 0;
    self.supportColli = self.components[2].node
	self.supportArms = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.supportArms#index"));
	local jointTypeStr = getXMLString(xmlFile, "vehicle.attacherJoint#jointType");
	if jointTypeStr ~= nil then
		local jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
		if jointType == nil then
			Vehicle.registerJointType(jointTypeStr);
			print("register Jointtype: " .. jointTypeStr);
			jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
		end;
		if jointType ~= nil then
			self.attacherJoint.jointType = jointType;			
		end;
	end;
end;


function xerionzbiornik:update(dt)

	if self.attacherVehicle then
	-- forced arm to rotation 0 0 0 
		if self.fixAttacher then
			local implement = self.attacherVehicle:getImplementByObject(self);
			if implement ~= nil then
				local joint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.saveJoint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.maxRotJoint = joint.maxRotLimit;
				self.attacherJointIndex = implement.jointDescIndex;
				self.rotationCopy  = joint.minRot;
				joint.minRot = {0,0,0};			
				joint.maxRotLimit = {0, 0, 0};
				setJointRotationLimit(joint.jointIndex, 2, true, 0, 0);
			end;
			self.fixAttacher = false;
		end;
		
		self.checkfL = self.fillLevel; 
		
	end; 
	if self.attacherVehicle ~= nil then
		setRigidBodyType(self.components[2].node, "NoRigidBody");
        local index1 = 0;
        local index2 = 1;
        local jointIndexStr = '0>2';

        local jointNode = Utils.indexToObject(self.components, jointIndexStr);
        if jointNode ~= nil and jointNode ~= 0 then
        	local x, y, z = getWorldTranslation(jointNode)
        	setTranslation(self.components[2].node, x, y, z)
        	local x, y, z = getWorldRotation(jointNode)
        	setRotation(self.components[2].node, x, y, z)
		end;
	end;
	
	if self.SupportCompAttach then
		local index1 = 0;
		local index2 = 1;
		local jointIndexStr = '0>2';
		local jointNode = Utils.indexToObject(self.components, jointIndexStr);
		if jointNode ~= nil and jointNode ~= 0 then
			local x, y, z = getWorldTranslation(jointNode)
			setTranslation(self.components[2].node, x, y, z)
			local x, y, z = getWorldRotation(jointNode)
			setRotation(self.components[2].node, x, y, z)

			local constr = JointConstructor:new();
			constr:setActors(self.components[index1+1].node, self.components[index2+1].node);
			constr:setJointTransforms(jointNode, jointNode);

			local x, y, z = Utils.getVectorFromString('0 0 0');
			local rotLimits = {};
			rotLimits[1] = math.rad(Utils.getNoNil(x, 0));
			rotLimits[2] = math.rad(Utils.getNoNil(y, 0));
			rotLimits[3] = math.rad(Utils.getNoNil(z, 0));

			local x, y, z = Utils.getVectorFromString('0 0 0');
			local transLimits = {};
			transLimits[1] = Utils.getNoNil(x, 0);
			transLimits[2] = Utils.getNoNil(y, 0);
			transLimits[3] = Utils.getNoNil(z, 0);

			for i=1, 3 do
				local rotLimit = rotLimits[i];
				if rotLimit >= 0 then
					constr:setRotationLimit(i-1, -rotLimit, rotLimit);
				end;

				local transLimit = transLimits[i];
				if transLimit >= 0 then
					constr:setTranslationLimit(i-1, true, -transLimit, transLimit);
				else
					constr:setTranslationLimit(i-1, false, 0, 0);
				end;
			end;
			local jointDesc = {};
			jointDesc.componentIndices = {index1+1, index2+1};
			jointDesc.jointNode = jointNode;
			jointDesc.jointIndex = constr:finalize();
			table.insert(self.componentJoints, jointDesc);
			self.SupportCompAttach = false;
		end;
	end;	
end;

function xerionzbiornik:draw()
end;


function xerionzbiornik:onAttach()
	self.fixAttacher = true; 
    setRigidBodyType(self.supportColli, "NoRigidBody");
	setVisibility(self.supportArms, false);	
	self.SupportCompAttach = false;
	setCenterOfMass(self.components[1].node, 0, 0, 0);
end; 	


function xerionzbiornik:onDetach()
	-- resets arm rotation to normal 
	local joint = self.saveJoint; 
	joint.minRot = self.rotationCopy;
	joint.maxRotLimit = self.maxRotJoint;
    setRigidBodyType(self.supportColli, "Dynamic");
	setVisibility(self.supportArms, true);
	self.SupportCompAttach = true;
	setCenterOfMass(self.components[1].node, 0, 0, 2);
end;


function xerionzbiornik:delete()
end;


function xerionzbiornik:mouseEvent(posX, posY, isDown, isUp, button)
end;


function xerionzbiornik:keyEvent(unicode, sym, modifier, isDown)
end;