--
-- Henly20 (Ls_uk Modteam)
-- 23.08.2010
-- Edit by surciHUN
-- > www.LS-UK.info

Talp = {};

function Talp.prerequisitesPresent(specializations)

    return true;
end;

function Talp:load(xmlFile)
     self.setRotationMax12 = SpecializationUtil.callSpecializationsFunction("setRotationMax12");
	 
	
	local rotationPartNode12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart12#index"));
    if rotationPartNode12 ~= nil then
        self.rotationPart12 = {};
        self.rotationPart12.node = rotationPartNode12;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart12#minRot"));
        self.rotationPart12.minRot = {};
        self.rotationPart12.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart12.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart12.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart12#maxRot"));
        self.rotationPart12.maxRot = {};
        self.rotationPart12.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart12.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart12.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart12.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart12#rotTime"), 2)*1000;
        self.rotationPart12.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart12#touchRotLimit"), 10));
    end;

		self.rotationMax12 = false;
end;

function Talp:readStream(streamId, connection)
     self.rotateMax = streamReadBool(streamId);
     if self.rotationPart12 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPart12.node, x, y, z);
      end;
end;
  
function Talp:writeStream(streamId, connection)
      streamWriteBool(streamId, self.rotateMax);
		if self.rotationPart12 ~= nil then
          local x, y, z = getRotation(self.rotationPart12.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function Talp:delete()

end;

function Talp:keyEvent(unicode, sym, modifier, isDown)


end;

function Talp:update(dt)
      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.TALP) then
				self:setRotationMax12(not self.rotationMax12);
          end;		  
     end;
end;

function Talp:updateTick(dt)
	if self:getIsActive() and self.isClient then
			if self.rotationPart12 ~= nil then
				local x, y, z = getRotation(self.rotationPart12.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart12.maxRot, self.rotationPart12.minRot, 3, self.rotationPart12.rotTime, dt, not self.rotationMax12);
				setRotation(self.rotationPart12.node, unpack(newRot));
			end;		
	end;		
end;

function Talp:draw()

  
end;


function Talp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Talp:setRotationMax12(rotationMax12, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetTalpRotationEvent:new(self, rotationMax12), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetTalpRotationEvent:new(self, rotationMax12));
          end;
      end;
      self.rotationMax12 = rotationMax12;
end;
