SetTalpRotationEvent = {};
SetTalpRotationEvent_mt = Class(SetTalpRotationEvent, Event);
  
InitEventClass(SetTalpRotationEvent, "SetTalpRotationEvent");
  
function SetTalpRotationEvent:emptyNew()
      local self = Event:new(SetTalpRotationEvent_mt);
      self.className="SetTalpRotationEvent";
      return self;
 end;

function SetTalpRotationEvent:new(object, rotationMax12)
      local self = SetTalpRotationEvent:emptyNew()
      self.object = object;
      self.rotationMax12 = rotationMax12;
      return self;
end;
 
function SetTalpRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationMax12 = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetTalpRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMax12);
end;
 
function SetTalpRotationEvent:run(connection)
      self.object:setRotationMax12(self.rotationMax12, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetTalpRotationEvent:new(self.object, self.rotationMax12), nil, connection, self.object);
      end;
end;