--
-- buckrake

-- Specialization Bressel and Lade 1850 l light cargo shovel --
-- edit by Defender

-- edit by henly20 Ls-uk-info 11-8-2011


buckrake = {};

function buckrake.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations) and SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function buckrake:load(xmlFile)
    self.tipReferencePoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tipReferencePoint#index"));
    if self.tipReferencePoint == nil then
        self.tipReferencePoint = self.components[1].node;
    end;
	
	self.fallOut = false;
	self.fallOut2 = false;
	self.fallOutParticle = false;
	self.implementFallOut = true;
	self.isShovel = true;
	self.lastFillLevel = self.fillLevel;
	
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;
end;

function buckrake:delete()
end;

function buckrake:mouseEvent(posX, posY, isDown, isUp, button)
end;

function buckrake:keyEvent(unicode, sym, modifier, isDown)
end;

function buckrake:update(dt)
end;

function buckrake:updateTick(dt)
    if self:getIsActive() then
		self.fallOut2 = false;
		if self.attacherVehicle ~= nil then
			self.fallOut2 = false;
				local x,y,z = localDirectionToWorld(self.tipReferencePoint, 0,0,1);
				if y < -0.5 or self.rotationShovelMax then
					self.fallOut = true;
				else
					self.fallOut = false;
				end;
				self.tiltangle = y;
		end;
		if self.fallOut and self.implementFallOut  then
			self:setFillLevel(self.fillLevel, self.currentFillType);
			local nearestDistance = 5.0;
			local px, py, pz = getWorldTranslation(self.tipReferencePoint);
			for i=1, table.getn(g_currentMission.attachables) do
				local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then
					local attachable = g_currentMission.attachables[i];		
					if attachable.fillTypes ~= nil and attachable.setFillLevel ~= nil and attachable.fillLevel ~= nil and attachable ~= self then
						if self.currentFillType == attachable.currentFillType or attachable.currentFillType == FruitUtil.FRUITTYPE_UNKNOWN then
							if attachable.fillLevel < attachable.capacity  and self.fillLevel > 1 then							
								local deltaLevel = (self.tiltangle*self.tiltangle)*(self.capacity/200)*dt							
								local fillDelta = math.min(deltaLevel, self.fillLevel)
								self:setFillLevel(self.fillLevel - fillDelta, self.currentFillType);
								attachable:setFillLevel(attachable.fillLevel + fillDelta, self.currentFillType);
								self.fallOut2 = self.fillLevel>0 and fillDelta>0;						
							end; 
						end;
					end;
				end;
			end;
		end;
		if self.fillLevel == 0 then
			self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
		end;
		if self.lastFillLevel > self.fillLevel then
			self.fallOutParticle = true;
		else
			self.fallOutParticle = false;
		end;
		self.lastFillLevel = self.fillLevel;
			
		Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], self.fallOutParticle);
		
		if self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_CLOSING or self.tipState == Trailer.TIPSTATE_OPEN then
			Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType]);
			self.fallOut = true;
			self.fallOut2 = true;
			self.implementFallOut = true;
			self.isShovel = false;
		else
			self.fallOut = false;
			self.fallOut2 = false;
			self.implementFallOut = true;
			self.isShovel = true;
		end;
		if self:getIsActive() then			
			self.setHydraulicTime = 30;	
		end;

		if self.setHydraulicTime > 0 then
			for k,v in pairs(self.hydraulics) do 
				self:setHydraulicDirection(k);
			end;
			self.setHydraulicTime = self.setHydraulicTime - 1;
		end;
	end;
end;

function buckrake:draw()
end;

function buckrake:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;

function buckrake:onDetach()
   if self.deactivateOnDetach then
        buckrake.onDeactivate(self);
    end;
	self.fallOutParticle = false;
end;

function buckrake:toggleTipState()
end;

function buckrake:onDeactivate()
    self.fallOut = false;
end;