--
-- Specialization for KuhnGA280
--
-- @author farmer joe
-- @date 13/08/10
--
--

KuhnGA280 = {};

function KuhnGA280.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function KuhnGA280:load(xmlFile)

	self.AnimRootNode = {};
	self.AnimClipIndex = {};
    self.animationParts = {};
	self.AnimLoop = {};
	self.AnimSpeed = {};
	self.AnimDuration = {};
	self.AnimCharSet = {};
	self.AnimClipIndexes = {};
	self.AnimDown = {};
	self.AnimDone = {};
	self.AnimJoint = {};
	self.Test = 0;
	local count = getXMLInt(xmlFile, "vehicle.animationParts#count");
	local part = self.animationParts;
	if count ~= nil then
	    for i=1, count do
			part[i] = {};
	        local partname = string.format("vehicle.animationParts.part".."%d", i);
		    local nameR = getXMLString(xmlFile, partname.."#name");
	
			
			local rootNode= Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#rootNode"));
			local clipName= getXMLString(xmlFile, partname.."#animationClip");
			
			self.AnimSpeed[nameR] = Utils.getNoNil(getXMLFloat(xmlFile, partname.."#speed"),1.0);
			self.AnimLoop[nameR] = Utils.getNoNil(getXMLBool(xmlFile, partname.."#loop"),false);
			
			self.AnimJoint[nameR] = Utils.getNoNil(getXMLInt(xmlFile, partname.."#joint"),0);
			
			self.AnimCharSet[nameR] = getAnimCharacterSet(rootNode);
			self.AnimClipIndexes[nameR] = getAnimClipIndex(self.AnimCharSet[nameR], clipName);
			
			assignAnimTrackClip(self.AnimCharSet[nameR], 0, self.AnimClipIndexes[nameR]);
			
			self.AnimDuration[nameR] = getAnimClipDuration(self.AnimCharSet[nameR], self.AnimClipIndexes[nameR]);
			
			
			self.AnimDown[nameR] = false;
			self.AnimDone[nameR] = true;
			
			setAnimTrackLoopState(self.AnimCharSet[nameR], 0, self.AnimLoop[nameR]);
			setAnimTrackSpeedScale(self.AnimCharSet[nameR], 0, self.AnimSpeed[nameR]);
		end; 
	end;
end;

function KuhnGA280:delete()
end;

function KuhnGA280:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KuhnGA280:keyEvent(unicode, sym, modifier, isDown)
end;

function KuhnGA280:update(dt)

	if self:getIsActiveForInput()  then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self.AnimDown["schild"] = not self.AnimDown["schild"];
			self.AnimDone["schild"] = false;
		end;
	end;
	
	for name,wert in pairs(self.AnimDone) do
		if not self.AnimDone[name] then
			local trackTime = getAnimTrackTime(self.AnimCharSet[name], 0);

			if self.AnimDown[name] then
				if  trackTime <=  0 then
					setAnimTrackSpeedScale(self.AnimCharSet[name], 0, self.AnimSpeed[name]);
					enableAnimTrack(self.AnimCharSet[name], 0);
				end;
				if  trackTime >=  self.AnimDuration[name] then
					disableAnimTrack(self.AnimCharSet[name], 0);
					self.AnimDone[name] = true;
				end;
			else
				if  trackTime >=  self.AnimDuration[name] then
					setAnimTrackSpeedScale(self.AnimCharSet[name], 0, -self.AnimSpeed[name]);
					enableAnimTrack(self.AnimCharSet[name], 0);
				end;
				if  trackTime <= 0 then
					disableAnimTrack(self.AnimCharSet[name], 0);
					self.AnimDone[name] = true;
				end;
			end;
			if self.AnimJoint[name] > 0 then
				setJointFrame(self.componentJoints[self.AnimJoint[name]].jointIndex, 0, self.componentJoints[self.AnimJoint[name]].jointNode);
			end;
		end;
	end;
end;



function KuhnGA280:onLeave()
end;


function KuhnGA280:onAttach(attacherVehicle)
	self.AnimDown["stuetze"] = true;
	self.AnimDone["stuetze"] = false;

end; 

function KuhnGA280:onDetach()
	self.AnimDown["stuetze"] = false;	
	self.AnimDone["stuetze"] = false;
end;

function KuhnGA280:draw()
	if self.AnimDown["schild"] then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("KuhnGA280_lift"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("KuhnGA280_lower"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
	end;
end;

function KuhnGA280:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.AnimDown["schild"] = Utils.getNoNil(getXMLBool(xmlFile, key.."#Schild"),false);
		self.AnimDone["schild"] = false;
	end; 

    return BaseMission.VEHICLE_LOAD_OK;
end;

function KuhnGA280:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'Schild="'.. tostring(self.AnimDown["schild"]) .. '"';
    return attributes, nil;
end;
