--
-- hydraulics
-- Specialization for hydraulics
--
-- @author Felix "Outlaw" S.
-- @date  25/10/09
-- @web www.ls-modsource.com - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--

hydraulics = {};


function hydraulics.prerequisitesPresent(specializations)
    return true;
end;

function hydraulics:load(xmlFile)
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		self.hydraulics[i].doScaleP = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScalePunch"), false);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, hydraulicName.."#Direction"));
		self.hydraulics[i].Scale = {};
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			
			self.hydraulics[i].Scale = {getScale(self.hydraulics[i].punch)};
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
        self.hydraulics[i].Dir = {};
        self.hydraulics[i].Dir[1] = Utils.getNoNil(x, 0);
        self.hydraulics[i].Dir[2] = Utils.getNoNil(y, 1);
        self.hydraulics[i].Dir[3] = Utils.getNoNil(z, 0);
	end;
	self.updatehydro = false;
end;
function hydraulics:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		local dir = self.hydraulics[i].Dir;
		setDirection(self.hydraulics[i].node, x, y, z, unpack(dir));
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale and not self.hydraulics[i].doScaleP then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		elseif self.hydraulics[i].doScaleP and not self.hydraulics[i].doScale then
			if self.hydraulics[i].punch ~= nil then	
				local cx, cy, cz = getWorldTranslation(self.hydraulics[i].punch);
				local distance2 = Utils.vector3Length(cx-bx, cy-by, cz-bz);				
				local xScale, yScale, zScale = unpack(self.hydraulics[i].Scale);
				local newScale = zScale * (distance2/self.hydraulics[i].punchDistance);	
				setScale(self.hydraulics[i].punch, 1, 1, newScale);
			end;
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	end;
	return nil;
end;
function hydraulics:draw()
end;

function hydraulics:delete()
end;

function hydraulics:update(dt) 
	if self:getIsActive() then
		self:setHydraulicDirection();
	end;
end;

function hydraulics:mouseEvent(posX, posY, isDown, isUp, button)
end;

function hydraulics:keyEvent(unicode, sym, modifier, isDown)
end; 
function hydraulics:onLeave()
	if self.deactivateOnLeave then
		self:onDeactivate(self)
	end;
end;

function hydraulics:onDetach()
	if self.deactivateOnDetach then
		self:onDeactivate(self)
	end;
end;
function hydraulics:onDeactivate()

end;
