--
-- Unischaufel
--

print("  Unischaufel");


if BaseMission.modMapShovelTrigger == nil then
	BaseMission.modMapShovelTrigger = {};
	print("  Register Variable: BaseMission.modMapShovelTrigger");
end;

Unischaufel = {};

function Unischaufel.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Unischaufel:load(xmlFile)

	self.fallOut = false;
	self.fallOutParticle = false;
	self.isShovel = true;
	self.lastFillLevel = self.fillLevel;
	
	self.implementFallOut = true;

end;


function Unischaufel:delete()
end;
	
function Unischaufel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Unischaufel:keyEvent(unicode, sym, modifier, isDown)
end;

function Unischaufel:update(dt)
end;

function Unischaufel:updateTick(dt)

	if self:getIsActive() then	

		if self.isServer then 		
			
			if self.attacherVehicle ~= nil then
				local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 1, 0));
				if z > 0 then
					self.fallOut = true;
				else
					self.fallOut = false;
				end;
				self.kippWinkel = z;
			end;
			
			
			
			if self.fallOut and self.implementFallOut then
				
				local nearestDistance = 3.0;
				local px, py, pz = getWorldTranslation(self.tipReferencePoint);
				for i=1, table.getn(g_currentMission.attachables) do
					local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
					local distance = Utils.vector2Length(px-vx, pz-vz);

					if distance < nearestDistance then
						local attachable = g_currentMission.attachables[i];	
						if attachable.rootNode ~= self.rootNode then
							if attachable.fillTypes ~= nil and attachable.setFillLevel ~= nil and attachable.fillLevel ~= nil then
								if attachable:allowFillType(self.currentFillType, true) then
									if attachable.fillLevel < attachable.capacity and self.fillLevel > 0 then							
										local deltaLevel = (self.kippWinkel*self.kippWinkel)*(self.capacity/200)*dt							
										local fillDelta = math.min(deltaLevel, self.fillLevel)
										self:setFillLevel(self.fillLevel - fillDelta, self.currentFillType);
										attachable:setFillLevel(attachable.fillLevel + fillDelta, self.currentFillType);
									end; 
								end;
							end;
						end;
					end;
				end;	

				local nearestDistance = 4.0;
				local px, py, pz = getWorldTranslation(self.tipReferencePoint);
				for i=1, table.getn(g_currentMission.modMapShovelTrigger) do
					local vx, vy, vz = getWorldTranslation(g_currentMission.modMapShovelTrigger[i].emptyNode);
					local distance = Utils.vector2Length(px-vx, pz-vz);

					if distance < nearestDistance then
						local object = g_currentMission.modMapShovelTrigger[i];		
						if object.fillLevel ~= nil and object.capacity ~= nil and object.setFillLevel ~= nil and object.allowFillType ~= nil then
							if object.fillLevel < object.capacity and self.fillLevel > 0 and object:allowFillType(self.currentFillType, true) then							
								local deltaLevel = (self.kippWinkel*self.kippWinkel)*(self.capacity/200)*dt							
								local fillDelta = math.min(deltaLevel, self.fillLevel)
								self:setFillLevel(self.fillLevel - fillDelta, self.currentFillType);
								object:setFillLevel(object.fillLevel + fillDelta, self.currentFillType);
							end; 
						end;
					end;
				end;
				
				if self.fillLevel == 0 then
					self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
				end;
				
			end;
			
		end;
		
		if self.lastFillLevel > self.fillLevel then
			self.fallOutParticle = true;
		else
			self.fallOutParticle = false;
		end;
		self.lastFillLevel = self.fillLevel;
			
		Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], self.fallOutParticle);
	
	end;
	

end;

function Unischaufel:draw()
end;

function Unischaufel:onDetach()
    self.fallOut = false;
	self.fallOutParticle = false;
end;
