
JD7530Wheelweights = {};

function JD7530Wheelweights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function JD7530Wheelweights:load(xmlFile)

	self.JD7530Wheelweights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.JD7530Wheelweights#count"), 0);
    self.weights = {};
    for i=1, self.JD7530Wheelweights do
        local weightnamei = string.format("vehicle.JD7530Wheelweights.weight%d", i);
        self.weights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, weightnamei .. "#index"));
        setVisibility(self.weights[i], false);
    end;
	
	self.currentWeight = 0;
	self.controlWeight = 0;
	self.singleWeight = 0;
	self.maxWeight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.maxWeight#weight"), 0.05);
end;

function JD7530Wheelweights:delete()
end;

function JD7530Wheelweights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JD7530Wheelweights:keyEvent(unicode, sym, modifier, isDown)
end;

function JD7530Wheelweights:update(dt)
	
	if self.isEntered then
	    self.singleWeight = (self.maxWeight / self.JD7530Wheelweights);
	
		if InputBinding.hasEvent(InputBinding.WEIGHT_ACTIVE) then
			if self.currentWeight >= self.maxWeight then
				self.currentWeight = 0;
			else
				self.currentWeight = self.currentWeight + self.singleWeight;
			end;
		end;
		
		if self.weights ~= nil then
		    if self.currentWeight ~= self.controlWeight then
		        self.controlWeight = self.currentWeight;
			
			    if self.currentWeight > 0 then
		            for i = 1, self.JD7530Wheelweights do
				        if i * self.singleWeight <= self.currentWeight then
					        setVisibility(self.weights[i], true);
					    end;
				    end;
				else
				    for i = 1, self.JD7530Wheelweights do
					    setVisibility(self.weights[i], false);
					end;
			    end;
		    end;

			if self.emptyMass == nil then
				self.emptyMass = getMass(self.components[1].node);
				self.currentMass = self.emptyMass;
			end;
			local newMass = self.emptyMass + self.currentWeight;
			if newMass ~= self.currentMass then
				setMass(self.components[1].node, newMass);
				self.currentMass = newMass;
				for k,v in pairs(self.components) do
					if v.node == self.components[1].node then
						if v.centerOfMass ~= nil then
							setCenterOfMass(v.node, v.centerOfMass[1], v.centerOfMass[2], v.centerOfMass[3]);
						end;
						break;
					end;
				end;
			end;
		end;
	end;
end;

function JD7530Wheelweights:onLeave()
	self.weightActive = false;
end;

function JD7530Wheelweights:draw()
--	g_currentMission:addHelpButtonText("Radgewichte: " ..string.format("%d kg", self.currentWeight*9), InputBinding.WEIGHT_ACTIVE);
end;

