
moveAttacher2 = {};

function moveAttacher2.prerequisitesPresent(specializations)
    return true;
end;

function moveAttacher2:load(xmlFile)

	self.moveableAttacher2 = {};
	self.moveableAttacher2.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableAttacher2#index"));
	self.moveableAttacher2.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacher2#maxX"), 0); 
	self.moveableAttacher2.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacher2#minX"), 0); 
	self.moveableAttacher2.home = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacher2#home"), 0); 
	
end;

function moveAttacher2:delete()
end;

function moveAttacher2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveAttacher2:keyEvent(unicode, sym, modifier, isDown)

end;

function moveAttacher2:update(dt)

	if self.moveableAttacher2 ~= nil then
		local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableAttacher2.index);
		local maxX = self.moveableAttacher2.max;
		local minX = self.moveableAttacher2.min;
		local moveSpeed = 0.004;
			if InputBinding.isPressed(InputBinding.MOVEATTACHER2_LEFT) then
				if xAttacher < maxX then
					xAttacher = xAttacher + moveSpeed;				
				end;
			elseif InputBinding.isPressed(InputBinding.MOVEATTACHER2_RIGHT) then
				if xAttacher > minX then
					xAttacher = xAttacher - moveSpeed;				
				end;
			elseif InputBinding.isPressed(InputBinding.MOVEATTACHER2_HOME) then
				xAttacher = self.moveableAttacher2.home;				
			end;
		setTranslation(self.moveableAttacher2.index, xAttacher, yAttacher, zAttacher);
	end;
				
end;

function moveAttacher2:onLeave()

end;

function moveAttacher2:draw()

end;

function moveAttacher2:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

