
-- BarrierTrailer
-- @Author Swat
-- @date 12/09/09

BarrierTrailer = {};

function BarrierTrailer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function BarrierTrailer:load(xmlFile)

    local signboard = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.signboard#index"));
    if signboard ~= nil then
        self.signboard = {};
        self.signboard.node = signboard;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.signboard#minRot"));
        self.signboard.minRot = {};
        self.signboard.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.signboard.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.signboard.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.signboard#maxRot"));
        self.signboard.maxRot = {};
        self.signboard.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.signboard.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.signboard.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.signboard.rotTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.signboard#rotTime"), 2)*1000;

		self.signboard.arrow = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.signboard#arrow"));
		self.signboard.max = math.rad(45);
		self.signboard.min = math.rad(-45);
		self.signboard.angleOffset = math.rad(45);
		
		self.signboard.signs = {};
		self.signboard.signs[1] = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.signs#index1"));
		self.signboard.signs[2] = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.signs#index2"));
		self.signboard.signs[3] = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.signs#index3"));
		self.signboard.signs[4] = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.signs#index4"));
		self.currentSign = 0;
		
		self.blinkingSigns = {};
		self.blinkingSigns[1] = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.signs#activeTime"), 2.5)*1000;
		self.blinkingSigns[2] = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.signs#inactiveTime"), 1)*1000;
		self.currentStatus = 0;
		self.switchTime = self.blinkingSigns[2];
    end;
	
	self.warningLights = {};
	self.warningLights[1] = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.warningLights#index1"));
	self.warningLights[2] = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.warningLights#index2"));
	self.intervall = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.warningLights#intervall"), 0.5) * 1000;
	self.currentTime = self.intervall;

	
	
	
	self.isLightActive = false;
	self.isExpanded = false;
	self.switch = false;
end;

function BarrierTrailer:delete()    
end;

function BarrierTrailer:mouseEvent(posX, posY, isDown, isUp, button)    
end;

function BarrierTrailer:keyEvent(unicode, sym, modifier, isDown)
end;

function BarrierTrailer:update(dt)
       
	if self:getIsActive() then
	
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.BARRIER_TRAILER_FOLD) then
				self.isExpanded = not self.isExpanded;
			end;
			if InputBinding.hasEvent(InputBinding.BARRIER_TRAILER_SWITCH) then
				self.switch = true;
			end;
			if InputBinding.hasEvent(InputBinding.BARRIER_TRAILER_LIGHTS) then
				self.isLightActive = not self.isLightActive;
				if self.isLightActive then
					setVisibility(self.warningLights[1], true);
					self.currentTime = self.intervall;
				else
					setVisibility(self.warningLights[1], false);
					setVisibility(self.warningLights[2], false);
				end;
			end;
			if InputBinding.hasEvent(InputBinding.BARRIER_TRAILER_SWITCH_SIGN) then
				self.currentSign = (self.currentSign + 1) % 5;
				
				if self.currentSign == 0 then
					setVisibility(self.signboard.signs[4], false);
				else
					if self.currentSign > 1 then
						setVisibility(self.signboard.signs[self.currentSign-1], false);
					end;
					setVisibility(self.signboard.signs[self.currentSign], true);	
				end;				
			end;
		end;		
		
		if self.switch then
            local x,y,z = getRotation(self.signboard.arrow);
			if math.abs(math.abs(z) - math.abs(self.signboard.min)) < 0.01 then
                self.signboard.angleOffset = self.signboard.angleOffset * -1;
            end;
            setRotation(self.signboard.arrow, x, y, z+ self.signboard.angleOffset);
			self.switch = false;
		end;		
	
		if self.signboard ~= nil then
			local x, y, z = getRotation(self.signboard.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.signboard.maxRot, self.signboard.minRot, 3, self.signboard.rotTime, dt, not self.isExpanded);
			setRotation(self.signboard.node, unpack(newRot));
		end;		
	end;

	if self.isLightActive then
		if self.currentTime < 0 then
			setVisibility(self.warningLights[1], not getVisibility(self.warningLights[1]));
			setVisibility(self.warningLights[2], not getVisibility(self.warningLights[2]));
			self.currentTime = self.intervall;
		end;
		if self.switchTime < 0 then
			if self.currentSign ~= 0 then
				setVisibility(self.signboard.signs[self.currentSign], not getVisibility(self.signboard.signs[self.currentSign]));			
				self.currentStatus = math.abs(self.currentStatus - 1);
				self.switchTime = self.blinkingSigns[self.currentStatus + 1];
			end;
		end;
		self.currentTime = self.currentTime - dt;
		self.switchTime = self.switchTime - dt;
	else
		self.currentTime = self.intervall;
		self.switchTime = self.blinkingSigns[2];
	end;	
end;

function BarrierTrailer:draw()
    if self.isExpanded then
		g_currentMission:addHelpButtonText(g_i18n:getText("Barrier_Trailer_unfold"), InputBinding.BARRIER_TRAILER_FOLD);
    else
		g_currentMission:addHelpButtonText(g_i18n:getText("Barrier_Trailer_fold"), InputBinding.BARRIER_TRAILER_FOLD);
    end;
    if self.isLightActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("Barrier_Trailer_lights_off"), InputBinding.BARRIER_TRAILER_LIGHTS);
    else
		g_currentMission:addHelpButtonText(g_i18n:getText("Barrier_Trailer_lights_on"), InputBinding.BARRIER_TRAILER_LIGHTS);
    end;
	g_currentMission:addHelpButtonText(g_i18n:getText("Barrier_Trailer_switch"), InputBinding.BARRIER_TRAILER_SWITCH);  
	g_currentMission:addHelpButtonText(g_i18n:getText("Barrier_Trailer_switch_sign"), InputBinding.BARRIER_TRAILER_SWITCH_SIGN); 
end;













