--
-- Volvo_FH12_kipper
-- Specialization for Volvo_FH12_kipper mod
--
-- @author  Stefan Geiger
-- @date  10/01/09
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Volvo_FH12_kipper = {};

function Volvo_FH12_kipper.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Volvo_FH12_kipper:load(xmlFile)
    hornSoundFile = Utils.getFilename("superHorn.wav", self.baseDirectory);
    self.hornSoundId = createSample("LizardHornSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;
end;

function Volvo_FH12_kipper:delete()
    delete(self.burnerSoundId);
end;

function Volvo_FH12_kipper:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Volvo_FH12_kipper:keyEvent(unicode, sym, modifier, isDown)
end;

function Volvo_FH12_kipper:update(dt)
	if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.Volvo_FH12_kipper_SILLYHORN) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
end;

function Volvo_FH12_kipper:draw()
    g_currentMission:addHelpButtonText(g_i18n:getText("Silly Horn"), InputBinding.Volvo_FH12_kipper_SILLYHORN);
end;

