-- volvoDoor
-- Henly20
-- 09-12-2010

volvoDoor = {};

function volvoDoor.prerequisitesPresent(specializations)
    return true;
end;

function volvoDoor:load(xmlFile)

	self.setRotationVD = SpecializationUtil.callSpecializationsFunction("setRotationVD");

	local rotationVDNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationVD#index"));
		if rotationVDNode ~= nil then
        self.rotationVD = {};
        self.rotationVD.node = rotationVDNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationVD#minRot"));
        self.rotationVD.minRot = {};
        self.rotationVD.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationVD.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationVD.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationVD#maxRot"));
        self.rotationVD.maxRot = {};
        self.rotationVD.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationVD.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationVD.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationVD.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationVD#rotTime"), 2)*1000;
        self.rotationVD.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationVD#touchRotLimit"), 10));
    end;

	self.rotationVDMax = false;

end;

function volvoDoor:readStream(streamId, connection)
     self.rotateVD = streamReadBool(streamId);

      if self.rotationVD ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
          setRotation(self.rotationVD.node, x, y, z);
      end;

end;

function volvoDoor:writeStream(streamId, connection)
	streamWriteBool(streamId, self.rotateVD);
		if self.rotationVD ~= nil then
          local x, y, z = getRotation(self.rotationVD.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;


end;

function volvoDoor:delete()


end;

function volvoDoor:mouseEvent(posX, posY, isDown, isUp, button)
end;

function volvoDoor:keyEvent(unicode, sym, modifier, isDown)

	

end;
function volvoDoor:update(dt)
      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.VOLVOBMDOOR) then
				self:setRotationVD(not self.rotationVDMax);
          end;
     end;
	
end;	

function volvoDoor:updateTick(dt)

	if self:getIsActive() and self.isClient then
		if self.rotationVD ~= nil then
			local x, y, z = getRotation(self.rotationVD.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationVD.maxRot, self.rotationVD.minRot, 3, self.rotationVD.rotTime, dt, not self.rotationVDMax);
			setRotation(self.rotationVD.node, unpack(newRot));
		end;
	end;
end;

function volvoDoor:draw()

end;

function volvoDoor:setRotationVD(rotationVDMax, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetRotationEventVD:new(self, rotationVDMax), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetRotationEventVD:new(self, rotationVDMax));
          end;
      end;
      self.rotationVDMax = rotationVDMax;
end;


SetRotationEventVD = {};
SetRotationEventVD_mt = Class(SetRotationEventVD, Event);
 
InitEventClass(SetRotationEventVD, "SetRotationEventVD");

function SetRotationEventVD:emptyNew()
      local self = Event:new(SetRotationEventVD_mt);
      self.className="SetRotationEventVD";
      return self;
end;
 
function SetRotationEventVD:new(object, rotationVDMax)
     local self = SetRotationEventVD:emptyNew()
     self.object = object;
     self.rotationVDMax = rotationVDMax;
      return self;
end;

function SetRotationEventVD:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
     self.rotationVDMax = streamReadBool(streamId);
     self.object = networkGetObject(id);
      self:run(connection);
end;
 
function SetRotationEventVD:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationVDMax);
end;

function SetRotationEventVD:run(connection)
     self.object:setRotationVD(self.rotationVDMax, true);
     if not connection:getIsServer() then
          g_server:broadcastEvent(SetRotationEventVD:new(self.object, self.rotationVDMax), nil, connection, self.object);
     end;
end;
