--
-- manualIgnition
-- Specialization for manual Motor Ignition
--
-- @author  Templaer
-- @date  01/05/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--
-- Edited Henly20 (Ls_uk Modteam) 18-12-2010 Ignition made MP compatible for the Manitou Telehandler

manualIgnition = {};

function manualIgnition.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function manualIgnition:load(xmlFile)
    -- Booleans
    self.ignitionKey = false;
	self.allowedIgnition = false;                                                  
	
    local aiMotorSound  = getXMLString(xmlFile, "vehicle.aiMotorSound#file");
    if aiMotorSound  ~= nil and aiMotorSound  ~= "" then
        aiMotorSound  = Utils.getFilename(aiMotorSound, self.baseDirectory);
        self.aiMotorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#pitchOffset"), 0);
        self.aiMotorSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#radius"), 50);
        self.aiMotorSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#innerRadius"), 10);
        self.aiMotorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#volume"), 1);
        self.aiMotorSound = createAudioSource("aiMotorSound", aiMotorSound, self.aiMotorSoundRadius, self.aiMotorSoundInnerRadius, self.aiMotorSoundVolume, 0);
        link(self.components[1].node, self.aiMotorSound);
        setVisibility(self.aiMotorSound, false);
    end;

	local motorStopSoundNew = getXMLString(xmlFile, "vehicle.motorStopSound#file");
	if motorStopSoundNew ~= nil and motorStopSoundNew ~= "" then
		motorStopSoundNew = Utils.getFilename(motorStopSoundNew, self.baseDirectory);
		self.motorStopSoundNew = createSample("motorStopSoundNew");
		loadSample(self.motorStopSoundNew, motorStopSoundNew, false);
		self.motorStopSoundNewPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#pitchOffset"), 0);
		self.motorStopSoundNewVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
	end;	
	self.playedMotorStopSoundNew = true;

	self.motorStopSoundVolume = 0;
	
	self.setIgnition = SpecializationUtil.callSpecializationsFunction("setIgnition");
	
	self.dashLights = {};
	self.dashLights[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.dashLights#index1"));
	self.dashLights[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.dashLights#index2"));
	self.dashLights[3] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.dashLights#index3"));
	
	self.batteryLightActive = false;
	self.oilLightActive = false;
	self.fuelLightActive = false;
	self.ignitionMode = 0;	
    self.isMotorStarted = false;
	self.keySwitchR	= false;
    self.isMotorStarted = false;
	
	self.keySwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.keySwitch#index"));	
	self.keySwitch1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.keySwitch1#index"));

	self.opneedle = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.oilpressure#index"));
	self.tempneedle = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.temp#index"));	

	self.opNeedleR = false;
	self.tempNeedleR = false;	

	local rotationPartNode13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart13#index"));
    if rotationPartNode13 ~= nil then
        self.rotationPart13 = {};
        self.rotationPart13.node = rotationPartNode13;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart13#minRot"));
        self.rotationPart13.minRot = {};
        self.rotationPart13.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart13.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart13.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart13#maxRot"));
        self.rotationPart13.maxRot = {};
        self.rotationPart13.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart13.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart13.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart13.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart13#rotTime"), 2)*1000;
        self.rotationPart13.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart13#touchRotLimit"), 10));
    end;
end;

function manualIgnition:delete()
end;

function manualIgnition:readStream(streamId, connection)
	local ignition = streamReadInt8(streamId);
	self:setIgnition(ignition, true);
end;

function manualIgnition:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.ignitionMode);	
end;

function manualIgnition:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manualIgnition:keyEvent(unicode, sym, modifier, isDown)
end;

function manualIgnition:update(dt)

	if self:getIsActiveForInput() then
		
			if InputBinding.hasEvent(InputBinding.VOLVOIGNITIONMODE) then
				if self.ignitionMode > 2 then
					self.ignitionMode = 0;
				end;
				self:setIgnition(math.abs(self.ignitionMode + 1));

			end;
			if InputBinding.isPressed(InputBinding.VOLVOIGNITIONMODE) and self.ignitionMode == 2 then
				setRotation(self.keySwitch1, 0, Utils.degToRad(-20), 0);
				else		
				setRotation(self.keySwitch1, 0, Utils.degToRad(0), 0);
			end;
	  end;
end;

function manualIgnition:updateTick(dt)

		acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
		if InputBinding.isAxisZero(acceleration) then
			acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
		end;
			-- Does not execute when AI is activated
		if not self.isHired then
				-- Handles ignition key input
			if self.ignitionKey and self.allowedIgnition then
			self:startMotor(true);
			self.allowedIgnition = false;
			self.deactivateOnLeave = false;
			self.steeringEnabled = true;
			Utils.setEmittingState(self.exhaustParticleSystems, true)
		elseif not self.ignitionKey and self.allowedIgnition then
			self:stopMotor(true);
			self.allowedIgnition = false;
			self.steeringEnabled = false;
			self.deactivateOnLeave = true;
			setVisibility(self.aiMotorSound, false);
			-- Brakes the wheels upon turning off the engine
			for k,wheel in pairs(self.wheels) do
				setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
			end;
			self:onDeactivateAttachements();
		end;

		if self.playedMotorStopSoundNew == false then
			playSample(self.motorStopSoundNew, 1, self.motorStopSoundNewVolume, 0);
			self.playedMotorStopSoundNew = true;
		end;
		-- Prevents the AI from driving when engine is off
		elseif not self.ignitionKey and not self.deactivateOnLeave then
			WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, 0, false, 0);
		end;
	
		local fuelWarning = 0.2*self.fuelCapacity;
		if self.fuelFillLevel < fuelWarning then
			self.fuelLightActive = true;
		else
			self.fuelLightActive = false;	
		end;
		if self.fuelFillLevel == 0 then
			self.ignitionKey = false;
			self.fuelLightActive = false;
			self.isMotorStarted = false;
			self:stopMotor(true);
			self.allowedIgnition = false;
			self.steeringEnabled = false;
			self.deactivateOnLeave = true;
			setVisibility(self.aiMotorSound, false);
			self.lastAcceleration = 0;
			if self.isServer then
				for k,wheel in pairs(self.wheels) do
					setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
				end;
			end;
		end;

		setVisibility(self.dashLights[1], self.batteryLightActive);
		setVisibility(self.dashLights[2], self.oilLightActive);
		setVisibility(self.dashLights[3], self.fuelLightActive);
	
		local maxfuelguage = 280;
			if self.rotationPart13 ~= nil then
				local x, y, z = getRotation(self.rotationPart13.node);
				y = ((self.rotationPart13.maxRot[2] - self.rotationPart13.minRot[2]) / maxfuelguage) * self.fuelFillLevel + self.rotationPart13.minRot[2];
				setRotation(self.rotationPart13.node, x, y ,z);
			end;
		if self.keySwitchR then
			setRotation(self.keySwitch, 0, Utils.degToRad(-20), 0);
		end;
		if not self.keySwitchR then
			setRotation(self.keySwitch, 0, Utils.degToRad(0), 0);
		end;
		
		if self.opNeedleR then
			setRotation(self.opneedle, 0, Utils.degToRad(-89), 0);
		end;
		if not self.opNeedleR then
			setRotation(self.opneedle, 0, Utils.degToRad(0), 0);
		end;
		if self.tempNeedleR then
			setRotation(self.tempneedle, 0, Utils.degToRad(-70), 0);
		end;
		if not self.tempNeedleR then
			setRotation(self.tempneedle, 0, Utils.degToRad(0), 0);
		end;
		
		local xt,yt,zt = getTranslation(self.components[1].node);
		local deltaWater = yt-g_currentMission.waterY+2.5;
		if deltaWater < 0 then
			self.ignitionMode = 0;
			self.ignitionKey = false;
			self:stopMotor(true);
			self.isMotorStarted = false;
			self.allowedIgnition = false;
			self.deactivateOnLeave = true;
			setVisibility(self.aiMotorSound, false);
			self.lastAcceleration = 0;
			if self.isServer then
				for k,wheel in pairs(self.wheels) do
					setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
				end;
			end;
		end;
        if self.ignitionMode == 2 and (not self:getIsActive() or self:getIsHired() or self:getIsActive()) then
            local fuelUsed = self.fuelUsage*0.3;
            self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
            g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
            g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		elseif self.isServer and self:getIsActive() then
            if not self:getIsHired() then
                if self.lastMovedDistance > 0 then
                      -- only use fuel if we are driving
                    local fuelUsed = self.lastMovedDistance*self.fuelUsage;
                    self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
  
                    g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
                    g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
  
                    g_currentMission.missionStats.traveledDistanceTotal = g_currentMission.missionStats.traveledDistanceTotal + self.lastMovedDistance*0.001; -- convert to km
                    g_currentMission.missionStats.traveledDistanceSession = g_currentMission.missionStats.traveledDistanceSession + self.lastMovedDistance*0.001;
                end;
           end;
        end;
		if self.ignitionMode == 0 or self.ignitionMode == 1 then
			self.isHired = false;
			self.isAITractorActivated = false;			
		end;
end;

function manualIgnition:onLeave()
    if not self.deactivateOnLeave then
	    Utils.setEmittingState(self.exhaustParticleSystems, true)
		self.allowedIgnition = false;
		self.isMotorStarted = true;
		self.ignitionKey = true; 
		self.steeringEnabled = false;
		setVisibility(self.aiMotorSound, true);
		
		-- Brakes the wheels upon turning off the engine
          self.lastAcceleration = 0;
          if self.isServer then
              for k,wheel in pairs(self.wheels) do
                  setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
              end;
          end;
	else
		self.allowedIgnition = false;
		self.isMotorStarted = false;
		self.ignitionKey = false;
		self.keySwitchR	= false;
		if self.ignitionMode == 0 or self.ignitionMode == 1 then
			setVisibility(self.aiMotorSound, false);
		end;
	end;	
end;

function manualIgnition:onEnter()
	-- Prevents the engine from starting upon entering
	if not self.ignitionKey then
		self.isMotorStarted = false;
		Motorized.stopSounds(self);
		self.steeringEnabled = false;
		Utils.setEmittingState(self.exhaustParticleSystems, false)
		if self.ignitionMode == 0 then
			setVisibility(self.aiMotorSound, false);
		end;
	else
		if self.ignitionMode == 2 then
			setVisibility(self.aiMotorSound, true);
			self.batteryLightActive = false;
			self.allowedIgnition = true;
			self.oilLightActive = false;
			self.ignitionKey = true;
			self.keySwitchR = true;
		end;
	end;
	
end;

function manualIgnition:draw()
end;

function manualIgnition:setIgnition(ignition, noEventSend)
	IgnitionEvent.sendEvent(self, ignition, noEventSend);

	self.ignitionMode = ignition;
    self.ignitionKey = false;

	self.keySwitchR = false;
	self.opNeedleR = false;
	self.tempNeedleR = false;
	self:stopMotor(true);
	self.allowedIgnition = false;
	self.steeringEnabled = false;
	self.deactivateOnLeave = true;
	setVisibility(self.aiMotorSound, false);
    self.lastAcceleration = 0;
    if self.isServer then
          for k,wheel in pairs(self.wheels) do
               setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
          end;
    end;

	if self.ignitionMode == 0 then
		self.batteryLightActive = false;
		self.oilLightActive = false;
		self.ignitionKey = false;
		self.allowedIgnition = false;  
		self.isMotorStarted = false;
		self.keySwitchR = false;
		self.opNeedleR = false;
		self.tempNeedleR = false;
	end;
	if self.ignitionMode == 1 then
		self.batteryLightActive = true;
		self.oilLightActive = true;
		self.ignitionKey = false;
		self.allowedIgnition = false;  
		self.isMotorStarted = false;
		self.keySwitchR = true;
		self.opNeedleR = false;
		self.tempNeedleR = false;
	end;
	if self.ignitionMode == 2 then
		self.batteryLightActive = false;
		self.allowedIgnition = true;
		self.oilLightActive = false;
		self.ignitionKey = true;
		self.keySwitchR = true;
		self.opNeedleR = true;
		self.tempNeedleR = true;
	end;
	if self.ignitionMode > 2 then
		self.ignitionMode = 0;
		self.allowedIgnition = false;
		self.ignitionKey = false;
		self:stopMotor(true);
		self.playedMotorStopSoundNew = false;
	end;
	if self.ignitionKey and self.allowedIgnition then
		self:startMotor(true);
		self.allowedIgnition = false;
		self.deactivateOnLeave = false;
		self.steeringEnabled = true;
		Utils.setEmittingState(self.exhaustParticleSystems, true)
	elseif not self.ignitionKey and self.allowedIgnition then
		self:stopMotor(true);
		self.allowedIgnition = false;
		self.steeringEnabled = false;
		self.deactivateOnLeave = true;
		setVisibility(self.aiMotorSound, false);
		-- Brakes the wheels upon turning off the engine
		for k,wheel in pairs(self.wheels) do
			setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
		end;
		self:onDeactivateAttachements();
	end;

end;

IgnitionEvent = {};
IgnitionEvent_mt = Class(IgnitionEvent, Event);

InitEventClass(IgnitionEvent, "IgnitionEvent");

function IgnitionEvent:emptyNew()
    local self = Event:new(IgnitionEvent_mt);
    self.className="IgnitionEvent";
    return self;
end;

function IgnitionEvent:new(vehicle, ignition)
    local self = IgnitionEvent:emptyNew()
    self.vehicle = vehicle;
	self.ignition = ignition;
    return self;
end;

function IgnitionEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.ignition = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function IgnitionEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.ignition);	
end;

function IgnitionEvent:run(connection)
	self.vehicle:setIgnition(self.ignition, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(IgnitionEvent:new(self.vehicle, self.ignition), nil, connection, self.object);
	end;
end;
function IgnitionEvent.sendEvent(vehicle, ignition, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(IgnitionEvent:new(vehicle, ignition), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(IgnitionEvent:new(vehicle, ignition));
		end;
	end;
end;

