--
-- Henly20 (Ls_uk Modteam)
-- 10.12.2010
--
-- > www.LS-UK.info


VolvoBMSP = {};

function VolvoBMSP.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations) and SpecializationUtil.hasSpecialization(BEL3, specializations);
end;

function VolvoBMSP:load(xmlFile)
   
	self.kinkJoint = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.kinkSteering#kinkJoint"), 0);
	self.kinkOrientation = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kinkSteering#wheelOrientation"));
	
	self.setArmOne = SpecializationUtil.callSpecializationsFunction("setArmOne");
	self.ArmOneAnimation = getXMLString(xmlFile, "vehicle.armOne#animationName");
	self.ArmOne = false;
	
	self.drivingShaft = {};
	self.drivingShaft[1] = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivingShaft#index"));
	self.drivingShaft[2] = Utils.indexToObject(self.components,getXMLString(xmlFile, "vehicle.drivingShaft#index2"));
	self.drivingShaft[3] = Utils.indexToObject(self.components,getXMLString(xmlFile, "vehicle.drivingShaft#index3"));
	
	local rotationPartNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart6#index"));
    if rotationPartNode6 ~= nil then
        self.rotationPart6 = {};
        self.rotationPart6.node = rotationPartNode6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#minRot"));
        self.rotationPart6.minRot = {};
        self.rotationPart6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#maxRot"));
        self.rotationPart6.maxRot = {};
        self.rotationPart6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#rotTime"), 2)*1000;
        self.rotationPart6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#touchRotLimit"), 10));
    end;

	local rotationPartNode9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart9#index"));
    if rotationPartNode9 ~= nil then
        self.rotationPart9 = {};
        self.rotationPart9.node = rotationPartNode9;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart9#minRot"));
        self.rotationPart9.minRot = {};
        self.rotationPart9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart9#maxRot"));
        self.rotationPart9.maxRot = {};
        self.rotationPart9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart9#rotTime"), 2)*1000;
        self.rotationPart9.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart9#touchRotLimit"), 10));
    end;
	local rotationPartNode10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart10#index"));
    if rotationPartNode10 ~= nil then
        self.rotationPart10 = {};
        self.rotationPart10.node = rotationPartNode10;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart10#minRot"));
        self.rotationPart10.minRot = {};
        self.rotationPart10.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart10.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart10.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart10#maxRot"));
        self.rotationPart10.maxRot = {};
        self.rotationPart10.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart10.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart10.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart10.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart10#rotTime"), 2)*1000;
        self.rotationPart10.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart10#touchRotLimit"), 10));
    end;
	local rotationPartNode11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart11#index"));
    if rotationPartNode11 ~= nil then
        self.rotationPart11 = {};
        self.rotationPart11.node = rotationPartNode11;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart11#minRot"));
        self.rotationPart11.minRot = {};
        self.rotationPart11.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart11.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart11.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart11#maxRot"));
        self.rotationPart11.maxRot = {};
        self.rotationPart11.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart11.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart11.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart11.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart11#rotTime"), 2)*1000;
        self.rotationPart11.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart11#touchRotLimit"), 10));
    end;
	local rotationPartNode12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart12#index"));
    if rotationPartNode12 ~= nil then
        self.rotationPart12 = {};
        self.rotationPart12.node = rotationPartNode12;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart12#minRot"));
        self.rotationPart12.minRot = {};
        self.rotationPart12.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart12.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart12.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart12#maxRot"));
        self.rotationPart12.maxRot = {};
        self.rotationPart12.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart12.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart12.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart12.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart12#rotTime"), 2)*1000;
        self.rotationPart12.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart12#touchRotLimit"), 10));
    end;
	
	self.workingLights = {};
	self.workingLights[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.workingLights#index1"));
	self.workingLights[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.workingLights#index2"));

	self.headlightsLightActive = false;
	self.backspotLightActive = false;
	
	self.switchLights = {};
	self.switchLights[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.switchLights#index1"));
	self.switchLights[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.switchLights#index2"));
	self.switchLights[3] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.switchLights#index3"));
	
	self.switchSpotLightsActive = false;
	self.switchHeadLightsActive = false;
	self.switchBeaconLightsActive = false;
	
	self.lightSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lightSwitch#index"));
	self.headlightSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.headlightSwitch#index"));
	self.beaconSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.beaconSwitch#index"));	
	self.onLever = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.onLever#index"));	
	self.hazardSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hazardSwitch#index"));	
	self.indicatorsLever = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indicatorsLever#index"));
	
	self.exhaustingSystem = {};	
	self.exhaustingSystem.cap = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dynamicExhaustingSystem#cap"));
	self.exhaustingSystem.maxRot = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dynamicExhaustingSystem#maxRot"),0));
	self.exhaustingSystem.maxRpm = self.motor:getMaxRpm();
	
	local startSequence = AnimCurve:new(linearInterpolator4);
	local i=0;
	while true do
		local path = string.format("vehicle.dynamicExhaustingSystem.startSequence.key(%d)", i);
		local timeStamp = getXMLFloat(xmlFile, path .. "#time");
		if timeStamp == nil then
			break;
		end;
		local r,g,b,alpha = Utils.getVectorFromString(getXMLString(xmlFile, path .. "#value"));
		startSequence:addKeyframe({x=r, y=g, z=b, w=alpha, time=timeStamp})		
		i = i + 1;
	end;
	
	self.exhaustingSystem.minAlpha = math.min(math.abs(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dynamicExhaustingSystem#minAlpha"),0)),1);
	self.exhaustingSystem.maxAlpha = math.min(math.abs(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dynamicExhaustingSystem#maxAlpha"),1)),1);
	local x1,y1,z1,w1 = startSequence:get(1.0);
	self.exhaustingSystem.startSequence = startSequence;
	self.exhaustingSystem.lastValue = {x=x1,y=y1,z=z1,w=w1};
	self.exhaustingSystem.param = getXMLString(xmlFile, "vehicle.dynamicExhaustingSystem#param");
	self.exhaustingSystem.offset = 0;
	self.exhaustingSystem.deltaTime = 0;

	self.rotationMax9Active = false;
    self.printWarningTime = 0;
	
    local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	self.finishWiper = true;
end;

function VolvoBMSP:delete()
	if self.SeatPlaying ~= nil then
		stopSample(self.SeatSoundId);
	end;
	
end;

function VolvoBMSP:readStream(streamId, connection)
    self:setArmOne(streamReadBool(streamId), true);
end;

function VolvoBMSP:writeStream(streamId, connection)
	streamWriteBool(streamId, self.ArmOne);

end;

function VolvoBMSP:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VolvoBMSP:keyEvent(unicode, sym, modifier, isDown)
	if self.isMotorStarted then

		if sym == Input.KEY_w then
			self.rotationMax6 = isDown;
		end;
		if sym == Input.KEY_s then
			self.rotationMin6 = isDown;
		end;
	end;

end;

function VolvoBMSP:update(dt)

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) and not self.isTurnedOn and self.isMotorStarted == true then
			self:setArmOne(not self.isArmOneOn);
		end;
	end;
	
		if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) and self.isArmOneOn then
			self.printWarningTime = self.time + 1500;
		end;

	if self:getIsActive() and self.isClient then
	if self.lightsActive then
		setRotation(self.headlightSwitch, Utils.degToRad(15),0,0);
        self.lightsActiveR = true;
		self.switchHeadLightsActive = true;
		self.headlightsLightActive = true;
		self.headlightSwitchR = true;
	end;
	if not self.lightsActive then
		setRotation(self.headlightSwitch, Utils.degToRad(1),0,0);
        self.lightsActiveR = false;
		self.switchHeadLightsActive = false;
		self.headlightsLightActive = false;
		self.headlightSwitchR = false;
	end;
	if self.beaconLightsActive then
		self.switchBeaconLightsActive = true;
		setRotation(self.beaconSwitch, Utils.degToRad(18),0,0);
		else
		setRotation(self.beaconSwitch, Utils.degToRad(0),0,0);
		self.switchBeaconLightsActive = false;
	end;
	if self.isTurnedOn then
		setRotation(self.onLever, Utils.degToRad(35),0,0);
		else
		setRotation(self.onLever, Utils.degToRad(0),0,0);
	end;
	

	local i = 1;
	if self.B3.work[i].a then
		setRotation(self.lightSwitch, Utils.degToRad(18),0,0);
		self.lightSwitchR = true;
		self.switchSpotLightsActive = true;
		self.backspotLightActive = true;
		else
		setRotation(self.lightSwitch, Utils.degToRad(0),0,0);
		self.lightSwitchR = false;
		self.switchSpotLightsActive = false;
		self.backspotLightActive = false;
	end;
	
	if self.B3.wl then
		setRotation(self.hazardSwitch, Utils.degToRad(18),0,0);
		else
		setRotation(self.hazardSwitch, Utils.degToRad(0),0,0);	
	end;
	
	if self.indicatorsLever ~= nil then
			if not self.B3.wl then
				if self.B3.dirRight[1].a then
					setRotation(self.indicatorsLever, 0, math.rad(-20), math.rad(0));
				elseif self.B3.dirLeft[1].a then
					setRotation(self.indicatorsLever, 0, math.rad(20), math.rad(0));
				else
					setRotation(self.indicatorsLever, 0, 0, math.rad(0));
				end;
			else
				setRotation(self.indicatorsLever, 0, 0, math.rad(0));
			end;
	end;
	
	   if self.drivingShaft[1] ~= nil then
			local x,y,z = getRotation(self.wheels[1].driveNode);
			setRotation(self.drivingShaft[1], 0 ,0, x*-2);	
			setRotation(self.drivingShaft[2], 0 ,0, x*-2);
			setRotation(self.drivingShaft[3], 0 ,0, x*-2);			
		end;
	end;
end;

function VolvoBMSP:updateTick(dt)

	if self.isMotorStarted then
		if self.kinkJoint ~= 0 then
			setJointFrame(self.componentJoints[self.kinkJoint].jointIndex , 0, self.componentJoints[self.kinkJoint].jointNode);   
			local x, y, z = getRotation(self.kinkOrientation);	    
			setRotation(self.kinkOrientation, 0,y,0);
		end;
	end;
	
	if self:getIsActive() and self.isClient then
		if not self.isMotorStarted then
			self:setIsTurnedOn(false);
		end;
		
		if self.isArmOneOn then
			self:setIsTurnedOn(false);
		end;
		inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;
		
		if self.isEntered ~= nil then
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.rotationMax9Active = true;
		else
			self.rotationMax9Active = false;
		end;
		end; 	
		
		if self.rotationPart6 ~= nil and (self.rotationMax6 or self.rotationMin6) then
			local x, y, z = getRotation(self.rotationPart6.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart6.maxRot, self.rotationPart6.minRot, 3, self.rotationPart6.rotTime, dt, not self.rotationMax6);
			setRotation(self.rotationPart6.node, unpack(newRot));
		end;

		if self.rotationPart9 ~= nil then
			local x, y, z = getRotation(self.rotationPart9.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart9.maxRot, self.rotationPart9.minRot, 3, self.rotationPart9.rotTime, dt, not self.rotationMax9Active);
			setRotation(self.rotationPart9.node, unpack(newRot));
		end;
		local maxfootthrottle = 2100;
		if self.rotationPart10 ~= nil and self.isMotorStarted == true then
				local x, y, z = getRotation(self.rotationPart10.node);
				x = ((self.rotationPart10.maxRot[1] - self.rotationPart10.minRot[1]) / maxfootthrottle) * self.motor.lastMotorRpm + self.rotationPart10.minRot[1];
				setRotation(self.rotationPart10.node, x, y ,z);
		elseif self.isMotorStarted == false then
			setRotation(self.rotationPart10.node, 0, 0 ,0);
		end;
		local maxrpmguage = 2100;
		if self.rotationPart11 ~= nil and self.isMotorStarted == true then
				local x, y, z = getRotation(self.rotationPart11.node);
				y = ((self.rotationPart11.maxRot[2] - self.rotationPart11.minRot[2]) / maxrpmguage) * (self.motor.lastMotorRpm+400) + self.rotationPart11.minRot[2];
				setRotation(self.rotationPart11.node, x, y ,z);
		elseif self.isMotorStarted == false then
			setRotation(self.rotationPart11.node, 0, 0 ,0);
		end;
		local maxspeedguage = 40;
		local speed = self.lastSpeed*3600;
			if self.rotationPart12 ~= nil then
				local x, y, z = getRotation(self.rotationPart12.node);
				y = ((self.rotationPart12.maxRot[2] - self.rotationPart12.minRot[2]) / maxspeedguage) * speed + self.rotationPart12.minRot[2];
				setRotation(self.rotationPart12.node, x, y ,z);
			end;
		
	if self.isMotorStarted == true then
		if not self.isMotorStarted then
			self.motor.lastMotorRpm = 0;
		end;
		if self.exhaustingSystem.cap ~= nil then
			local angle = math.rad(math.random(-20,5)) + self.exhaustingSystem.maxRot * self.motor.lastMotorRpm / self.exhaustingSystem.maxRpm;	
			angle = math.max(math.min(angle, 0), self.exhaustingSystem.maxRot);		
			setRotation(self.exhaustingSystem.cap, 0,0,angle);
		end;
		
		if self.time <= self.playMotorSoundTime then
			local time = (self.exhaustingSystem.deltaTime - (self.playMotorSoundTime - self.time)) / self.exhaustingSystem.deltaTime;
			local x1,y1,z1,w1 = self.exhaustingSystem.startSequence:get(time);
			local values = self.exhaustingSystem.lastValue;
			if math.abs(values.x - x1) > 0.01 or math.abs(values.y - y1) > 0.01 or math.abs(values.z - z1) > 0.01 or math.abs(values.w - w1) > 0.01 then
				setShaderParameter(self.exhaustParticleSystems[1].shape, self.exhaustingSystem.param, x1, y1, z1, w1, false);
				self.exhaustingSystem.lastValue = {x=x1, y=y1, z=z1, w=w1};
			end;
		else
			local alpha = ((self.exhaustingSystem.maxAlpha-self.exhaustingSystem.minAlpha) * self.motor.lastMotorRpm / self.exhaustingSystem.maxRpm)+self.exhaustingSystem.minAlpha;
			if math.abs(self.exhaustingSystem.lastValue.w - alpha) > 0.01 then
				local values = self.exhaustingSystem.lastValue;
				setShaderParameter(self.exhaustParticleSystems[1].shape, self.exhaustingSystem.param, values.x, values.y, values.z, alpha, false);
				self.exhaustingSystem.lastValue.w = alpha;
			end;
		end;
	end;

	setVisibility(self.switchLights[1], self.switchSpotLightsActive);	
	setVisibility(self.switchLights[2], self.switchHeadLightsActive);
	setVisibility(self.switchLights[3], self.switchBeaconLightsActive);	
	setVisibility(self.workingLights[1], self.headlightsLightActive);
 	setVisibility(self.workingLights[2], self.backspotLightActive); 
	
	if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);			
				self.finishWiper = true;
			end;			
		end;	
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;		  
	end;
end

function VolvoBMSP:attachImplement(implement)
	
	
end;

function VolvoBMSP:draw()
    if self.isClient then
		if self.isMotorStarted and not self.isTurnedOn then
			if self.isArmOneOn then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("close"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("open"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			end;
		end;
		if self.printWarningTime > self.time then
			g_currentMission:addWarning(g_i18n:getText("turnON_Error"), 0.018, 0.033);
		end;
	end;
end;

function VolvoBMSP:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function VolvoBMSP:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);	
	end;  
end;

function VolvoBMSP:startMotor()
	self.exhaustingSystem.deltaTime = self.playMotorSoundTime - self.time - self.exhaustingSystem.offset;
end;

function VolvoBMSP:onLeave()
	if self.exhaustingSystem.cap ~= nil then
		setRotation(self.exhaustingSystem.cap, 0,0,0);
	end;
 	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;

function VolvoBMSP:setArmOne(isArmOne,noEventSend)
	SetArmOneEvent.sendEvent(self, isArmOne, noEventSend);
	-- Play ArmOne animation --
	self.isArmOneOn = isArmOne;
	if self.isArmOneOn then
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, 1, nil, true);
			self.ArmOne = true;
		end;
	else
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, -1, nil, true);
			self.ArmOne = false;
		end;
	end;	
end;

SetArmOneEvent = {};
SetArmOneEvent_mt = Class(SetArmOneEvent, Event);

InitEventClass(SetArmOneEvent, "SetArmOneEvent");

function SetArmOneEvent:emptyNew()
    local self = Event:new(SetArmOneEvent_mt);
    self.className="SetArmOneEvent";
    return self;
end;

function SetArmOneEvent:new(vehicle, isArmOne)
    local self = SetArmOneEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmOne = isArmOne;
    return self;
end;

function SetArmOneEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmOne = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmOneEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmOne);
end;

function SetArmOneEvent:run(connection)   
	self.vehicle:setArmOne(self.isArmOne, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmOneEvent:new(self.vehicle, self.isArmOne), nil, connection, self.vehicle);
    end;
end;

function SetArmOneEvent.sendEvent(vehicle, isArmOne, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmOneEvent:new(vehicle, isArmOne), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmOneEvent:new(vehicle, isArmOne));
		end;
	end;
end;

