--
-- Iveco Crane Working Script
--
-- by Zippo
-- 


ICrane = {}

function ICrane.prerequisitesPresent(specializations)
	Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function ICrane:load(xmlFile)
    print("Chargement iacrane debut");
	print("verin debut");
	
	
    
    self.verin1 = {};
	self.verin1.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#indexverin"));
	self.verin1.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#indextige"));
	self.verin1.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin1.tige);
    local bx, by, bz = getWorldTranslation(self.verin1.translationtige);
    self.verin1.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	
	self.verin2 = {};
	self.verin2.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin2#indexverin"));
	self.verin2.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin2#indextige"));
	self.verin2.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin2#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin2.tige);
    local bx, by, bz = getWorldTranslation(self.verin2.translationtige);
    self.verin2.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	print("verin fin");
	
	local rotationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
        self.rotation1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#touchRotLimit"), 10));
    end;

hydra1SoundFile = Utils.getFilename("Sounds/hydra1.wav", self.baseDirectory);
    self.hydra1SoundId = createSample("HYD1_hydra1");
    loadSample(self.hydra1SoundId, hydra1SoundFile, false);
    self.hydra1Playing = false;
	print("Chargement iacrane fin");

end;
      
function ICrane:delete()
end;

function ICrane:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function ICrane:keyEvent(unicode, sym, modifier, isDown)

	if sym == Input.KEY_KP_4 then
		self.rotation1Max = isDown;
	end;
	if sym == Input.KEY_KP_7 then
		self.rotation1Min = isDown;
	end;


end;

function ICrane:update(dt)
	
	print("update debut");
	local doRotate = self.rotation1Max or self.rotation1Min 
	if self.rotation1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        print("commence la rotation");
		setRotation(self.rotation1.node, unpack(newRot));
        if not self.hydra1Playing then
			print("play sample");
            playSample(self.hydra1SoundId, 0, 1, 0);
            self.hydra1Playing = true;
        end;
    else
        if self.hydra1Playing then
		print("stop sample");
            stopSample(self.hydra1SoundId);
            self.hydra1Playing = false;
        end;
    end;
	print("refresh joint");
--	local joint = self.componentJoints[4];
--		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	if self.verin2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin2.node);
		local bx, by, bz = getWorldTranslation(self.bras2.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin2.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin2.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.verin2.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin2.tige, 0, 0, (distance-self.verin2.tigeDistance)*-1);
		end;
	end;
	if self.verin1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin1.node);
		local bx, by, bz = getWorldTranslation(self.bras1.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin1.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin1.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.verin1.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin1.tige, 0, 0, (distance-self.verin1.tigeDistance)*-1);
		end;
	end;
	
end;

function ICrane:draw()
end;

function ICrane:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
