--
-- liftachse1
-- Specialization for Liftaxle
-- Spezialisierung fr liftachse1
-- @Anpassung  VWFahrer80
-- 
-- frei verwendbar - keine erlaubnis ntig  |  free for use - no permission needed.
-- Modifikationen erst nach Rcksprache!    |  modifications only with my permission.
liftachse1 = {};

function liftachse1.prerequisitesPresent(specializations)
    print("MAN TGX 41.680 is loaded");
    return true;
end;

function liftachse1:load(xmlFile)
	self.isActor = false;
	self.setliftachse1 = SpecializationUtil.callSpecializationsFunction("setliftachse1");
	local achse = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.achse#index"));
	if achse ~= nil then
		self.achse = {};
		self.achse.node = achse;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.achse#minRot"));
		self.achse.minRot = {};
		self.achse.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.achse.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.achse.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.achse#maxRot"));
		self.achse.maxRot = {};
		self.achse.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.achse.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.achse.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		self.achse.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.achse#rotTime"), 1)*1000;
		self.supportTrans1 = {};
		self.supportTrans1.node = achse;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.achse#minTrans"));
		self.supportTrans1.minRot = {};
		self.supportTrans1.minRot[1] = x;
		self.supportTrans1.minRot[2] = y;
		self.supportTrans1.minRot[3] = z;
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.achse#maxTrans"));
		self.supportTrans1.maxRot = {};
		self.supportTrans1.maxRot[1] = x;
		self.supportTrans1.maxRot[2] = y;
		self.supportTrans1.maxRot[3] = z;
		self.supportTrans1.rotTime = self.achse.rotTime;
	end;
	
	self.liftachse1An = true;
end;



function liftachse1:keyEvent(unicode, sym, modifier, isDown)
end;

function liftachse1:update(dt)
		if InputBinding.hasEvent(InputBinding.liftachse1) and self:getIsActiveForInput() then
			self.liftachse1An = not self.liftachse1An;
			liftachse1Event.sendEvent(self, self.liftachse1An);
		end;
end;

function liftachse1:updateTick(dt)
	if self.liftachse1An ~= nil then	
		if self.liftachse1An then
			local x, y, z = getTranslation(self.supportTrans1.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.supportTrans1.maxRot, self.supportTrans1.minRot, 3, self.supportTrans1.rotTime, dt, true);
			setTranslation(self.supportTrans1.node, unpack(newTrans));
			if math.abs(self.supportTrans1.minRot[1]-newTrans[1]) < 0.001 then
				local x, y, z = getRotation(self.achse.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.achse.maxRot, self.achse.minRot, 3, self.achse.rotTime, dt, true);
				setRotation(self.achse.node, unpack(newRot));
			end;
		else
			local x, y, z = getRotation(self.achse.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.achse.maxRot, self.achse.minRot, 3, self.achse.rotTime, dt, false);
			setRotation(self.achse.node, unpack(newRot));
			if math.abs(self.achse.maxRot[1]-newRot[1]) < 0.001 then
				local x, y, z = getTranslation(self.supportTrans1.node);
				local trans = {x,y,z};
				local newTrans = Utils.getMovedLimitedValues(trans, self.supportTrans1.maxRot, self.supportTrans1.minRot, 3, self.supportTrans1.rotTime, dt, false);
				setTranslation(self.supportTrans1.node, unpack(newTrans));
			end;
		end;
		for i, jointDesc in pairs(self.componentJoints) do
			setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
	end;
end;

function liftachse1:draw()
	if self.liftachse1An then
		g_currentMission:addExtraPrintText(string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.liftachse1))..":                  " .."Randon Subir Eixo");
	else
		g_currentMission:addExtraPrintText(string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.liftachse1))..":                  " .."Ranon Abaixar Eixo");
	end;
end;
function liftachse1:readStream(streamId, connection)
	self.liftachse1An = streamReadBool(streamId);
end;

function liftachse1:writeStream(streamId, connection)
	streamWriteBool(streamId, self.liftachse1An);
end;
function liftachse1:mouseEvent(posX, posY, isDown, isUp, button)
end;

function liftachse1:delete()
end;

function liftachse1:onDetach()
	if not self.liftachse1An then
		self.liftachse1An = not self.liftachse1An;
		liftachse1Event.sendEvent(self, self.liftachse1An);
	end;
end;