--mtz valt
--powered by hz888


Powershift = {};

function Powershift.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Powershift:load(xmlFile)
    local rotationPartNodeMarchaR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.MarchaR#index"));
    if rotationPartNodeMarchaR ~= nil then
        self.rotationPartMarchaR = {};
        self.rotationPartMarchaR.node = rotationPartNodeMarchaR;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.MarchaR#minRot"));
        self.rotationPartMarchaR.minRot = {};
        self.rotationPartMarchaR.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarchaR.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarchaR.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.MarchaR#maxRot"));
        self.rotationPartMarchaR.maxRot = {};
        self.rotationPartMarchaR.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarchaR.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarchaR.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarchaR.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.MarchaR#rotTime"), 2)*1000;
        self.rotationPartMarchaR.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.MarchaR#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeMarcha1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Marcha1#index"));
    if rotationPartNodeMarcha1 ~= nil then
        self.rotationPartMarcha1 = {};
        self.rotationPartMarcha1.node = rotationPartNodeMarcha1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Marcha1#minRot"));
        self.rotationPartMarcha1.minRot = {};
        self.rotationPartMarcha1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarcha1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarcha1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Marcha1#maxRot"));
        self.rotationPartMarcha1.maxRot = {};
        self.rotationPartMarcha1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarcha1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarcha1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarcha1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Marcha1#rotTime"), 2)*1000;
        self.rotationPartMarcha1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Marcha1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeMarcha2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Marcha2#index"));
    if rotationPartNodeMarcha2 ~= nil then
        self.rotationPartMarcha2 = {};
        self.rotationPartMarcha2.node = rotationPartNodeMarcha2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Marcha2#minRot"));
        self.rotationPartMarcha2.minRot = {};
        self.rotationPartMarcha2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarcha2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarcha2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Marcha2#maxRot"));
        self.rotationPartMarcha2.maxRot = {};
        self.rotationPartMarcha2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarcha2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarcha2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarcha2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Marcha2#rotTime"), 2)*1000;
        self.rotationPartMarcha2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Marcha2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeMarcha3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Marcha3#index"));
    if rotationPartNodeMarcha3 ~= nil then
        self.rotationPartMarcha3 = {};
        self.rotationPartMarcha3.node = rotationPartNodeMarcha3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Marcha3#minRot"));
        self.rotationPartMarcha3.minRot = {};
        self.rotationPartMarcha3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarcha3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarcha3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Marcha3#maxRot"));
        self.rotationPartMarcha3.maxRot = {};
        self.rotationPartMarcha3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarcha3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarcha3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarcha3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Marcha3#rotTime"), 2)*1000;
        self.rotationPartMarcha3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Marcha3#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeMarcha4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Marcha4#index"));
    if rotationPartNodeMarcha4 ~= nil then
        self.rotationPartMarcha4 = {};
        self.rotationPartMarcha4.node = rotationPartNodeMarcha4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Marcha4#minRot"));
        self.rotationPartMarcha4.minRot = {};
        self.rotationPartMarcha4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarcha4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarcha4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Marcha4#maxRot"));
        self.rotationPartMarcha4.maxRot = {};
        self.rotationPartMarcha4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarcha4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarcha4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarcha4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Marcha4#rotTime"), 2)*1000;
        self.rotationPartMarcha4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Marcha4#touchRotLimit"), 10));
    end;
	local rotationPartNodeMarcha5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Marcha5#index"));
    if rotationPartNodeMarcha5 ~= nil then
        self.rotationPartMarcha5 = {};
        self.rotationPartMarcha5.node = rotationPartNodeMarcha5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Marcha5#minRot"));
        self.rotationPartMarcha5.minRot = {};
        self.rotationPartMarcha5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarcha5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarcha5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Marcha5#maxRot"));
        self.rotationPartMarcha5.maxRot = {};
        self.rotationPartMarcha5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarcha5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarcha5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarcha5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Marcha5#rotTime"), 2)*1000;
        self.rotationPartMarcha5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Marcha5#touchRotLimit"), 10));
    end;

    self.gearfile = Utils.getFilename("gearhud.png", self.baseDirectory);
    self.hudGearWidth = 0.230;
    self.hudGearHeight = 0.260;
    self.hudGearPoxX = 0.798;
    self.hudGearPoxY = 0.599;
    self.hudGearOverlay = Overlay:new("hudGearpanel", self.gearfile, self.hudGearPoxX, self.hudGearPoxY, self.hudGearWidth, self.hudGearHeight);

    self.brakeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.brakeLight#index"));
    if self.brakeLight ~= nil then
	setVisibility(self.brakeLight, false);
    end;
    self.kardan1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kardan1#index"));
    self.kardan2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kardan2#index"));
    self.brakeLightActive = false;
    self.motorMaxRpmLimit = self.motor.maxRpm;
    self.motormaxi = math.max(self.motor.maxRpm[1], self.motor.maxRpm[2], self.motor.maxRpm[3], self.motor.maxRpm[4]);
    self.motormax = {self.motor.maxRpm[1], self.motor.maxRpm[2], self.motor.maxRpm[3], self.motor.maxRpm[4]};
    self.motormaxr = {self.motor.maxRpm[1]*2, self.motor.maxRpm[2]*1.5, self.motor.maxRpm[3], self.motor.maxRpm[4]};
    self.fGearRatios = self.motor.forwardGearRatios;
    self.bGearRatio = self.motor.backwardGearRatio;
    self.bForce = self.motor.brakeForce;
    self.level = 0;
    self.ok = true;
    self.reverse = false;
    self.gang0 = true;
    self.gang1 = false;
    self.off = false;
    self.isSlow = false;
    self.isFast = true;

    self.forwardTorqueCurve1 = AnimCurve:new(linearInterpolator1);
    self.forwardTorqueCurve1s = AnimCurve:new(linearInterpolator1);
    self.forwardTorqueCurve2 = AnimCurve:new(linearInterpolator1);
    self.forwardTorqueCurve2s = AnimCurve:new(linearInterpolator1);
    self.forwardTorqueCurve3 = AnimCurve:new(linearInterpolator1);
    self.forwardTorqueCurve3s = AnimCurve:new(linearInterpolator1);
    self.forwardTorqueCurve4 = AnimCurve:new(linearInterpolator1);
    self.forwardTorqueCurve4s = AnimCurve:new(linearInterpolator1);
    self.forwardTorqueCurve5 = AnimCurve:new(linearInterpolator1);
    self.forwardTorqueCurve0 = AnimCurve:new(linearInterpolator1);

    self.backwardTorqueCurve1 = AnimCurve:new(linearInterpolator1);    
    self.backwardTorqueCurve2 = AnimCurve:new(linearInterpolator1);
    self.backwardTorqueCurve0 = AnimCurve:new(linearInterpolator1);
    local torqueI = 0;
    while true do
        local key = string.format("vehicle.motor.backwardTorque(%d)", torqueI);
        local rpm = getXMLFloat(xmlFile, key.."#rpm");
        local torque = getXMLFloat(xmlFile, key.."#torque");
        if torque == nil or rpm == nil then
            break;
        end;
        self.backwardTorqueCurve1:addKeyframe({v=(torque*2)*3, time = rpm});
        self.backwardTorqueCurve2:addKeyframe({v=(torque*4)*3, time = rpm});
        self.backwardTorqueCurve0:addKeyframe({v=(torque*16)*3, time = rpm});
        torqueI = torqueI +1;
    end;
    local torqueI = 0;
    while true do
        local key = string.format("vehicle.motor.torque(%d)", torqueI);
        local rpm = getXMLFloat(xmlFile, key.."#rpm");
        local torque = getXMLFloat(xmlFile, key.."#torque");
        if torque == nil or rpm == nil then
            break;
        end;
	if torqueI < 2 then
        	self.forwardTorqueCurve1:addKeyframe({v=(torque/2)*3, time = rpm});
        	self.forwardTorqueCurve1s:addKeyframe({v=(torque/5)*3, time = rpm});
        	self.forwardTorqueCurve0:addKeyframe({v=(torque*4.5)*3, time = rpm});
	else
        	self.forwardTorqueCurve1:addKeyframe({v=(torque/5)*3, time = rpm});
        	self.forwardTorqueCurve1s:addKeyframe({v=(torque/10)*3, time = rpm});
        	self.forwardTorqueCurve0:addKeyframe({v=(torque*3.5)*3, time = rpm});
	end;
	if torqueI < 1 then
        	self.forwardTorqueCurve5:addKeyframe({v=(torque*3)*3, time = rpm});
	else
        	self.forwardTorqueCurve5:addKeyframe({v=(torque*3.5)*3, time = rpm});
	end;
        self.forwardTorqueCurve2:addKeyframe({v=(torque/2)*3, time = rpm});
        self.forwardTorqueCurve2s:addKeyframe({v=(torque/3)*3, time = rpm});
        self.forwardTorqueCurve3:addKeyframe({v=torque*3, time = rpm});
        self.forwardTorqueCurve3s:addKeyframe({v=(torque/2)*3, time = rpm});
        self.forwardTorqueCurve4:addKeyframe({v=(torque*2)*3, time = rpm});
        self.forwardTorqueCurve4s:addKeyframe({v=(torque)*3, time = rpm});
        torqueI = torqueI +1;
    end;


end;

function Powershift:delete()

    if self.hudGearOverlay~= nil then
        self.hudGearOverlay:delete();
    end;

end;

function Powershift:mouseEvent(posX, posY, isDown, isUp, button)

    self.lastMouseXPos = posX;
    self.lastMouseYPos = posY;
    if not self.off then
	if not self.kuplung then
	    if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_LEFT) and not self.isAITractorActivated then

		if self.reverse then
			self.gang0 = true;
			self.reverse = false;
			self.rotationMaxMarchaR = false;
		elseif self.gang0 then
			if self.isFast then
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve1;
			else
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve1s;
			end;
			self.gang1 = true;
			self.gang0 = false;
			self.rotationMaxMarcha1 = true;
		elseif self.gang1 then
			if self.isFast then
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve2;
			else
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve2s;
			end;
			self.gang2 = true;
			self.gang1 = false;
			self.rotationMaxMarcha1 = false;
			self.rotationMaxMarcha2 = true;
		elseif self.gang2 then
			if self.isFast then
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve3;
			else
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve3s;
			end;
			self.gang3 = true;
			self.gang2 = false;
			self.rotationMaxMarcha2 = false;
			self.rotationMaxMarcha3 = true;
		elseif self.gang3 then
			if self.isFast then
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve4;
			else
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve4s;
			end;
			self.gang4 = true;
			self.gang3 = false;
			self.rotationMaxMarcha3 = false;
			self.rotationMaxMarcha4 = true;
		elseif self.gang4 then
			if self.isFast then
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve5;
				self.gang5 = true;
				self.gang4 = false;
				self.rotationMaxMarcha4 = false;
			    self.rotationMaxMarcha5 = true;
			else
				self.gang5 = false;
				self.gang4 = true;
			end;				
		end;
	    end;

	    if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_RIGHT) and not self.isAITractorActivated then
		if self.gang5 then
			if self.isFast then
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve4;
			else
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve4s;
			end;
			self.gang4 = true;
			self.gang5 = false;
			self.rotationMaxMarcha5 = false;
			self.rotationMaxMarcha4 = true;
		elseif self.gang4 then
			if self.isFast then
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve3;
			else
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve3s;
			end;
			self.gang3 = true;
			self.gang4 = false;
			self.rotationMaxMarcha3 = true;
			self.rotationMaxMarcha4 = false;
		elseif self.gang3 then
			if self.isFast then
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve2;
			else
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve2s;
			end;
			self.gang2 = true;
			self.gang3 = false;
			self.rotationMaxMarcha2 = true;
			self.rotationMaxMarcha3 = false;
		elseif self.gang2 then
			if self.isFast then
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve1;
			else
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve1s;
			end;
			self.gang1 = true;
			self.gang2 = false;
			self.rotationMaxMarcha1 = true;
			self.rotationMaxMarcha2 = false;
		elseif self.gang1 then
			self.gang0 = true;
			self.gang1 = false;
			self.rotationMaxMarcha1 = false;
		elseif self.gang0 then
			if self.isFast then
				self.motor.backwardTorqueCurve = self.backwardTorqueCurve2;
			else
				self.motor.backwardTorqueCurve = self.backwardTorqueCurve1;
			end;
			self.reverse = true;
			self.gang0 = false;
			self.rotationMaxMarchaR = true;
		end;
	    end;
	else
		if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_RIGHT) and not self.isAITractorActivated then
		    if not self.reverse then
			if self.gang5 then
				self.gang5k = true;
				self.gang5 = false;
			else
				self.gang5k = false;
			end;
			if self.gang4 then
				self.gang4k = true;
				self.gang4 = false;
			else
				self.gang4k = false;
			end;
			if self.gang3  then
				self.gang3k = true;
				self.gang3 = false;
			else
				self.gang3k = false;
			end;
			if self.gang2 then
				self.gang2k = true;
				self.gang2 = false;
			else
				self.gang2k = false;
			end;
			if self.gang1 then
				self.gang1k = true;
				self.gang1 = false;
			else
				self.gang1k = false;
			end;
		    end;
			if self.isFast then
				self.motor.backwardTorqueCurve = self.backwardTorqueCurve2;
			else
				self.motor.backwardTorqueCurve = self.backwardTorqueCurve1;
			end;
			
			self.reverse = true;
		end;
		if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_LEFT) and not self.isAITractorActivated then
			self.reverse = false;
			self.gang1 = self.gang1k;
			self.gang2 = self.gang2k;
			self.gang3 = self.gang3k;
			self.gang4 = self.gang4k;
			self.gang5 = self.gang5k;
			if self.gang1 then
				if self.isFast then
					self.motor.forwardTorqueCurve = self.forwardTorqueCurve1;
				else
					self.motor.forwardTorqueCurve = self.forwardTorqueCurve1s;
				end;
			elseif self.gang2 then
				if self.isFast then
					self.motor.forwardTorqueCurve = self.forwardTorqueCurve2;
				else
					self.motor.forwardTorqueCurve = self.forwardTorqueCurve2s;
				end;
			elseif self.gang3 then
				if self.isFast then
					self.motor.forwardTorqueCurve = self.forwardTorqueCurve3;
				else
					self.motor.forwardTorqueCurve = self.forwardTorqueCurve3s;
				end;
			elseif self.gang4 then
				if self.isFast then
					self.motor.forwardTorqueCurve = self.forwardTorqueCurve4;
				else
					self.motor.forwardTorqueCurve = self.forwardTorqueCurve4s;
				end;
			elseif self.gang5 then
				self.motor.forwardTorqueCurve = self.forwardTorqueCurve5;
			end;	
		
		end;
	end;
    end;
	if self.isMouseActive then
		self.mouseButton = MouseControlsVehicle.BUTTON_NONE;
	end;

end;

function Powershift:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == Input.KEY_return then
	self.off = not self.off;
    end;

    if self.gang0 then
	if isDown and sym == Input.KEY_home then
			self.isSlow = false;
			self.isFast = true;
	end;
	if isDown and sym == Input.KEY_end then
			self.isFast = false;
			self.isSlow = true;
	end;
    end;


end;

function Powershift:update(dt)

    if self.rotationPartMarchaR ~= nil then
		local x, y, z = getRotation(self.rotationPartMarchaR.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarchaR.maxRot, self.rotationPartMarchaR.minRot, 3,  self.rotationPartMarchaR.rotTime, dt, not self.rotationMaxMarchaR);
		setRotation(self.rotationPartMarchaR.node, unpack(newRot));
	end;	
	
	if self.rotationPartMarcha1 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarcha1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarcha1.maxRot, self.rotationPartMarcha1.minRot, 3, 	self.rotationPartMarcha1.rotTime, dt, not self.rotationMaxMarcha1);
		setRotation(self.rotationPartMarcha1.node, unpack(newRot));
	end;
	
	if self.rotationPartMarcha2 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarcha2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarcha2.maxRot, self.rotationPartMarcha2.minRot, 3, 	self.rotationPartMarcha2.rotTime, dt, not self.rotationMaxMarcha2);
		setRotation(self.rotationPartMarcha2.node, unpack(newRot));
	end
	
	if self.rotationPartMarcha3 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarcha3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarcha3.maxRot, self.rotationPartMarcha3.minRot, 3, self.rotationPartMarcha3.rotTime, dt, not self.rotationMaxMarcha3);
		setRotation(self.rotationPartMarcha3.node, unpack(newRot));
	end;
	
	if self.rotationPartMarcha4 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarcha4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarcha4.maxRot, self.rotationPartMarcha4.minRot, 3, self.rotationPartMarcha4.rotTime, dt, not self.rotationMaxMarcha4);
		setRotation(self.rotationPartMarcha4.node, unpack(newRot));
	end;
	if self.rotationPartMarcha5 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarcha5.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarcha5.maxRot, self.rotationPartMarcha5.minRot, 3, self.rotationPartMarcha5.rotTime, dt, not self.rotationMaxMarcha5);
		setRotation(self.rotationPartMarcha5.node, unpack(newRot));
	end;

    self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
    if InputBinding.isAxisZero(self.input) then
        self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
    end;
      if self.isAITractorActivated then
	self.motor.backwardGearRatio = self.bGearRatio/2;
	self.motor.forwardGearRatios = self.fGearRatios;
	self.motor.forwardTorqueCurve = self.forwardTorqueCurve0;
	self.motor.backwardTorqueCurve = self.backwardTorqueCurve0;
	self.motor.maxRpm[self.motor.speedLevel] = self.motormax[self.motor.speedLevel];
	self.maxAccelerationSpeed = self.motormaxi/100000;
	if self.turnStage == 3 or self.turnStage == 4 then
		if self.turnStage == 3 then
			self.motor.brakeForce = self.bForce/3;
		elseif self.turnStage == 4 and self.movingDirection < 0 then
			self.motor.brakeForce = self.bForce;
		else
			self.motor.brakeForce = 0;
		end;	
	else
		self.motor.brakeForce = 0;
	end;	
        setVisibility(self.brakeLight, false);
	self.reverse = false;
	self.gang0 = true;
	self.gang1 = false;
	self.gang2 = false;
	self.gang3 = false;
	self.gang4 = false;
	self.gang5 = false;
	if self.kardan1Node ~= nil and self.kardan2Node ~= nil then
         	rotate(self.kardan1Node, self.wheelRpm*0.1*self.movingDirection, 0, 0);
        	rotate(self.kardan2Node, self.wheelRpm*-0.1*self.movingDirection, 0, 0);
	end;
      else
	if not self.off then
	    if Input.isKeyPressed(Input.KEY_space) then
			if self.motor.speedLevel ~= 0 then
				self.level = self.motor.speedLevel;
				self.motor.speedLevel = 0;
				self.motor.brakeForce = self.bForce;
			elseif -self.input < -0.001 then
				self.motor.brakeForce = -self.input*-self.bForce;
				self.movingDirection = 0;
				self.brakeLightActive = true;
			elseif -self.input > 0.001 then
				self.movingDirection = 0;
			elseif self.level ~= 0 then
				if -self.input > 0.001 or -self.input < -0.001 then
					self.level = 0;
				end;
				self.motor.brakeForce = self.bForce;
			else
				self.brakeLightActive = false;
				self.motor.brakeForce = self.bForce/10;
			end;
			self.maxAccelerationSpeed = 0;
			self.motor.backwardGearRatio = 0;
			self.motor.forwardGearRatios = {0, 0, 0};
		self.kuplung = true;
	    else
		self.kuplung = false;
	    end;
    	    if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered  then
		if self.reverse and self.ok and not self.kuplung then
			if self.motor.speedLevel ~= 0 then
		        	self.motor.maxRpm[self.motor.speedLevel] = self.motormaxr[self.motor.speedLevel];
				self.maxAccelerationSpeed = -self.motor.maxRpm[self.motor.speedLevel]/100000;
				if self.isFast then
					self.motor.backwardGearRatio = self.bGearRatio;
				else
					self.motor.backwardGearRatio = self.bGearRatio+6;
				end;		
				self.movingDirection = 0;
			elseif -self.input < -0.001 then
				self.maxAccelerationSpeed = 0;
				self.motor.backwardGearRatio = 0;
			else
				self.maxAccelerationSpeed = -self.motormaxi/100000;
				if self.isFast then
					self.motor.backwardGearRatio = self.bGearRatio;
				else
					self.motor.backwardGearRatio = self.bGearRatio+6;
				end;
				self.movingDirection = 0;
			end;
			if self.level ~= 0 then
				self.motor.speedLevel = self.level;
				self.level = 0;
			end;
			if self.motor.speedLevel ~= 0 and self.movingDirection > 0 then
				self.motor.brakeForce = self.bForce;
				self.movingDirection = 1;	
			elseif -self.input < -0.001 then
				self.motor.brakeForce = -self.input*-self.bForce*2;
				self.movingDirection = 1;
				self.brakeLightActive = true;
			elseif -self.input > 0.001 and self.movingDirection > 0 then
				self.motor.brakeForce = -self.input*self.bForce;
				self.movingDirection = 1;
			else
				self.motor.brakeForce = self.bForce/10;
				self.brakeLightActive = false;
			end;
			self.motor.forwardGearRatios = {0, 0, 0};
		elseif self.gang0 then
			if self.motor.speedLevel ~= 0 then
				self.level = self.motor.speedLevel;
				self.motor.speedLevel = 0;
				self.motor.brakeForce = self.bForce;
			elseif -self.input < -0.001 then
				self.motor.brakeForce = -self.input*-self.bForce;
				self.movingDirection = 0;
				self.brakeLightActive = true;
			elseif -self.input > 0.001 then
				self.movingDirection = 0;
			elseif self.level ~= 0 then
				if -self.input > 0.001 or -self.input < -0.001 then
					self.level = 0;
				end;
				self.motor.brakeForce = self.bForce;
			else
				self.brakeLightActive = false;
				self.motor.brakeForce = self.bForce/10;
			end;
			self.maxAccelerationSpeed = 0;
			self.motor.backwardGearRatio = 0;
			self.motor.forwardGearRatios = {0, 0, 0};
		elseif self.gang1 and not self.kuplung then
			if self.level ~= 0 then
				self.motor.speedLevel = self.level;
				self.level = 0;
			end;
			if self.motor.speedLevel ~= 0 then
				if self.motor.speedLevel == 4 then
					self.ok = false;
				end;
		        	self.motor.maxRpm[self.motor.speedLevel] = self.motormax[self.motor.speedLevel];
				self.maxAccelerationSpeed = self.motor.maxRpm[self.motor.speedLevel]/100000;
				if self.isFast then
					self.motor.forwardGearRatios = {self.fGearRatios[1]*5, self.fGearRatios[2]*5, self.fGearRatios[3]*5};
				else
					self.motor.forwardGearRatios = {self.fGearRatios[1]*10, self.fGearRatios[2]*10, self.fGearRatios[3]*10};
				end;
			elseif -self.input < -0.001 then
				self.maxAccelerationSpeed = 0;
				self.motor.forwardGearRatios = {0, 0, 0};
			else
				self.maxAccelerationSpeed = self.motormaxi/100000;
				if self.isFast then
					self.motor.forwardGearRatios = {self.fGearRatios[1]*5, self.fGearRatios[2]*5, self.fGearRatios[3]*5};
				else
					self.motor.forwardGearRatios = {self.fGearRatios[1]*10, self.fGearRatios[2]*10, self.fGearRatios[3]*10};
				end;
			end;
				
			if self.motor.speedLevel ~= 0 and self.movingDirection < 0 then
				self.motor.brakeForce = self.bForce;
				self.movingDirection = 1;			
			elseif -self.input < -0.001 then
				self.motor.brakeForce = -self.input*-self.bForce*2;
				self.brakeLightActive = true;
				self.movingDirection = 1;
			elseif -self.input > 0.001 and self.movingDirection < 0 then
				self.motor.brakeForce = -self.input*self.bForce;
				self.movingDirection = 1;
			else
				self.motor.brakeForce = self.bForce/10;
				self.brakeLightActive = false;
			end;
			self.motor.backwardGearRatio = 0;
		elseif self.gang2 and not self.kuplung then
			if self.level ~= 0 then
				self.motor.speedLevel = self.level;
				self.level = 0;
			end;
			if self.motor.speedLevel ~= 0 then
				if self.motor.speedLevel == 4 then
					self.ok = false;
				end;
		        	self.motor.maxRpm[self.motor.speedLevel] = self.motormax[self.motor.speedLevel];
				self.maxAccelerationSpeed = self.motor.maxRpm[self.motor.speedLevel]/100000;
				if self.isFast then
					self.motor.forwardGearRatios = {self.fGearRatios[1]*4, self.fGearRatios[2]*4, self.fGearRatios[3]*4};
				else
					self.motor.forwardGearRatios = {self.fGearRatios[1]*7, self.fGearRatios[2]*7, self.fGearRatios[3]*7};
				end;
			elseif -self.input < -0.001 then
				self.maxAccelerationSpeed = 0;
				self.motor.forwardGearRatios = {0, 0, 0};
			else
				self.maxAccelerationSpeed = self.motormaxi/100000;
				if self.isFast then
					self.motor.forwardGearRatios = {self.fGearRatios[1]*4, self.fGearRatios[2]*4, self.fGearRatios[3]*4};
				else
					self.motor.forwardGearRatios = {self.fGearRatios[1]*7, self.fGearRatios[2]*7, self.fGearRatios[3]*7};
				end;
			end;
				
			if self.motor.speedLevel ~= 0 and self.movingDirection < 0 then
				self.motor.brakeForce = self.bForce;
				self.movingDirection = 1;			
			elseif -self.input < -0.001 then
				self.motor.brakeForce = -self.input*-self.bForce*2;
				self.brakeLightActive = true;
				self.movingDirection = 1;
			elseif -self.input > 0.001 and self.movingDirection < 0 then
				self.motor.brakeForce = -self.input*self.bForce;
				self.movingDirection = 1;
			else
				self.motor.brakeForce = self.bForce/10;
				self.brakeLightActive = false;
			end;
			self.motor.backwardGearRatio = 0;
		elseif self.gang3 and not self.kuplung then
			if self.level ~= 0 then
				self.motor.speedLevel = self.level;
				self.level = 0;
			end;
			if self.motor.speedLevel ~= 0 then
				if self.motor.speedLevel == 4 then
					self.ok = false;
				end;
		        	self.motor.maxRpm[self.motor.speedLevel] = self.motormax[self.motor.speedLevel];
				self.maxAccelerationSpeed = self.motor.maxRpm[self.motor.speedLevel]/100000;
				if self.isFast then
					self.motor.forwardGearRatios = {self.fGearRatios[1]*2.8, self.fGearRatios[2]*2.8, self.fGearRatios[3]*2.8};
				else
					self.motor.forwardGearRatios = {self.fGearRatios[1]*4.5, self.fGearRatios[2]*4.5, self.fGearRatios[3]*4.5};
				end;
			elseif -self.input < -0.001 then
				self.maxAccelerationSpeed = 0;
				self.motor.forwardGearRatios = {0, 0, 0};
			else
				self.maxAccelerationSpeed = self.motormaxi/100000;
				if self.isFast then
					self.motor.forwardGearRatios = {self.fGearRatios[1]*2.8, self.fGearRatios[2]*2.8, self.fGearRatios[3]*2.8};
				else
					self.motor.forwardGearRatios = {self.fGearRatios[1]*4.5, self.fGearRatios[2]*4.5, self.fGearRatios[3]*4.5};
				end;
			end;
				
			if self.motor.speedLevel ~= 0 and self.movingDirection < 0 then
				self.motor.brakeForce = self.bForce;
				self.movingDirection = 1;			
			elseif -self.input < -0.001 then
				self.motor.brakeForce = -self.input*-self.bForce*2;
				self.brakeLightActive = true;
				self.movingDirection = 1;
			elseif -self.input > 0.001 and self.movingDirection < 0 then
				self.motor.brakeForce = -self.input*self.bForce;
				self.movingDirection = 1;
			else
				self.motor.brakeForce = self.bForce/10;
				self.brakeLightActive = false;
			end;
			self.motor.backwardGearRatio = 0;
		elseif self.gang4 and not self.kuplung then
			if self.level ~= 0 then
				self.motor.speedLevel = self.level;
				self.level = 0;
			end;
			if self.motor.speedLevel ~= 0 then
				if self.motor.speedLevel == 4 then
					self.ok = false;
				end;
		        	self.motor.maxRpm[self.motor.speedLevel] = self.motormax[self.motor.speedLevel];
				self.maxAccelerationSpeed = self.motor.maxRpm[self.motor.speedLevel]/100000;
				if self.isFast then
					self.motor.forwardGearRatios = {self.fGearRatios[1]*1.5, self.fGearRatios[2]*1.5, self.fGearRatios[3]*1.5};
				else
					self.motor.forwardGearRatios = {self.fGearRatios[1]*2.5, self.fGearRatios[2]*2.5, self.fGearRatios[3]*2.5};
				end;
			elseif -self.input < -0.001 then
				self.maxAccelerationSpeed = 0;
				self.motor.forwardGearRatios = {0, 0, 0};
			else
				self.maxAccelerationSpeed = self.motormaxi/100000;
				if self.isFast then
					self.motor.forwardGearRatios = {self.fGearRatios[1]*1.5, self.fGearRatios[2]*1.5, self.fGearRatios[3]*1.5};
				else
					self.motor.forwardGearRatios = {self.fGearRatios[1]*2.5, self.fGearRatios[2]*2.5, self.fGearRatios[3]*2.5};
				end;
			end;
				
			if self.motor.speedLevel ~= 0 and self.movingDirection < 0 then
				self.motor.brakeForce = self.bForce;
				self.movingDirection = 1;			
			elseif -self.input < -0.001 then
				self.motor.brakeForce = -self.input*-self.bForce*2;
				self.brakeLightActive = true;
				self.movingDirection = 1;
			elseif -self.input > 0.001 and self.movingDirection < 0 then
				self.motor.brakeForce = -self.input*self.bForce;
				self.movingDirection = 1;
			else
				self.motor.brakeForce = self.bForce/10;
				self.brakeLightActive = false;
			end;
			self.motor.backwardGearRatio = 0;
		elseif self.gang5 and not self.kuplung then
			if self.level ~= 0 then
				self.motor.speedLevel = self.level;
				self.level = 0;
			end;
			if self.motor.speedLevel ~= 0 then
				if self.motor.speedLevel == 4 then
					self.ok = false;
				end;
		        	self.motor.maxRpm[self.motor.speedLevel] = self.motormax[self.motor.speedLevel];
				self.maxAccelerationSpeed = self.motor.maxRpm[self.motor.speedLevel]/100000;
				self.motor.forwardGearRatios = self.fGearRatios;
			elseif -self.input < -0.001 then
				self.maxAccelerationSpeed = 0;
				self.motor.forwardGearRatios = {0, 0, 0};
			else
				self.maxAccelerationSpeed = self.motormaxi/100000;
				self.motor.forwardGearRatios = self.fGearRatios;
			end;
				
			if self.motor.speedLevel ~= 0 and self.movingDirection < 0 then
				self.motor.brakeForce = self.bForce;
				self.movingDirection = 1;			
			elseif -self.input < -0.001 then
				self.motor.brakeForce = -self.input*-self.bForce*2;
				self.brakeLightActive = true;
				self.movingDirection = 1;
			elseif -self.input > 0.001 and self.movingDirection < 0 then
				self.motor.brakeForce = -self.input*self.bForce;
				self.movingDirection = 1;
			else
				self.motor.brakeForce = self.bForce/10;
				self.brakeLightActive = false;
			end;
			self.motor.backwardGearRatio = 0;
		end;
		if self.reverse then
			if self.kardan1Node ~= nil and self.kardan2Node ~= nil then
				if self.wheelRpm ~= 0 then
         				rotate(self.kardan1Node, self.wheelRpm*-0.1, 0, 0);
        				rotate(self.kardan2Node, self.wheelRpm*0.1, 0, 0);
				end;
			end;
		else
			if self.kardan1Node ~= nil and self.kardan2Node ~= nil then
         			rotate(self.kardan1Node, self.wheelRpm*0.1, 0, 0);
        			rotate(self.kardan2Node, self.wheelRpm*-0.1, 0, 0);
			end;
		end;

		if not self.ok then
			if self.movingDirection <= 0 then
				self.ok = true;
			end;
		end;
	    end;
			if InputBinding.hasEvent(InputBinding.CONTROL_SWITCH) then
				self.isMouseActive = not self.isMouseActive;
				
				if not self.isMouseActive then
					InputBinding.wrapMousePositionEnabled = true;
					self.cameras[self.camIndex].isActivated = true;
				end;
			end;
			if self.isMouseActive then
				self.cameras[self.camIndex].isActivated = false;			
				InputBinding.wrapMousePositionEnabled = false;
				self.hudGearPoxX = self.lastMouseXPos-0.1;
				self.hudGearPoxY = self.lastMouseYPos-0.1;
    				self.hudGearOverlay = Overlay:new("hudGearpanel", self.gearfile, self.hudGearPoxX, self.hudGearPoxY, self.hudGearWidth, self.hudGearHeight);
			end;
    	else
		self.motor.backwardGearRatio = self.bGearRatio;
		self.motor.forwardGearRatios = self.fGearRatios;
		self.motor.forwardTorqueCurve = self.forwardTorqueCurve0;
		self.motor.backwardTorqueCurve = self.backwardTorqueCurve2;
		self.motor.maxRpm[self.motor.speedLevel] = self.motormax[self.motor.speedLevel];
		self.maxAccelerationSpeed = self.motormaxi/100000;
		self.reverse = false;
		self.gang0 = true;
		self.gang1 = false;
		self.gang2 = false;
		self.gang3 = false;
		self.gang4 = false;
		self.gang5 = false;

		if -self.input < -0.001 and self.movingDirection > 0 then
			self.brakeLightActive = true;
			self.motor.brakeForce = -self.input*-self.bForce*2;
		elseif -self.input > 0.001 and self.movingDirection < 0 then
    			self.brakeLightActive = true;
			self.motor.brakeForce = -self.input*self.bForce;
		else
			self.brakeLightActive = false;
			self.motor.brakeForce = self.bForce/10;
		end;
		if self.motor.speedLevel ~= 0 and self.movingDirection < 0 then
			self.motor.brakeForce = self.bForce;
		end;
		if self.kardan1Node ~= nil and self.kardan2Node ~= nil then
         		rotate(self.kardan1Node, self.wheelRpm*0.1*self.movingDirection, 0, 0);
        		rotate(self.kardan2Node, self.wheelRpm*-0.1*self.movingDirection, 0, 0);
		end;
    	end;		
      end;
    if self.brakeLight ~= nil then
    	if self.brakeLightActive then
            	setVisibility(self.brakeLight, self.brakeLightActive);
	else
            	setVisibility(self.brakeLight, self.brakeLightActive);
	end;
    end;

    if Input.isKeyPressed(Input.KEY_pageup) or Input.isKeyPressed(Input.KEY_pagedown) or self.camIndex == 2 then
	self.cameras[self.camIndex].allowTranslation = false;
    else
	self.cameras[self.camIndex].allowTranslation = true;
    end;

    if self.motor.speedLevel ~= 0 or self.isAITractorActivated then
	if Input.isKeyPressed(Input.KEY_pageup) and self.motor.maxRpm[self.motor.speedLevel] < self.motormaxi then
		if self.reverse then
			self.motormaxr[self.motor.speedLevel] = self.motormaxr[self.motor.speedLevel] + 10;
		else
			self.motormax[self.motor.speedLevel] = self.motormax[self.motor.speedLevel] + 10;
		end;
	elseif Input.isKeyPressed(Input.KEY_pagedown) and self.motor.maxRpm[self.motor.speedLevel] > self.motor.minRpm then
		if self.reverse then
			self.motormaxr[self.motor.speedLevel] = self.motormaxr[self.motor.speedLevel] - 10;
		else
			self.motormax[self.motor.speedLevel] = self.motormax[self.motor.speedLevel] - 10;
		end;
	end;
			
    end;

end;



function Powershift:draw()

    if self.isMotorStarted and self.motor.speedLevel ~= 0 then	
    	g_currentMission:addExtraPrintText("RPM:PageUp/PageDown   "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
    end;
    if not self.off then
    	if not self.isAITractorActivated then
		if self.isMouseActive then
		 	g_currentMission:addExtraPrintText("Tasto DELETE : Muovi pannello");
		end;
		setTextColor(0,0,0,1);
		setTextBold(true);
		renderText(0.78, 0.22, 0.019, "ENTER: DISATIVA CAMBIO");
		if self.hudGearOverlay ~= nil then
    			self.hudGearOverlay:render();
		end;
		if self.isFast then
			setTextBold(true);
			setTextColor(1,1,1,1);
			renderText(0.85, 0.782, 0.028, "H");
		end;
		if self.isSlow then
			setTextBold(true);
			setTextColor(1,1,1,1);
			renderText(0.85, 0.656, 0.028, "L");
		end;
		if self.gang0 then
			if self.isFast then
			setTextColor(1.0,0.3,0,1);
			setTextBold(true);
			renderText(0.904, 0.78, 0.030, "N");----simples---primeiro E D segundo Altura.
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.904, 0.653, 0.030, "N");---reduzido
			else
			setTextColor(1.0,0.3,0,1);
			setTextBold(true);
			renderText(0.904, 0.653, 0.030, "N");---reduzido
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.904, 0.78, 0.030, "N");----simples
			end;
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.904, 0.78, 0.030, "N");----simples
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.904, 0.653, 0.030, "N");---reduzido
		end;
		if self.gang1 then
			if self.isFast then
			setTextColor(0,0.5,0,1);
			setTextBold(true);
			renderText(0.88, 0.819, 0.030, "1");----simples---primeiro E D segundo Altura.
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.88, 0.69, 0.030, "1");---reduzido
			else
			setTextColor(0,0.5,0,1);
			setTextBold(true);
			renderText(0.88, 0.69, 0.030, "1");---reduzido
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.88, 0.819, 0.030, "1");----simples
			end;
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.88, 0.819, 0.030, "1");----simples
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.88, 0.69, 0.030, "1");---reduzido
		end;
		if self.gang2 then
			if self.isFast then
			setTextColor(0,0.5,0,1);
			setTextBold(true);
			renderText(0.88, 0.741, 0.030, "2");----simples
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.88, 0.613, 0.030, "2");---reduzido
			else
			setTextColor(0,0.5,0,1);
			setTextBold(true);
			renderText(0.88, 0.613, 0.030, "2");---reduzido
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.88, 0.741, 0.030, "2");----simples
			end;
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.88, 0.741, 0.030, "2");----simples
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.88, 0.613, 0.030, "2");---reduzido
		end;
		if self.gang3 then
			if self.isFast then
			setTextColor(0,0.5,0,1);
			setTextBold(true);
			renderText(0.904, 0.819, 0.030, "3");----simples
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.904, 0.69, 0.030, "3");---reduzido
			else
			setTextColor(0,0.5,0,1);
			setTextBold(true);
			renderText(0.904, 0.69, 0.030, "3");---reduzido
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.904, 0.819, 0.030, "3");----simples
			end;
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.904, 0.819, 0.030, "3");----simples
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.904, 0.69, 0.030, "3");---reduzido
		end;
		if self.gang4 then
			if self.isFast then
			setTextColor(0,0.5,0,1);
			setTextBold(true);
			renderText(0.904, 0.741, 0.030, "4");----simples
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.904, 0.613, 0.030, "4");---reduzido
			else
			setTextColor(0,0.5,0,1);
			setTextBold(true);
			renderText(0.904, 0.613, 0.030, "4");---reduzido
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.904, 0.741, 0.030, "4");----simples
			end;
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.904, 0.741, 0.030, "4");----simples
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.904, 0.613, 0.030, "4");---reduzido
		end;
		if self.gang5 then
			setTextColor(0,0.5,0,1);
			setTextBold(true);
			renderText(0.933, 0.819, 0.030, "5");
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.933, 0.819, 0.028, "5");
		end;

		if self.reverse then
		    if self.isFast then
			setTextColor(0,0.5,0,1);
			setTextBold(true);
			renderText(0.934, 0.74, 0.030, "R");---simples
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.934, 0.61, 0.030, "R");---reduzido
			else
			setTextColor(0,0.5,0,1);
			setTextBold(true);
			renderText(0.934, 0.61, 0.030, "R");---reduzido
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.934, 0.74, 0.030, "R");
			end;
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.934, 0.74, 0.030, "R");
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(0.934, 0.61, 0.030, "R");---reduzido
		end;
    	end;
    else
	setTextColor(0,0,0,1);
	setTextBold(true);
	renderText(0.78, 0.22, 0.019, "ENTER: ATIVA CAMBIO");
    end;

end;

function Powershift:onLeave()

    self.brakeLightActive = false;
    if self.brakeLight ~= nil then
    	setVisibility(self.brakeLight, self.brakeLightActive);
    end;

end;

