--
-- Verbreiterung
-- Specialization for Lowloader
-- Spezialisierung fr Tieflader
-- @Anpassung  VWFahrer80
-- 
-- frei verwendbar - keine erlaubnis ntig  |  free for use - no permission needed.
-- Modifikationen erst nach Rcksprache!    |  modifications only with my permission.
vbr = {};

function vbr.prerequisitesPresent(specializations)
    print("Goldhofer Semi Lowloader is loaded");
    return true;
end;

function vbr:load(xmlFile)
	self.isActor = false;
	self.setVbr = SpecializationUtil.callSpecializationsFunction("setVbr");
	local v1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.v1#index"));
	if v1 ~= nil then
		self.v1 = {};
		self.v1.node = v1;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.v1#minRot"));
		self.v1.minRot = {};
		self.v1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.v1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.v1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.v1#maxRot"));
		self.v1.maxRot = {};
		self.v1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.v1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.v1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		self.v1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.v1#rotTime"), 1)*1000;
		self.supportTrans1 = {};
		self.supportTrans1.node = v1;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.v1#minTrans"));
		self.supportTrans1.minRot = {};
		self.supportTrans1.minRot[1] = x;
		self.supportTrans1.minRot[2] = y;
		self.supportTrans1.minRot[3] = z;
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.v1#maxTrans"));
		self.supportTrans1.maxRot = {};
		self.supportTrans1.maxRot[1] = x;
		self.supportTrans1.maxRot[2] = y;
		self.supportTrans1.maxRot[3] = z;
		self.supportTrans1.rotTime = self.v1.rotTime;
	end;
	local v2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.v2#index"));
	if v2 ~= nil then
		self.v2 = {};
		self.v2.node = v2;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.v2#minRot"));
		self.v2.minRot = {};
		self.v2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.v2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.v2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.v2#maxRot"));
		self.v2.maxRot = {};
		self.v2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.v2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.v2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		self.v2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.v2#rotTime"), 1)*1000;
		self.supportTrans2 = {};
        self.supportTrans2.node = v2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.v2#minTrans"));
        self.supportTrans2.minRot = {};
        self.supportTrans2.minRot[1] = x;
        self.supportTrans2.minRot[2] = y;
        self.supportTrans2.minRot[3] = z;
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.v2#maxTrans"));
        self.supportTrans2.maxRot = {};
        self.supportTrans2.maxRot[1] = x;
        self.supportTrans2.maxRot[2] = y;
        self.supportTrans2.maxRot[3] = z;
        self.supportTrans2.rotTime = self.v2.rotTime;


	end;	
	
	self.VbrAn = true;
end;



function vbr:keyEvent(unicode, sym, modifier, isDown)
end;

function vbr:update(dt)
		if InputBinding.hasEvent(InputBinding.vbr) and self:getIsActiveForInput() then
			self.VbrAn = not self.VbrAn;
			vbrEvent.sendEvent(self, self.VbrAn);
		end;
end;

function vbr:updateTick(dt)
	if self.VbrAn ~= nil then	
		if self.VbrAn then
			local x, y, z = getTranslation(self.supportTrans1.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.supportTrans1.maxRot, self.supportTrans1.minRot, 3, self.supportTrans1.rotTime, dt, true);
			setTranslation(self.supportTrans1.node, unpack(newTrans));
			if math.abs(self.supportTrans1.minRot[1]-newTrans[1]) < 0.001 then
				local x, y, z = getRotation(self.v1.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.v1.maxRot, self.v1.minRot, 3, self.v1.rotTime, dt, true);
				setRotation(self.v1.node, unpack(newRot));
			end;
			local x2, y2, z2 = getTranslation(self.supportTrans2.node);
			local trans2 = {x2,y2,z2};
			local newTrans2 = Utils.getMovedLimitedValues(trans2, self.supportTrans2.maxRot, self.supportTrans2.minRot, 3, self.supportTrans2.rotTime, dt, true);
			setTranslation(self.supportTrans2.node, unpack(newTrans2));
			
			if math.abs(self.supportTrans2.minRot[1]-newTrans2[1]) < 0.001 then
				local x2, y2, z2 = getRotation(self.v2.node);
				local rot2 = {x2,y2,z2};
				local newRot2 = Utils.getMovedLimitedValues(rot2, self.v2.maxRot, self.v2.minRot, 3, self.v2.rotTime, dt, true);
				setRotation(self.v2.node, unpack(newRot2));
			end;
		else
			local x, y, z = getRotation(self.v1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.v1.maxRot, self.v1.minRot, 3, self.v1.rotTime, dt, false);
			setRotation(self.v1.node, unpack(newRot));
			if math.abs(self.v1.maxRot[1]-newRot[1]) < 0.001 then
				local x, y, z = getTranslation(self.supportTrans1.node);
				local trans = {x,y,z};
				local newTrans = Utils.getMovedLimitedValues(trans, self.supportTrans1.maxRot, self.supportTrans1.minRot, 3, self.supportTrans1.rotTime, dt, false);
				setTranslation(self.supportTrans1.node, unpack(newTrans));
			end;
			
			local x2, y2, z2 = getRotation(self.v2.node);
		local rot2 = {x2,y2,z2};
			local newRot2 = Utils.getMovedLimitedValues(rot2, self.v2.maxRot, self.v2.minRot, 3, self.v2.rotTime, dt, false);
			setRotation(self.v2.node, unpack(newRot2));
			if math.abs(self.v2.maxRot[1]-newRot2[1]) < 0.001 then
				local x2, y2, z2 = getTranslation(self.supportTrans2.node);
				local trans2 = {x2,y2,z2};
				local newTrans2 = Utils.getMovedLimitedValues(trans2, self.supportTrans2.maxRot, self.supportTrans2.minRot, 3, self.supportTrans2.rotTime, dt, false);
				setTranslation(self.supportTrans2.node, unpack(newTrans2));
			end;
				
		end;
		for i, jointDesc in pairs(self.componentJoints) do
			setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
	end;
end;

function vbr:draw()
	if self.VbrAn then
		g_currentMission:addExtraPrintText(string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.vbr))..":                      " .." VB Einklappen");
	else
		g_currentMission:addExtraPrintText(string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.vbr))..":                      " .." VB Ausklappen");
	end;
end;
function vbr:readStream(streamId, connection)
	self.VbrAn = streamReadBool(streamId);
end;

function vbr:writeStream(streamId, connection)
	streamWriteBool(streamId, self.VbrAn);
end;
function vbr:mouseEvent(posX, posY, isDown, isUp, button)
end;

function vbr:delete()
end;

function vbr:onDetach()
	if not self.VbrAn then
		self.VbrAn = not self.VbrAn;
		vbrEvent.sendEvent(self, self.vbrAn);
	end;
end;