SetLockEvent = {};
SetLockEvent_mt = Class(SetLockEvent, Event);

InitEventClass(SetLockEvent, "SetLockEvent");

function SetLockEvent:emptyNew()
    local self = Event:new(SetLockEvent_mt);
    self.className="SetLockEvent";
    return self;
end;

function SetLockEvent:new(vehicle, isLockState)
    local self = SetLockEvent:emptyNew()
    self.vehicle = vehicle;
	self.isLockState = isLockState;
    return self;
end;

function SetLockEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLockState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLockEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLockState);
end;

function SetLockEvent:run(connection)   
	self.vehicle:setLockLowboy(self.isLockState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLockEvent:new(self.vehicle, self.isLockState), nil, connection, self.vehicle);
    end;
end;

function SetLockEvent.sendEvent(vehicle, isLockState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLockEvent:new(vehicle, isLockState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLockEvent:new(vehicle, isLockState));
		end;
	end;
end;

SetLiftEvent = {};
SetLiftEvent_mt = Class(SetLiftEvent, Event);

InitEventClass(SetLiftEvent, "SetLiftEvent");

function SetLiftEvent:emptyNew()
    local self = Event:new(SetLiftEvent_mt);
    self.className="SetLiftEvent";
    return self;
end;

function SetLiftEvent:new(vehicle, isLiftState)
    local self = SetLiftEvent:emptyNew()
    self.vehicle = vehicle;
	self.isLiftState = isLiftState;
    return self;
end;

function SetLiftEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLiftState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLiftEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLiftState);
end;

function SetLiftEvent:run(connection)   
	self.vehicle:setAxlelift(self.isLiftState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLiftEvent:new(self.vehicle, self.isLiftState), nil, connection, self.vehicle);
    end;
end;

function SetLiftEvent.sendEvent(vehicle, isLiftState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLiftEvent:new(vehicle, isLiftState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLiftEvent:new(vehicle, isLiftState));
		end;
	end;
end;