--
-- baleAttacherfleming
-- Class Balle-AttachAble Tippers
--
-- @author  Geri-G
-- @date  13/07/10
--
-- Copyright (C) Geri-G
--
-- Fleming_BaleLifter by LS-UK Mod Team
-- 11/06/2011
--

baleAttacherfleming = {};

function baleAttacherfleming.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function baleAttacherfleming:load(xmlFile)

	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
	self.searchBales = baleAttacherfleming.searchBales;
	self.attachobjects = baleAttacherfleming.attachobjects;
	self.detachobjects = baleAttacherfleming.detachobjects;
	self.OrientJoint = baleAttacherfleming.OrientJoint;
	self.setWorkState = baleAttacherfleming.setWorkState;
	self.isBaleInRange = baleAttacherfleming.isBaleInRange;
	self.place = {};
	self.place.node1 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Bale#castPoint1"));		
	self.place.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Bale#castPoint2"));
	self.place.attacherNode = Utils.indexToObject(self.components, Utils.getNoNil(getXMLString(xmlFile,"vehicle.Bale#attacherNode"),"0>"));
	self.place.highOffset = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.Bale#highOffset"),4);	
	self.Attachedobjects = {};
	self.attacherMod = 0;
	self.attacherModOld = 0;
	self.allowAttachment = true;
	self.balesAttached = false;

	self.setArmOne = SpecializationUtil.callSpecializationsFunction("setArmOne");
	self.ArmOneAnimation = getXMLString(xmlFile, "vehicle.armOne#animationName");
	self.ArmOne = false;

	self.setArmTwo = SpecializationUtil.callSpecializationsFunction("setArmTwo");
	self.ArmTwoAnimation = getXMLString(xmlFile, "vehicle.armTwo#animationName");
	self.ArmTwo = false;

end;
function baleAttacherfleming:readStream(streamId, connection)
	local turnedOn = streamReadBool(streamId);
	self:setIsTurnedOn(turnedOn, true);
	self:setArmOne(streamReadBool(streamId), true);
	self:setArmTwo(streamReadBool(streamId), true);		
end;

function baleAttacherfleming:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isTurnedOn);
	streamWriteBool(streamId, self.ArmOne);
	streamWriteBool(streamId, self.ArmTwo);
end;

function baleAttacherfleming:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self:setIsTurnedOn(not self.isTurnedOn);
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:setArmOne(not self.isArmOneOn);
				self:setArmTwo(not self.isArmTwoOn);
		end;
	end;
end;

function baleAttacherfleming:updateTick(dt)
	if self:getIsActive() and self.isServer then
		if self.isTurnedOn then
			if self.balesAttached == false then
				self:setWorkState(false);
			end;
		else
			if self.balesAttached == true then
				self:setWorkState(true);
			end;
		end;
		if self.ArmOne == true then
			self:setIsTurnedOn(false,true)
		end;
	end;
end;
function baleAttacherfleming:draw()

	if self:getIsActive() then
		if self.isTurnedOn then
			g_currentMission:addHelpButtonText(g_i18n:getText("Unlock"), InputBinding.IMPLEMENT_EXTRA3);	
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Lock"), InputBinding.IMPLEMENT_EXTRA3);
		end;
		if self.ArmOne == false then
			g_currentMission:addHelpButtonText(g_i18n:getText("Open"), InputBinding.IMPLEMENT_EXTRA2);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Close"), InputBinding.IMPLEMENT_EXTRA2);
		end;
	end;

end;

function baleAttacherfleming:isBaleInRange(node1,node2,Yoffset,Bale)
	local Xmax, Ymax, Zmax = getWorldTranslation(node1);
		  Xmax, Ymax, Zmax = worldToLocal(self.place.attacherNode,Xmax, Ymax, Zmax);
		  
	local Xmin, Ymin, Zmin = getWorldTranslation(node2);	
		  Xmin, Ymin, Zmin = worldToLocal(self.place.attacherNode,Xmin, Ymin, Zmin);
	
	local Xt, Yt, Zt = getWorldTranslation(Bale);
		  Xt, Yt, Zt = worldToLocal(self.place.attacherNode,Xt, Yt, Zt);
		
	if (Xt < math.max(Xmax,Xmin) and Xt > math.min(Xmax,Xmin)) and (Zt < math.max(Zmax,Zmin) and Zt > math.min(Zmax,Zmin)) and (Yt<= ((Ymax+Ymin)/2)+Yoffset and Yt>= (Ymax+Ymin)/2) then
		return true;
	else
		return false;
	end;
end;
function baleAttacherfleming:searchBales()
	for index,item in pairs(g_currentMission.itemsToSave) do
		if item.item:isa(Bale) then 

			if item.item.isAttached == nil and getUserAttribute(item.item.nodeId, "isRoundbale") == true then

				local isInRange = self:isBaleInRange(self.place.node1,self.place.node2,self.place.highOffset,item.item.nodeId);			

				local is1stAttached = false;
				if isInRange then
					is1stAttached = self:attachobjects(item.item.nodeId,item.item);
				end;
				if is1stAttached then
					self.balesAttached = true;
				end;
			end;
		end;
	end;
	for k,v in pairs(g_currentMission.vehicles) do
		if v ~= self and v ~= self.attacherVehicle then
			local is1stAttached = false;
			for index,components in pairs(v.components) do		
				local isInRange = self:isBaleInRange(self.place.node1,self.place.node2,self.place.highOffset,components.node);	
				if isInRange then	
					is1stAttached = self:attachobjects(components.node);
				end;
			end;
			if is1stAttached then
				self.balesAttached = true;
			end;
		end;
	end;
end;

function baleAttacherfleming:setIsTurnedOn(turnedOn, noEventSend)
      SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
      self.isTurnedOn = turnedOn;
end;

function baleAttacherfleming:setWorkState(turnedOn,noEventSend)
	--setWorkState.sendEvent(self, turnedOn, noEventSend);
	if turnedOn then
		self:detachobjects();	
	else
		self:searchBales();
	end;
end;
function baleAttacherfleming:OrientJoint(Source, Target)	
	local xw, yw, zw = getWorldTranslation(Source);		
	local x,y,z = worldToLocal(getParent(Target), xw, yw, zw);	
	setTranslation(Target, x,y,z);			
	--JointRotation Anpassung an das Objekt
	local zX, zY, zZ = localDirectionToWorld(Source, 0,0,1);
	local zX, zY, zZ = worldDirectionToLocal(getParent(Target), zX, zY, zZ);
	local yX, yY, yZ = localDirectionToWorld(Source, 0,1,0);
	local yX, yY, yZ = worldDirectionToLocal(getParent(Target), yX, yY, yZ);
	setDirection(Target, zX, zY, zZ, yX, yY, yZ);
	return false;
end;

function baleAttacherfleming:attachobjects(object,baleT)
	local attachedobject = {};
	attachedobject.object = object;
	if self.isServer then
		attachedobject.AT = createTransformGroup("AT");
		link(self.place.attacherNode,attachedobject.AT);
		
		attachedobject.objectMass = getMass(object);
		setMass(object,attachedobject.objectMass*0.01);
		
		self:OrientJoint(object,attachedobject.AT);

		local constr = JointConstructor:new();					
		constr:setActors(self.place.attacherNode, object);
		constr:setJointTransforms(attachedobject.AT,  object);
		for i=1, 3 do
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1,0,0);
		end;
		attachedobject.JointIndex = constr:finalize();
		
		if baleT ~= nil then
			attachedobject.baleT = baleT;
			baleT.isAttached = true;
		end;
	end;

	table.insert(self.Attachedobjects, attachedobject);
	return true;
end;

function baleAttacherfleming:detachobjects()
	if self.isServer then
		for k,v in pairs(self.Attachedobjects) do
			removeJoint(v.JointIndex);
			delete(v.AT);
			v.JointIndex = nil;
			setMass(v.object,v.objectMass);
			if v.baleT ~= nil then
				v.baleT.isAttached = nil;
			end;
		end;
	end;
	
	self.Attachedobjects = nil;
	self.Attachedobjects = {};
	self.balesAttached = false;
end;



function baleAttacherfleming:onAttach(attacherVehicle)
	if self.isServer then
		self:setWorkState(false);
	end;
end;
function baleAttacherfleming:onDetach()

	if self.isServer then
		self:setWorkState(true);
		self:setArmOne(false);
		self:setArmTwo(false);
	end;
end;
function baleAttacherfleming:onActivate()
	if self.isServer then
		self:setWorkState(false);
	end;
end;
function baleAttacherfleming:onDeactivate()
	if self.isServer then
		self:setWorkState(true);
	end;
end;
function baleAttacherfleming:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then

	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function baleAttacherfleming:getSaveAttributesAndNodes(nodeIdent)
   -- local attributes = ' side="'..tostring(self.currentSide)..'"';
    local attributes = nil;
    local node = nil;
    return attributes, node;
end;
function baleAttacherfleming:delete()

end;

function baleAttacherfleming:mouseEvent(posX, posY, isDown, isUp, button)
end;

function baleAttacherfleming:keyEvent(unicode, sym, modifier, isDown)
end;


function baleAttacherfleming:setArmOne(isArmOne,noEventSend)
	SetArmOneEvent.sendEvent(self, isArmOne, noEventSend);
	-- Play ArmOne animation --
	self.isArmOneOn = isArmOne;
	if self.isArmOneOn then
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, -1, nil, true);
			self.ArmOne = true;
		end;
	else
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, 1, nil, true);
			self.ArmOne = false;
		end;
	end;	
end;

function baleAttacherfleming:setArmTwo(isArmTwo,noEventSend)
	SetArmTwoEvent.sendEvent(self, isArmTwo, noEventSend);
	-- Play ArmTwo animation --
	self.isArmTwoOn = isArmTwo;
	if self.isArmTwoOn then
		if self.ArmTwoAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmTwoAnimation, -1, nil, true);
			self.ArmTwo = true;
		end;
	else
		if self.ArmTwoAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmTwoAnimation, 1, nil, true);
			self.ArmTwo = false;
		end;
	end;	
end;


SetArmOneEvent = {};
SetArmOneEvent_mt = Class(SetArmOneEvent, Event);

InitEventClass(SetArmOneEvent, "SetArmOneEvent");

function SetArmOneEvent:emptyNew()
    local self = Event:new(SetArmOneEvent_mt);
    self.className="SetArmOneEvent";
    return self;
end;

function SetArmOneEvent:new(vehicle, isArmOne)
    local self = SetArmOneEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmOne = isArmOne;
    return self;
end;

function SetArmOneEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmOne = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmOneEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmOne);
end;

function SetArmOneEvent:run(connection)   
	self.vehicle:setArmOne(self.isArmOne, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmOneEvent:new(self.vehicle, self.isArmOne), nil, connection, self.vehicle);
    end;
end;

function SetArmOneEvent.sendEvent(vehicle, isArmOne, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmOneEvent:new(vehicle, isArmOne), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmOneEvent:new(vehicle, isArmOne));
		end;
	end;
end;

SetArmTwoEvent = {};
SetArmTwoEvent_mt = Class(SetArmTwoEvent, Event);

InitEventClass(SetArmTwoEvent, "SetArmTwoEvent");

function SetArmTwoEvent:emptyNew()
    local self = Event:new(SetArmTwoEvent_mt);
    self.className="SetArmTwoEvent";
    return self;
end;

function SetArmTwoEvent:new(vehicle, isArmTwo)
    local self = SetArmTwoEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmTwo = isArmTwo;
    return self;
end;

function SetArmTwoEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmTwo = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmTwoEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmTwo);
end;

function SetArmTwoEvent:run(connection)   
	self.vehicle:setArmTwo(self.isArmTwo, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmTwoEvent:new(self.vehicle, self.isArmTwo), nil, connection, self.vehicle);
    end;
end;

function SetArmTwoEvent.sendEvent(vehicle, isArmTwo, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmTwoEvent:new(vehicle, isArmTwo), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmTwoEvent:new(vehicle, isArmTwo));
		end;
	end;
end;
