-- By PeterJ (30-11-2010)



painelinfo = {};

function painelinfo.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function painelinfo:load(xmlFile)
	self.kinkJoint = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.kinkSteering#kinkJoint"), 0);
	self.kinkOrientation = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kinkSteering#wheelOrientation"));

	self.controlpath = Utils.getFilename("info.png", self.baseDirectory);
    self.helpPoxX = 0.87;
    self.helpPoxY = 0.41;
    self.helpWidth = 0.12;
    self.helpHeight = 0.46;
    self.helpOverlay = Overlay:new("info", self.controlpath, self.helpPoxX, self.helpPoxY, self.helpWidth, self.helpHeight);
    self.bcActive = true;

	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	
	self.setHydraulicTime = 30;

end;

function painelinfo:keyEvent(unicode, sym, modifier, isDown)

		if isDown and sym == 48 then -- Key: 0
			self.bcActive = not self.bcActive;
		end;

end;

function painelinfo:update(dt)
	if self.isMotorStarted then
		if self.kinkJoint ~= 0 then
			setJointFrame(self.componentJoints[self.kinkJoint].jointIndex , 0, self.componentJoints[self.kinkJoint].jointNode);   
			local x, y, z = getRotation(self.kinkOrientation);	    
			setRotation(self.kinkOrientation, 0,y,0);
		end;
	end;

		if self:getIsActive() then			
		self.setHydraulicTime = 30;	
	end;

	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;	
	
end;

function painelinfo:draw()

	 if self.helpOverlay ~= nil then
		if self.bcActive then
		self.helpOverlay:render();
		end;
	end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("Key 0: Info Off");
		else
			g_currentMission:addExtraPrintText("Key 0: Info On");
		end;

end;

function painelinfo:setHydraulicDirection(index)

	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;

function painelinfo:onEnter()
end;

function painelinfo:onLeave()
end;

function painelinfo:delete()
end;

function painelinfo:mouseEvent(posX, posY, isDown, isUp, button)
end;

function painelinfo:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;





