--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.8, 0.22, 0.02, "Press Numpad 0: Info");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.8, 0.22, 0.02, "Press Numpad 0: Info");
		renderText(0.72, 0.86, 0.025, "- Valtra Valmet 8550 Hitech -");			
		renderText(0.72, 0.83, 0.02, "Press 5 : Start");
		renderText(0.72, 0.81, 0.02, "Press 6 : Worklights");
		renderText(0.72, 0.79, 0.02, "Press 7 : FL attacher");			
		renderText(0.72, 0.77, 0.02, "Press 8 : Front duals");
		renderText(0.72, 0.75, 0.02, "Press 9 : Rear duals");
		renderText(0.72, 0.73, 0.02, "Press Home : Beacon");
		renderText(0.72, 0.71, 0.02, "Press Numpad 1 : Blinker left");
		renderText(0.72, 0.69, 0.02, "Press Numpad 2 : Warning blinker");
		renderText(0.72, 0.67, 0.02, "Press Numpad 3 : Blinker right");
		renderText(0.72, 0.65, 0.02, "Press Numpad 4 : Left door");
		renderText(0.72, 0.63, 0.02, "Press Numpad 5 : Rear window");
		renderText(0.72, 0.61, 0.02, "Press Numpad 6 : Right door");
        renderText(0.72, 0.56, 0.02, "         - by EP-Modding -");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




