--
-- Etuakselijousitus
-- 
--
-- author  	tvaltra
--
-- 
--
Jousitus = {};

function Jousitus.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Jousitus:load(xmlFile)
	
	self.Jousitus = {};
	self.Jousitus.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Jousitus#node"));
	self.Jousitus.etup = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Jousitus#etup"));
	self.Jousitus.takap = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Jousitus#takap"));
	self.Jousitus.suspTravel = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Jousitus#suspTravel"), 0.3);
	self.Jousitus.liike = {getTranslation(self.Jousitus.node)};
	self.Jousitus.damper = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Jousitus#damper"), 0.4) * 0.01;
	
	self.Jousitus.firstRun = true;
	local x1,y1,z1 = getWorldTranslation(self.Jousitus.etup);
	local y3 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x1, 0, z1);
	self.Jousitus.wheel1Y = y1-y3;	
	local x2,y2,z2 = getWorldTranslation(self.Jousitus.takap);
	local y4 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x2, 0, z2);
	self.Jousitus.wheel2Y = y2-y4;
	self.Jousitus.korkeus = ((y1-y3) + (y2-y4)) / 2;
	self.Jousitus.edelkorkeus = self.Jousitus.korkeus;
	self.Jousitus.edelnopeus = 0;
	self.Jousitus.liikenopeus = 0;
	
	
	
	self.Jousitus.akselinliike = 0;
	
end;

function Jousitus:delete()
	
end;

function Jousitus:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Jousitus:keyEvent(unicode, sym, modifier, isDown)
end;

function Jousitus:update(dt)
end;

function Jousitus:updateTick(dt)
	setJointFrame(self.componentJoints[1].jointIndex, 0, self.componentJoints[1].jointNode);
	if self.isClient then
        if self:getIsActive() then
			
				local jousi = self.Jousitus;
				local x1,y1,z1 = getWorldTranslation(jousi.etup);
				local y3 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x1, 0, z1);
				local x2,y2,z2 = getWorldTranslation(jousi.takap);	
				local y4 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x2, 0, z2);
				
				local deltaY1 = self.Jousitus.wheel1Y - (y1-y3);
				local deltaY2 = self.Jousitus.wheel2Y - (y2-y4);
				local korkeus = (deltaY1 + deltaY2) / 2;
				
				
				
				if jousi.firstRun then
					jousi.edelkorkeus = korkeus;
					jousi.firstRun = false;
				end;
				local nopeus =  math.min(math.max((korkeus - jousi.edelkorkeus) / 0.05, -1), 1);			

				local kiihtyvyys = (nopeus - jousi.edelnopeus) / dt;
				jousi.edelnopeus = nopeus;
				jousi.edelkorkeus = korkeus;
				
				local voima = math.cos(jousi.akselinliike) * kiihtyvyys * 0.0007;
				local hidastus = -math.sin(jousi.akselinliike) * 0.000002;
				local vaimennus = jousi.damper * jousi.liikenopeus;
				
				jousi.liikenopeus = jousi.liikenopeus + (voima + hidastus - vaimennus) * dt;
				jousi.akselinliike = jousi.akselinliike + jousi.liikenopeus * dt;
				jousi.akselinliike = math.min(math.max(jousi.akselinliike, -jousi.suspTravel), jousi.suspTravel);	
				
				setTranslation(jousi.node, jousi.liike[1], jousi.liike[2] + jousi.akselinliike, jousi.liike[3]);
				
			
				
				
				
			
			end;
		end;
	
end;

function Jousitus:draw()
end;

function Jousitus:onLeave()
	setTranslation(self.Jousitus.node, unpack(self.Jousitus.liike));
end;