--
-- Duels
-- LS UK Modteam
--
-- author Henly20
-- date  20/11/2010
--

Duels = {};

function Duels.prerequisitesPresent(specializations)
    return true;
end;

function Duels:load(xmlFile)

	self.setDuelWheelsVisibility = SpecializationUtil.callSpecializationsFunction("setDuelWheelsVisibility");
	self.setDuelFWheelsVisibility = SpecializationUtil.callSpecializationsFunction("setDuelFWheelsVisibility");
	
      self.duelWheels = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.duelWheels.duelWheel(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, true);
              table.insert(self.duelWheels, {node=node});
          end;
          i = i + 1;
      end;


end;

function Duels:delete()

end;

function Duels:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setDuelWheelsVisibility(visibility, true);

	
end;

function Duels:writeStream(streamId, connection)
	streamWriteBool(streamId, self.duelWheelsActive);

	
end;

function Duels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Duels:keyEvent(unicode, sym, modifier, isDown)
end;

function Duels:update(dt)

      if self:getIsActiveForInput() and self.isClient then
          if InputBinding.hasEvent(InputBinding.EXTRAWHEEL) then
              self:setDuelWheelsVisibility(not self.duelWheelsActive);
          end;
	  end;
end;

function Duels:updateTick(dt)



end;

function Duels:onLeave()

end;

function Duels:draw()

end;

function Duels:setDuelWheelsVisibility(visibility, noEventSend)
      if visibility ~= self.duelWheelsActive then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetDuelWheelsEvent:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(SetDuelWheelsEvent:new(self, visibility));
              end;
          end;
  
          self.duelWheelsActive = visibility;
  
          for _, duelWheel in pairs(self.duelWheels) do
             setVisibility(duelWheel.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setDuelWheelsVisibility ~= nil then
                 v.setDuelWheelsVisibility(self, visibility);
              end;
          end;
      end;
end;