SetDoorRightRotationEvent = {};
SetDoorRightRotationEvent_mt = Class(SetDoorRightRotationEvent, Event);
  
InitEventClass(SetDoorRightRotationEvent, "SetDoorRightRotationEvent");
  
function SetDoorRightRotationEvent:emptyNew()
      local self = Event:new(SetDoorRightRotationEvent_mt);
      self.className="SetDoorRightRotationEvent";
      return self;
 end;

function SetDoorRightRotationEvent:new(object, rotationMax13)
      local self = SetDoorRightRotationEvent:emptyNew()
      self.object = object;
      self.rotationMax13 = rotationMax13;
      return self;
end;
 
function SetDoorRightRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationMax13 = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetDoorRightRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMax13);
end;
 
function SetDoorRightRotationEvent:run(connection)
      self.object:setRotationMax13(self.rotationMax13, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetDoorRightRotationEvent:new(self.object, self.rotationMax13), nil, connection, self.object);
      end;
end;