--
-- Scania
-- Specialization for scania mod
--
-- @author  Sebastian B. (Blancker, www.landwirtschaftssimulator-2009.de)
-- @date  10/01/09
--
-- Copyright (C) Der Treffpunkt

Scania = {};

function Scania.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Scania:load(xmlFile)

	local translationPartNodeLinks = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartLinks#index"));
    if translationPartNodeLinks ~= nil then
        self.translationPartLinks = {};
        self.translationPartLinks.node = translationPartNodeLinks;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartLinks#minTrans"));
        self.translationPartLinks.minTrans = {};
        self.translationPartLinks.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartLinks.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartLinks.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartLinks#maxTrans"));
        self.translationPartLinks.maxTrans = {};
        self.translationPartLinks.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartLinks.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartLinks.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartLinks.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartLinks#transTime"), 2)*1000;
        self.translationPartLinks.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartLinks#touchTransLimit"), 10);
    end;

	local translationPartNodeRechts = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartRechts#index"));
    if translationPartNodeRechts ~= nil then
        self.translationPartRechts = {};
        self.translationPartRechts.node = translationPartNodeRechts;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRechts#minTrans"));
        self.translationPartRechts.minTrans = {};
        self.translationPartRechts.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRechts.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRechts.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRechts#maxTrans"));
        self.translationPartRechts.maxTrans = {};
        self.translationPartRechts.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRechts.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRechts.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartRechts.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRechts#transTime"), 2)*1000;
        self.translationPartRechts.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRechts#touchTransLimit"), 10);
    end;

	local rotationPartNodeleftDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor#index"));
    if rotationPartNodeleftDoor ~= nil then
        self.rotationPartleftDoor = {};
        self.rotationPartleftDoor.node = rotationPartNodeleftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleftDoor#minRot"));
        self.rotationPartleftDoor.minRot = {};
        self.rotationPartleftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#maxRot"));
        self.rotationPartleftDoor.maxRot = {};
        self.rotationPartleftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#rotTime"), 2)*1000;
        self.rotationPartleftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#touchRotLimit"), 10));
    end;

	local rotationPartNoderightDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rightDoor#index"));
    if rotationPartNoderightDoor ~= nil then
        self.rotationPartrightDoor = {};
        self.rotationPartrightDoor.node = rotationPartNoderightDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartporteg#minRot"));
        self.rotationPartrightDoor.minRot = {};
        self.rotationPartrightDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightDoor#maxRot"));
        self.rotationPartrightDoor.maxRot = {};
        self.rotationPartrightDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightDoor#rotTime"), 2)*1000;
        self.rotationPartrightDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightDoor#touchRotLimit"), 10));
    end;

	local translationPartNodeleftWindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartleftWindow#index"));
    if translationPartNodeleftWindow ~= nil then
        self.translationPartleftWindow = {};
        self.translationPartleftWindow.node = translationPartNodeleftWindow;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartleftWindow#minTrans"));
        self.translationPartleftWindow.minTrans = {};
        self.translationPartleftWindow.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartleftWindow.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartleftWindow.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartleftWindow#maxTrans"));
        self.translationPartleftWindow.maxTrans = {};
        self.translationPartleftWindow.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartleftWindow.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartleftWindow.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartleftWindow.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartleftWindow#transTime"), 2)*1000;
        self.translationPartleftWindow.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartleftWindow#touchTransLimit"), 10);
    end;

	local translationPartNoderightWindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartrightWindow#index"));
    if translationPartNoderightWindow ~= nil then
        self.translationPartrightWindow = {};
        self.translationPartrightWindow.node = translationPartNoderightWindow;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartrightWindow#minTrans"));
        self.translationPartrightWindow.minTrans = {};
        self.translationPartrightWindow.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartrightWindow.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartrightWindow.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartrightWindow#maxTrans"));
        self.translationPartrightWindow.maxTrans = {};
        self.translationPartrightWindow.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartrightWindow.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartrightWindow.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartrightWindow.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartrightWindow#transTime"), 2)*1000;
        self.translationPartrightWindow.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartrightWindow#touchTransLimit"), 10);
    end;

	local rotationPartNodeSchild = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Schild#index"));
    if rotationPartNodeSchild ~= nil then
        self.rotationPartSchild = {};
        self.rotationPartSchild.node = rotationPartNodeSchild;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSchild#minRot"));
        self.rotationPartSchild.minRot = {};
        self.rotationPartSchild.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSchild.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSchild.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Schild#maxRot"));
        self.rotationPartSchild.maxRot = {};
        self.rotationPartSchild.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSchild.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSchild.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSchild.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Schild#rotTime"), 2)*1000;
        self.rotationPartSchild.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Schild#touchRotLimit"), 10));
    end;

	turn1SoundFile = Utils.getFilename("", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;	

	self.extra_lights = {};
    self.extra_lights.far = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.extra_lights.far#index"));
    self.farlightActive = false;

	self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;

	hornSoundFile = Utils.getFilename("", self.baseDirectory);
    self.hornSoundId = createSample("famerCarSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;

end;

function Scania:delete()
	delete(self.hornSoundId);
end;

function Scania:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Scania:keyEvent(unicode, sym, modifier, isDown)
	
	if isDown and sym == Input.KEY_x then
		self.translationMaxLinks = true;
		self.translationMaxRechts = true;			
	end;
	
	if isDown and sym == Input.KEY_z then
		self.translationMaxLinks = false;
		self.translationMaxRechts = false;			
	end;

	if isDown and sym == Input.KEY_KP_7 then 
		self.rotationMaxleftDoor = not self.rotationMaxleftDoor;
	end;

	if isDown and sym == Input.KEY_KP_9 then 
		self.rotationMaxrightDoor = not self.rotationMaxrightDoor;
	end;

	if isDown and sym == Input.KEY_KP_8 then
		self.translationMaxleftWindow = not self.translationMaxleftWindow;	
	end;

	if isDown and sym == Input.KEY_KP_5 then
		self.translationMaxrightWindow = not self.translationMaxrightWindow;	
	end;

	if isDown and sym == Input.KEY_4 then 
		self.rotationMaxSchild = not self.rotationMaxSchild;
	end;

	if isDown and sym == Input.KEY_n then
		self.rotationMaxleftDoor = false;
		self.rotationMaxrightDoor = false;			
		self.translationMaxleftWindow = false;
		self.translationMaxrightWindow = false;
	end;

	if self.isMotorStarted then
		if isDown and sym == Input.KEY_KP_3 then 
			self.flashLeft = not self.flashLeft;
			self.delayOnLeft = 10;
			self.flashRight = false;
			self.flash = false;
			self.flashlightsRightActive = false;
			self.flashlightsWarnerActive = false;
			self.flashlightsRight2Active = false;
			self.turnlightsActive2 = false;
			self.flashWarner = false;
		end;
	end;

	if isDown and sym == Input.KEY_KP_2 then 
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;

	if self.isMotorStarted then
		if isDown and sym == Input.KEY_KP_1 then 
			self.flashRight = not self.flashRight;
			self.delayOnRight = 10;
			self.flashLeft = false;
			self.flash = false;
			self.flashlightsLeftActive = false;
			self.flashlightsWarnerActive = false;
			self.flashlightsLeft2Active = false;
			self.turnlightsActive = false;
			self.flashWarner = false;
		end;
	end;

	if isDown and sym == Input.KEY_KP_4 then 
		self.farlightActive = not self.farlightActive;
		setVisibility(self.extra_lights.far, self.farlightActive);
	end;

	if self.isEntered then
      if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input[self.rundumleuchtenKey] then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;
    end;

	if isDown and sym == Input.KEY_0 then
        self.helpPanel = not self.helpPanel;
    end;
end;

function Scania:update(dt)

	if self.translationPartLinks ~= nil then
		local x, y, z = getTranslation(self.translationPartLinks.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartLinks.maxTrans, self.translationPartLinks.minTrans, 3, self.translationPartLinks.transTime, dt, not self.translationMaxLinks);
		setTranslation(self.translationPartLinks.node, unpack(newTrans));
	end;

	if self.translationPartRechts ~= nil then
		local x, y, z = getTranslation(self.translationPartRechts.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartRechts.maxTrans, self.translationPartRechts.minTrans, 3, self.translationPartRechts.transTime, dt, not self.translationMaxRechts);
		setTranslation(self.translationPartRechts.node, unpack(newTrans));
	end;

	if self.rotationPartleftDoor ~= nil then
		local x, y, z = getRotation(self.rotationPartleftDoor.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor.maxRot, self.rotationPartleftDoor.minRot, 3, self.rotationPartleftDoor.rotTime, dt, not self.rotationMaxleftDoor);
		setRotation(self.rotationPartleftDoor.node, unpack(newRot));
   end;

	if self.rotationPartrightDoor ~= nil then
		local x, y, z = getRotation(self.rotationPartrightDoor.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightDoor.maxRot, self.rotationPartrightDoor.minRot, 3, self.rotationPartrightDoor.rotTime, dt, not self.rotationMaxrightDoor);
		setRotation(self.rotationPartrightDoor.node, unpack(newRot));
	end;

	if self.translationPartleftWindow ~= nil then
		local x, y, z = getTranslation(self.translationPartleftWindow.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartleftWindow.maxTrans, self.translationPartleftWindow.minTrans, 3, self.translationPartleftWindow.transTime, dt, not self.translationMaxleftWindow);
		setTranslation(self.translationPartleftWindow.node, unpack(newTrans));
	end;

	if self.translationPartrightWindow ~= nil then
		local x, y, z = getTranslation(self.translationPartrightWindow.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartrightWindow.maxTrans, self.translationPartrightWindow.minTrans, 3, self.translationPartrightWindow.transTime, dt, not self.translationMaxrightWindow);
		setTranslation(self.translationPartrightWindow.node, unpack(newTrans));
	end;

	if self.rotationPartSchild ~= nil then
		local x, y, z = getRotation(self.rotationPartSchild.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSchild.maxRot, self.rotationPartSchild.minRot, 3, self.rotationPartSchild.rotTime, dt, not self.rotationMaxSchild);
		setRotation(self.rotationPartSchild.node, unpack(newRot));
	end;

	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.turnlightsActive2 = true;
				self.turnlightsActive = true;
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	end;
		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashlightsRightActive = true;
					self.turnlightsActive2 = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashlightsRightActive = false;
					self.turnlightsActive2 = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive2 = false;
			end;
		end;
	
		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;
		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
		if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;

	if self.isEntered then
		if self.rundumleuchtenAn == true then
		setVisibility(self.rullight, true);
	else
		setVisibility(self.rullight, false);
	    end;
    end;
	
	if self.isEntered then
		if self.rundumleuchtenAnz > 0 then
			if self.rundumleuchtenAn then
				for i=1, self.rundumleuchtenAnz do
				rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
				end;
			end;
		end;
	end;

	if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.FARMER_CAR_HORN) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
end;

function Scania:onLeave()

	self.translationMaxLinks = true;
	self.translationMaxRechts = true;
	self.rotationMaxleftDoor = true;
	self.rotationMaxrightDoor = true;
	self.translationMaxleftWindow = true;
	self.translationMaxrightWindow = true;
	self.rotationMaxSchild = true;
	self.farlightActive = false;

	self.rundumleuchtenAn = false;
	for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
	Steerable.onLeave(self);
	end;

end;

function Scania:draw()

		if not self.helpPanel then
            renderText(0.8335, 0.30, 0.02, "Taste 0: Info ein");
        else
            renderText(0.8335, 0.30, 0.02, "Taste 0: Info aus");
        end;
        
        if self.helpPanel then
            renderText(0.82, 0.28, 0.02, "- Manson Info -");
            --renderText(0.78, 0.22, 0.02, "Taste X: Liftachse Runter");
			--renderText(0.78, 0.24, 0.02, "Taste Y: Liftachse Hoch");
			--renderText(0.78, 0.26, 0.02, "Taste N: Alles Zu");
			--renderText(0.78, 0.22, 0.02, "Taste Home: Rundumleuchten An/Aus ");
			--renderText(0.78, 0.24, 0.02, "Taste 4: Gefahrgut An/Aus");
			--renderText(0.78, 0.26, 0.02, "Numpad 6: Hupen");
			--renderText(0.78, 0.28, 0.02, "Numpad 4: Fernlicht An/Aus");
			renderText(0.78, 0.36, 0.02, "Numpad 3: Blinker Rechts");
			renderText(0.78, 0.34, 0.02, "Numpad 2: Warnblinker");
			renderText(0.78, 0.32, 0.02, "Numpad 1: Blinker Links");
			--renderText(0.78, 0.42, 0.02, "Numpad 5: Rechte Scheibe Auf/Zu");
			--renderText(0.78, 0.44, 0.02, "Numpad 8: Linke Scheibe Auf/Zu");
			renderText(0.78, 0.38, 0.02, "Numpad 9: Rechte Tr Auf/Zu");
			renderText(0.78, 0.40, 0.02, "Numpad 7: Linke Tr Auf/Zu");
			
		end;
end;

