--
-- OilPallet
-- Specialization for Oil change
--
-- @author  	JoXXer
-- @version 	v1.0
-- @date  		16/11/11
-- @history:	v1.0 - Initial version
--

OilPallet = {};

function OilPallet.prerequisitesPresent(specializations)
    return true;
end;

function OilPallet:load(xmlFile)

	self.changeOil = SpecializationUtil.callSpecializationsFunction("changeOil");

	self.oilPalletTriggerCallback = OilPallet.oilPalletTriggerCallback;

	self.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.oilPallet#checkString"), "OilChange")
	self.usingTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.oilPallet#activationTrigger"));


	addTrigger(self.usingTrigger, "oilPalletTriggerCallback", self);
    self.deleteListenerId = addDeleteListener(self.usingTrigger, "oilDelete", self);

	self.oilPalletVehicle = nil;
	self.oilCapacity = 400;
end;

function OilPallet:delete()
    removeTrigger(self.usingTrigger);
end;

function OilPallet:wheelDelete()
    removeDeleteListener(self.usingTrigger, self.deleteListenerId);
end;

function OilPallet:readStream(streamId, connection)
	self.oilCapacity = streamReadInt16(streamId);
end;

function OilPallet:writeStream(streamId, connection)
	streamWriteInt16(streamId, self.oilCapacity);
end;

function OilPallet:mouseEvent(posX, posY, isDown, isUp, button)
end;

function OilPallet:keyEvent(unicode, sym, modifier, isDown)
end;

function OilPallet:update(dt)
end;

function OilPallet:updateTick(dt)

end;

function OilPallet:draw()
end;

function OilPallet:oilPalletTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	local vehicle = g_currentMission.controlledVehicle;
	if vehicle ~= nil then
		if onEnter or onStay then
			if vehicle.rootNode == otherId then
				if vehicle.oilChange ~= nil then
					if vehicle.oilChange.checkString == self.checkString then
						if self.oilPalletVehicle ~= nil then
							if self.oilPalletVehicle == vehicle then
								vehicle.oilChange.oilInRange = self;
							end;
						else
							vehicle.oilChange.oilInRange = self;
						end;
					end;
				end;
			end;
		elseif onLeave then
			if otherId == vehicle.rootNode then
				if vehicle.oilChange ~= nil then
					vehicle.oilChange.oilInRange = nil;
				end;
			end;
		end;
	end;
end;

function OilPallet:changeOil(vehicle, noEventSend)
	OilChangeEvent.sendEvent(self, vehicle, noEventSend);

	if vehicle.oilChange ~= nil then
		self.oilPalletVehicle = vehicle;
		self.oilPalletVehicle:changeOil(self);
	end;
end;

function OilPallet:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local valueInt = getXMLInt(xmlFile, key.."#oilCapacity");
		if valueInt ~= nil then
			self.oilCapacity = valueInt;
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function OilPallet:getSaveAttributesAndNodes(nodeIdent)
	local attributes = nil;

	attributes = 'oilCapacity="'.. self.oilCapacity .. '"';

	return attributes, nil;
end;




