--Valentini.lua
--@author: Fixatore
--@date:28/04/2012
-- Do not edit without my permission
---------------------------------

valentini = {};

function valentini.prerequisitesPresent(specializations)
    return true;
end;

function valentini:load(xmlFile)

	local RotazioneParteDestra = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.FoldRight#index"));
    if RotazioneParteDestra ~= nil then
        self.FoldRight = {};
        self.FoldRight.node = RotazioneParteDestra;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.FoldRight#minRot"));
        self.FoldRight.minRot = {};
        self.FoldRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.FoldRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.FoldRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.FoldRight#maxRot"));
        self.FoldRight.maxRot = {};
        self.FoldRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.FoldRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.FoldRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.FoldRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.FoldRight#rotTime"), 2)*1000;
        self.FoldRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.FoldRight#touchRotLimit"), 10));
    end;


    local rullo1node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rullo1#index"));
    if rullo1node ~= nil then
        self.rullo1 = {};
        self.rullo1.node = rullo1node;
		end;
		
	local rullo2node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rullo2#index"));
    if rullo2node ~= nil then
        self.rullo2 = {};
        self.rullo2.node = rullo2node;
		end;
		
	local RotazioneParteSinistra = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.FoldLeft#index"));
    if RotazioneParteSinistra ~= nil then
        self.FoldLeft = {};
        self.FoldLeft.node = RotazioneParteSinistra;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.FoldLeft#minRot"));
        self.FoldLeft.minRot = {};
        self.FoldLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.FoldLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.FoldLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.FoldLeft#maxRot"));
        self.FoldLeft.maxRot = {};
        self.FoldLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.FoldLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.FoldLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.FoldLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.FoldLeft#rotTime"), 2)*1000;
        self.FoldLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.FoldLeft#touchRotLimit"), 10));
    end;
	
	local Pistone1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Pistone1Sx#index"));
    if Pistone1 ~= nil then
        self.Pistone1Sx = {};
        self.Pistone1Sx.node = Pistone1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Pistone1Sx#minRot"));
        self.Pistone1Sx.minRot = {};
        self.Pistone1Sx.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Pistone1Sx.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Pistone1Sx.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Pistone1Sx#maxRot"));
        self.Pistone1Sx.maxRot = {};
        self.Pistone1Sx.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Pistone1Sx.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Pistone1Sx.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Pistone1Sx.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Pistone1Sx#rotTime"), 2)*1000;
        self.Pistone1Sx.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Pistone1Sx#touchRotLimit"), 10));
    end;
	
	local Pistone2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Pistone2Sx#index"));
    if Pistone2 ~= nil then
        self.Pistone2Sx = {};
        self.Pistone2Sx.node = Pistone2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Pistone2Sx#minRot"));
        self.Pistone2Sx.minRot = {};
        self.Pistone2Sx.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Pistone2Sx.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Pistone2Sx.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Pistone2Sx#maxRot"));
        self.Pistone2Sx.maxRot = {};
        self.Pistone2Sx.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Pistone2Sx.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Pistone2Sx.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Pistone2Sx.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Pistone2Sx#rotTime"), 2)*1000;
        self.Pistone2Sx.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Pistone2Sx#touchRotLimit"), 10));
    end;
	
	local Pistone3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Pistone1Dx#index"));
    if Pistone3 ~= nil then
        self.Pistone1Dx = {};
        self.Pistone1Dx.node = Pistone3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Pistone1Dx#minRot"));
        self.Pistone1Dx.minRot = {};
        self.Pistone1Dx.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Pistone1Dx.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Pistone1Dx.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Pistone1Dx#maxRot"));
        self.Pistone1Dx.maxRot = {};
        self.Pistone1Dx.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Pistone1Dx.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Pistone1Dx.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Pistone1Dx.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Pistone1Dx#rotTime"), 2)*1000;
        self.Pistone1Dx.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Pistone1Dx#touchRotLimit"), 10));
    end;
	
	local Pistone4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Pistone2Dx#index"));
    if Pistone4 ~= nil then
        self.Pistone2Dx = {};
        self.Pistone2Dx.node = Pistone4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Pistone2Dx#minRot"));
        self.Pistone2Dx.minRot = {};
        self.Pistone2Dx.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Pistone2Dx.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Pistone2Dx.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Pistone2Dx#maxRot"));
        self.Pistone2Dx.maxRot = {};
        self.Pistone2Dx.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Pistone2Dx.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Pistone2Dx.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Pistone2Dx.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Pistone2Dx#rotTime"), 2)*1000;
        self.Pistone2Dx.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Pistone2Dx#touchRotLimit"), 10));
    end;
	
	local Coll1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CollisionSx#index"));
    if Coll1 ~= nil then
        self.CollisionSx = {};
        self.CollisionSx.node = Coll1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.CollisionSx#minRot"));
        self.CollisionSx.minRot = {};
        self.CollisionSx.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.CollisionSx.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.CollisionSx.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.CollisionSx#maxRot"));
        self.CollisionSx.maxRot = {};
        self.CollisionSx.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.CollisionSx.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.CollisionSx.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.CollisionSx.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.CollisionSx#rotTime"), 2)*1000;
        self.CollisionSx.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.CollisionSx#touchRotLimit"), 10));
    end;
	
	local Coll2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CollisionRx#index"));
    if Coll2 ~= nil then
        self.CollisionRx = {};
        self.CollisionRx.node = Coll2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.CollisionRx#minRot"));
        self.CollisionRx.minRot = {};
        self.CollisionRx.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.CollisionRx.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.CollisionRx.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.CollisionRx#maxRot"));
        self.CollisionRx.maxRot = {};
        self.CollisionRx.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.CollisionRx.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.CollisionRx.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.CollisionRx.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.CollisionRx#rotTime"), 2)*1000;
        self.CollisionRx.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.CollisionRx#touchRotLimit"), 10));
    end;
	
	local stelo1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Stelo1sx#index"));
    if stelo1 ~= nil then
        self.Stelo1sx = {};
        self.Stelo1sx.node = stelo1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Stelo1sx#minTrans"));
        self.Stelo1sx.minTrans = {};
        self.Stelo1sx.minTrans[1] = Utils.getNoNil(x, 0);
        self.Stelo1sx.minTrans[2] = Utils.getNoNil(y, 0);
        self.Stelo1sx.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Stelo1sx#maxTrans"));
        self.Stelo1sx.maxTrans = {};
        self.Stelo1sx.maxTrans[1] = Utils.getNoNil(x, 0);
        self.Stelo1sx.maxTrans[2] = Utils.getNoNil(y, 0);
        self.Stelo1sx.maxTrans[3] = Utils.getNoNil(z, 0);

        self.Stelo1sx.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Stelo1sx#transTime"), 2)*1000;
        self.Stelo1sx.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Stelo1sx#touchTransLimit"), 10);
    end;
	
	local stelo2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.stelo2sx#index"));
    if stelo2 ~= nil then
        self.stelo2sx = {};
        self.stelo2sx.node = stelo2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stelo2sx#minTrans"));
        self.stelo2sx.minTrans = {};
        self.stelo2sx.minTrans[1] = Utils.getNoNil(x, 0);
        self.stelo2sx.minTrans[2] = Utils.getNoNil(y, 0);
        self.stelo2sx.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stelo2sx#maxTrans"));
        self.stelo2sx.maxTrans = {};
        self.stelo2sx.maxTrans[1] = Utils.getNoNil(x, 0);
        self.stelo2sx.maxTrans[2] = Utils.getNoNil(y, 0);
        self.stelo2sx.maxTrans[3] = Utils.getNoNil(z, 0);

        self.stelo2sx.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stelo2sx#transTime"), 2)*1000;
        self.stelo2sx.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stelo2sx#touchTransLimit"), 10);
    end;
	
	local stelo3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.stelo1dx#index"));
    if stelo3 ~= nil then
        self.stelo1dx = {};
        self.stelo1dx.node = stelo3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stelo1dx#minTrans"));
        self.stelo1dx.minTrans = {};
        self.stelo1dx.minTrans[1] = Utils.getNoNil(x, 0);
        self.stelo1dx.minTrans[2] = Utils.getNoNil(y, 0);
        self.stelo1dx.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stelo1dx#maxTrans"));
        self.stelo1dx.maxTrans = {};
        self.stelo1dx.maxTrans[1] = Utils.getNoNil(x, 0);
        self.stelo1dx.maxTrans[2] = Utils.getNoNil(y, 0);
        self.stelo1dx.maxTrans[3] = Utils.getNoNil(z, 0);

        self.stelo1dx.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stelo1dx#transTime"), 2)*1000;
        self.stelo1dx.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stelo1dx#touchTransLimit"), 10);
    end;
	
	local stelo4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.stelo2dx#index"));
    if stelo4 ~= nil then
        self.stelo2dx = {};
        self.stelo2dx.node = stelo4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stelo2dx#minTrans"));
        self.stelo2dx.minTrans = {};
        self.stelo2dx.minTrans[1] = Utils.getNoNil(x, 0);
        self.stelo2dx.minTrans[2] = Utils.getNoNil(y, 0);
        self.stelo2dx.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stelo2dx#maxTrans"));
        self.stelo2dx.maxTrans = {};
        self.stelo2dx.maxTrans[1] = Utils.getNoNil(x, 0);
        self.stelo2dx.maxTrans[2] = Utils.getNoNil(y, 0);
        self.stelo2dx.maxTrans[3] = Utils.getNoNil(z, 0);

        self.stelo2dx.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stelo2dx#transTime"), 2)*1000;
        self.stelo2dx.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stelo2dx#touchTransLimit"), 10);
    end;
	
end;

function valentini:delete()
end;

function valentini:mouseEvent(posX, posY, isDown, isUp, button)
end;

function valentini:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_x then
		self.FoldRightMax = not self.FoldRightMax
		self.FoldLeftMax = not self.FoldLeftMax
		self.Pistone1SxMax = not self.Pistone1SxMax
		self.Pistone2SxMax = not self.Pistone2SxMax
		self.Pistone1DxMax = not self.Pistone1DxMax
		self.Pistone2DxMax = not self.Pistone2DxMax
		self.CollisionSxMax = not self.CollisionSxMax
		self.CollisionRxMax = not self.CollisionRxMax
		self.Stelo1sxMax = not self.Stelo1sxMax
		self.stelo2sxMax = not self.stelo2sxMax
		self.stelo1dxMax = not self.stelo1dxMax
		self.stelo2dxMax = not self.stelo2dxMax
end;
end;

function valentini:update(dt)
	
	
	if self.FoldRight ~= nil then
		local x, y, z = getRotation(self.FoldRight.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.FoldRight.maxRot, self.FoldRight.minRot, 3, self.FoldRight.rotTime, dt, not self.FoldRightMax);
		setRotation(self.FoldRight.node, unpack(newRot));
	end;
		
	
	if self:isLowered() and not self.FoldRightMax  then
	local vel = self.attacherVehicle.wheelRpm/400;
		if self.movingDirection ==1 then
		 rotate(self.rullo1.node, -vel, 0, 0);
		 rotate(self.rullo2.node, -vel, 0, 0);
		else
		 rotate(self.rullo1.node, vel, 0, 0);
		 rotate(self.rullo2.node, vel, 0, 0);
		end;
		end;  
		
	if self.FoldLeft ~= nil then
		local x, y, z = getRotation(self.FoldLeft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.FoldLeft.maxRot, self.FoldLeft.minRot, 3, self.FoldLeft.rotTime, dt, not self.FoldLeftMax);
		setRotation(self.FoldLeft.node, unpack(newRot));
	end;
	
	if self.Pistone1Sx ~= nil then
		local x, y, z = getRotation(self.Pistone1Sx.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.Pistone1Sx.maxRot, self.Pistone1Sx.minRot, 3, self.Pistone1Sx.rotTime, dt, not self.Pistone1SxMax);
		setRotation(self.Pistone1Sx.node, unpack(newRot));
	end;
	
	if self.Pistone2Sx ~= nil then
		local x, y, z = getRotation(self.Pistone2Sx.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.Pistone2Sx.maxRot, self.Pistone2Sx.minRot, 3, self.Pistone2Sx.rotTime, dt, not self.Pistone2SxMax);
		setRotation(self.Pistone2Sx.node, unpack(newRot));
	end;
	
	if self.Pistone1Dx ~= nil then
		local x, y, z = getRotation(self.Pistone1Dx.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.Pistone1Dx.maxRot, self.Pistone1Dx.minRot, 3, self.Pistone1Dx.rotTime, dt, not self.Pistone1DxMax);
		setRotation(self.Pistone1Dx.node, unpack(newRot));
	end;
	
	if self.Pistone2Dx ~= nil then
		local x, y, z = getRotation(self.Pistone2Dx.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.Pistone2Dx.maxRot, self.Pistone2Dx.minRot, 3, self.Pistone2Dx.rotTime, dt, not self.Pistone2DxMax);
		setRotation(self.Pistone2Dx.node, unpack(newRot));
	end;
	
	if self.CollisionSx ~= nil then
		local x, y, z = getRotation(self.CollisionSx.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.CollisionSx.maxRot, self.CollisionSx.minRot, 3, self.CollisionSx.rotTime, dt, not self.CollisionSxMax);
		setRotation(self.CollisionSx.node, unpack(newRot));
	end;
	
	if self.CollisionRx ~= nil then
		local x, y, z = getRotation(self.CollisionRx.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.CollisionRx.maxRot, self.CollisionRx.minRot, 3, self.CollisionRx.rotTime, dt, not self.CollisionRxMax);
		setRotation(self.CollisionRx.node, unpack(newRot));
	end;
	
	if self.Stelo1sx ~= nil  then
			local x, y, z = getTranslation(self.Stelo1sx.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.Stelo1sx.maxTrans, self.Stelo1sx.minTrans, 3, self.Stelo1sx.transTime, dt, not self.Stelo1sxMax);
			setTranslation(self.Stelo1sx.node, unpack(newTrans));
		end;
		
	if self.stelo2sx ~= nil  then
			local x, y, z = getTranslation(self.stelo2sx.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.stelo2sx.maxTrans, self.stelo2sx.minTrans, 3, self.stelo2sx.transTime, dt, not self.stelo2sxMax);
			setTranslation(self.stelo2sx.node, unpack(newTrans));
		end;
	
	if self.stelo1dx ~= nil  then
			local x, y, z = getTranslation(self.stelo1dx.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.stelo1dx.maxTrans, self.stelo1dx.minTrans, 3, self.stelo1dx.transTime, dt, not self.stelo1dxMax);
			setTranslation(self.stelo1dx.node, unpack(newTrans));
		end;	
	
	if self.stelo2dx ~= nil  then
			local x, y, z = getTranslation(self.stelo2dx.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.stelo2dx.maxTrans, self.stelo2dx.minTrans, 3, self.stelo2dx.transTime, dt, not self.stelo2dxMax);
			setTranslation(self.stelo2dx.node, unpack(newTrans));
		end;	
end;

function valentini:draw()
	g_currentMission:addExtraPrintText("Tasto x : Apri/Chiudi La Fresa");
	
end;

function valentini:onAttach(attacherVehicle)
         
end;

function valentini:onDetach()
end;

function valentini:onEnter()
end;

function valentini:onLeave()
end;

function valentini:onActivate()
end;

function valentini:onDeactivate()
end;

function valentini:onDeactivateSounds()
end;

function valentini:addContactReports()
end;

function valentini:removeContactReports()
end;

function valentini:groundContactReport(objectId, otherObjectId, isStart, normalForce, tangentialForce)

end;

function valentini:validateAttacherJoint(implement, jointDesc, dt)
end;