--
-- Specjalizacja na kola Bolce i obciaznik
-- Autor: Lechu
-- Data: 16 Maj 2011
--

Lechu = {};

function Lechu.prerequisitesPresent(specializations)
    return true;
end;

function Lechu:load(xmlFile)
       
       self.oponapm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.oponapm#index"))
       self.oponalm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.oponalm#index"))
       self.oponap = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.oponap#index"))
       self.oponal = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.oponal#index"))
       self.obciaznikl = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.obciaznikl#index"))
       self.obciaznikp = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.obciaznikp#index"))
       self.oponapmActive = true;
       self.oponalmActive = true;
       self.oponapAcitve = true;
       self.oponalActive = true;
       self.obciazniklActive = true;
       self.obciaznikpActive = true;

end;

function Lechu:updateTick(dt)

        setVisibility(self.oponapm, self.oponapmActive);
        setVisibility(self.oponalm, self.oponalmActive);
        setVisibility(self.oponap, self.oponapActive);
        setVisibility(self.oponal, self.oponalActive);
        setVisibility(self.obciaznikl, self.obciazniklActive);
        setVisibility(self.obciaznikp, self.obciaznikpActive);

end;

function Lechu:update(dt)
end;

function Lechu:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Lechu:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == Input.KEY_7 then
        self.oponapmActive = not self.oponapmActive;
    end;
    if isDown and sym == Input.KEY_7 then
        self.oponalmActive = not self.oponalmActive;
    end;
    if isDown and sym == Input.KEY_6 then
        self.oponapActive = not self.oponapActive;
    end;
    if isDown and sym == Input.KEY_5 then
        self.oponalActive = not self.oponalActive;
    end;
    if isDown and sym == Input.KEY_n then
        self.obciazniklActive = not self.obciazniklActive;
    end;
    if isDown and sym == Input.KEY_m then
        self.obciaznikpActive = not self.obciaznikpActive;
    end;
end;

function Lechu:draw()
    if self.bolec then
        g_currentMission:addExtraPrintText("Klawisz n: Pokaz obciaznikl");
    else
        g_currentMission:addExtraPrintText("Klawisz n: Zdejmij obciaznikl");
    end;
    if self.balast then
        g_currentMission:addExtraPrintText("Klawisz m: Pokaz obciaznikp");
    else
        g_currentMission:addExtraPrintText("Klawisz m: Zdejmij obciaznikp");
    end;
end;

function Lechu:onAttach()
end; 	

function Lechu:onDetach()
end;

function Lechu:onDeactivate()
end;

function Lechu:delete()
end;

function Lechu:onEnter()
end;

function Lechu:onLeave()
end;