--
-- exteriorSound
-- Engine management specialization for a working position for the indoor camera
--
-- @author  Templaer
-- @date  3/07/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

exteriorSound = {};

function exteriorSound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function exteriorSound:load(xmlFile)
	self.switchSounds = SpecializationUtil.callSpecializationsFunction("switchSounds");
	
	self.outdoorCamera = true;
	self.cameraChanged = false;
	
	-- External Sounds
    local externalStartSound = getXMLString(xmlFile, "vehicle.motorStartSound#file");

    if externalStartSound ~= nil and externalStartSound ~= "" then
        externalStartSound = Utils.getFilename(externalStartSound, self.baseDirectory);
        self.externalStartSound = createSample("externalStartSound");
        loadSample(self.externalStartSound, externalStartSound, false);
    end;

    local externalStopSound = getXMLString(xmlFile, "vehicle.motorStopSound#file");
    if externalStopSound ~= nil and externalStopSound ~= "" then
        externalStopSound = Utils.getFilename(externalStopSound, self.baseDirectory);
        self.externalStopSound = createSample("externalStopSound");
        loadSample(self.externalStopSound, externalStopSound, false);
    end;

    local externalSound = getXMLString(xmlFile, "vehicle.motorSound#file");
    if externalSound ~= nil and externalSound ~= "" then
        externalSound = Utils.getFilename(externalSound, self.baseDirectory);
        self.externalSound = createSample("externalSound");
        loadSample(self.externalSound, externalSound, false);
    end;

    local externalSoundRun = getXMLString(xmlFile, "vehicle.motorSoundRun#file");
    if externalSoundRun ~= nil and externalSoundRun ~= "" then
        externalSoundRun = Utils.getFilename(externalSoundRun, self.baseDirectory);
        self.externalSoundRun = createSample("externalSoundRun");
        loadSample(self.externalSoundRun, externalSoundRun, false);
    end;
	
	-- Internal Sounds
    local internalStartSound = getXMLString(xmlFile, "vehicle.internalStartSound#file");

    if internalStartSound ~= nil and internalStartSound ~= "" then
        internalStartSound = Utils.getFilename(internalStartSound, self.baseDirectory);
        self.internalStartSound = createSample("internalStartSound");
        loadSample(self.internalStartSound, internalStartSound, false);
    end;

    local internalStopSound = getXMLString(xmlFile, "vehicle.internalStopSound#file");
    if internalStopSound ~= nil and internalStopSound ~= "" then
        internalStopSound = Utils.getFilename(internalStopSound, self.baseDirectory);
        self.internalStopSound = createSample("internalStopSound");
        loadSample(self.internalStopSound, internalStopSound, false);
    end;

    local internalSound = getXMLString(xmlFile, "vehicle.internalSound#file");
    if internalSound ~= nil and internalSound ~= "" then
        internalSound = Utils.getFilename(internalSound, self.baseDirectory);
        self.internalSound = createSample("internalSound");
        loadSample(self.internalSound, internalSound, false);
    end;

    local internalSoundRun = getXMLString(xmlFile, "vehicle.internalSoundRun#file");
    if internalSoundRun ~= nil and internalSoundRun ~= "" then
        internalSoundRun = Utils.getFilename(internalSoundRun, self.baseDirectory);
        self.internalSoundRun = createSample("internalSoundRun");
        loadSample(self.internalSoundRun, internalSoundRun, false);
    end;
end;

function exteriorSound:delete()
end;

function exteriorSound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function exteriorSound:keyEvent(unicode, sym, modifier, isDown)
end;

function exteriorSound:update(dt)	
    if self.isEntered and not g_currentMission.fixedCamera then
		if InputBinding.hasEvent(InputBinding.CAMERA_SWITCH) then
			self.outdoorCamera = not self.outdoorCamera;
			if not self.isRightDoorOpen and not self.isLeftDoorOpen then
				self.cameraChanged = true;
			end;
		end;
		
		if not self.outdoorCamera then
			if InputBinding.hasEvent(InputBinding.RIGHTDOOR) or InputBinding.hasEvent(InputBinding.LEFTDOOR) then
				self.cameraChanged = true;
			end;
		end;
		
		if self.cameraChanged then	
			self:switchSounds();
			self.cameraChanged = false;
		end;
	end;
end;

function exteriorSound:onEnter()
	self.outdoorCamera = true;
	self:switchSounds();
end;

function exteriorSound:draw()  
end;

function exteriorSound:switchSounds()
	if self.isMotorStarted then	
		stopSample(self.motorSound);
		stopSample(self.motorSoundRun);
	end;
	
	if self.outdoorCamera or self.isLeftDoorOpen or self.isRightDoorOpen then
		self.motorStartSound = self.externalStartSound;
		self.motorStopSound = self.externalStopSound;
		self.motorSound = self.externalSound;
		self.motorSoundRun = self.externalSoundRun;
	else
		self.motorStartSound = self.internalStartSound;
		self.motorStopSound = self.internalStopSound;
		self.motorSound = self.internalSound;
		self.motorSoundRun = self.internalSoundRun;
	end;
	
	if self.isMotorStarted then	
		playSample(self.motorSound);
		playSample(self.motorSoundRun);
		self.playMotorSound = true;
	end;
end;
