--

ScriptManipulator = {};

function ScriptManipulator.prerequisitesPresent(specializations)
    return true
end;

function ScriptManipulator:load(xmlFile)
	BarnMoverTrigger.triggerCallbackTarget = Utils.prependedFunction(BarnMoverTrigger.triggerCallbackTarget, ScriptManipulator.triggerCallbackTarget);
	BarnMoverTrigger.update = Utils.overwrittenFunction(BarnMoverTrigger.update, ScriptManipulator.updateBarn);
end;

function ScriptManipulator:delete()
end;

function ScriptManipulator:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ScriptManipulator:keyEvent(unicode, sym, modifier, isDown)
end;

function ScriptManipulator:update(dt)
	BarnMoverTrigger.dt = dt;
end;


function ScriptManipulator:updateTick(dt)
end;

function ScriptManipulator:onLeave()
	self.motorSoundPitchOffset = self.motorSoundPitchBackup;
end;

function ScriptManipulator:draw()
end;

function ScriptManipulator:onAttach(attacherVehicle)
	attacherVehicle.onLeave   = Utils.appendedFunction(attacherVehicle.onLeave, ScriptManipulator.onLeave);
	self.attacherVehicle.motorSoundPitchBackup = self.attacherVehicle.motorSoundPitchOffset;
end;

function ScriptManipulator:onDetach()
end;

function ScriptManipulator:triggerCallbackTarget(triggerId, otherId, onEnter, onLeave, onStay)
	if getParent(otherId) ~= nil then
		if getName(otherId) == "specialTrigger" then
			local fork = g_currentMission.nodeToVehicle[getParent(otherId)];
			fork:detachBale();
			fork.warnCounter = 0;
		end;
	end;
end;


function ScriptManipulator:updateBarn(dt)
	for k,touched in pairs(self.touched) do
		local vx, vy, vz = getLinearVelocity(k);
		if vx ~= nil and vy ~= nil and vz ~= nil then
			local dot = vx*self.dirX + vy*self.dirY + vz*self.dirZ;
			local v = dot/self.dirLength;
	
			if v < self.targetVelocity then
				local scale = self.dt*touched.mass;
				addForce(k, self.dirX*self.dt, self.dirY*self.dt, self.dirZ*self.dt, 0, 0, 0, true);
			end;
		end;
	end;
end;