--
-- henly 20 (Ls_uk Modteam)
-- 21.07.2010
--
-- > www.LS-UK.info

lemtrailer = {};

function lemtrailer.prerequisitesPresent(specializations)
    return true;
end;

function lemtrailer:load(xmlFile)

	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
	
	self.GetVehiclesInRange = lemtrailer.GetVehiclesInRange;
	self.attachVehicles = lemtrailer.attachVehicles;
	self.detachVehicles = lemtrailer.detachVehicles;
	self.Attachers={};
	self.PF={};
	local Parent = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Attacher#ParentIndex"));
	local Parent2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Attacher#PlaceFinderParent"));
	local numAttachers = getNumOfChildren(Parent);
	local numPlaceFinders = getNumOfChildren(Parent2);
	for i=1, numAttachers do
		self.Attachers[i] = {};
		self.Attachers[i].node = getChildAt(Parent, i-1);
		self.Attachers[i].attachedObject = nil;
	end;	
	for j=1, numPlaceFinders do
		self.PF[j] = {};
		self.PF[j].Transform = getChildAt(Parent2, j-1);
	end;
	self.once = true;
	self.onceActive = true;	
	
	self.controlpath = Utils.getFilename("textures/hud_lemken.png", self.baseDirectory);
    self.hudhud_lemkenPoxX = 0.79;
    self.hudhud_lemkenPoxY = 0.35;
    self.hudhud_lemkenWidth = 0.2;
    self.hudhud_lemkenHeight = 0.14;
    self.hudhud_lemkenOverlay = Overlay:new("hudhud_lemken", self.controlpath, self.hudhud_lemkenPoxX, self.hudhud_lemkenPoxY, self.hudhud_lemkenWidth, self.hudhud_lemkenHeight);
     self.bcActive = true;


	self.trig = {};
	self.trig[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.trig#index1"));
	self.trig[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.trig#index2"));
	
	setVisibility(self.trig[1], true);
	setVisibility(self.trig[2], false);
	
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;

	self.brakelightsActive = false;
    self.braking = false;
    self.isTurnedOn = false;
end;

function lemtrailer:delete()
end;

function lemtrailer:readStream(streamId, connection)
      local turnedOn = streamReadBool(streamId);
      self:setIsTurnedOn(turnedOn, true);
end;

function lemtrailer:writeStream(streamId, connection)
      streamWriteBool(streamId, self.isTurnedOn);
end;

function lemtrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function lemtrailer:keyEvent(unicode, sym, modifier, isDown)


	

end;

function lemtrailer:update(dt)

      if self:getIsActiveForInput() then
              if InputBinding.hasEvent(InputBinding.ATTACHOBJECTLEM) then
                  self:setIsTurnedOn(not self.isTurnedOn);
              end;
      end;

end;

function lemtrailer:updateTick(dt)
	if self:getIsActive() then
	
	if self.isTurnedOn then
            local nearestVehicles = {};
            if self.once then
				self.nearestVehicles = {self:GetVehiclesInRange()};
				self.once = false;
			end;
			for i = 1, table.getn(self.nearestVehicles) do
				self:attachVehicles(self.nearestVehicles[i], i);
			end;
        else
			self.once = true;
			for i = 1, table.getn(self.nearestVehicles) do
				self:detachVehicles(self.nearestVehicles[i], i);
			end;	
        end;

		
		inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLED);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;

		
		if self.attacherVehicle ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;
    end;
end;	
	
	if self.attacherVehicle then
		for k, implement in pairs(self.attacherVehicle.attachedImplements) do
			if implement.object == self then
				local index = implement.jointDescIndex;
				self.attacherVehicleJoint = self.attacherVehicle.attacherJoints[index];
				setJointRotationLimit(self.attacherVehicleJoint.jointIndex, 2, true, Utils.degToRad(-20), Utils.degToRad(20));
			end;
		end;
	end;  	
	
	for i, jointDesc in pairs(self.componentJoints) do
	   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
end;

function lemtrailer:draw()
	if self:getIsActive() then
	if self.isTurnedOn then
		setTextColor(1,0,0,1);
		renderText(0.8, 0.415, 0.023, "Key O: Unattach Load");
	else
		renderText(0.81, 0.415, 0.022, "Key O: Attach Load");
	end;
	
	 if self.hudhud_lemkenOverlay ~= nil then
		if self.bcActive then
		self.hudhud_lemkenOverlay:render();
		end;
	end;
	end;
end;

function lemtrailer:setIsTurnedOn(turnedOn, noEventSend)
      SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
      self.isTurnedOn = turnedOn;
end;

function lemtrailer:validateAttacherJoint(implement, jointDesc, dt)
        return true;

end;

function lemtrailer:attachVehicles(node, k)
	if self.Attachers[k].node ~= nil and self.Attachers[k].attachedObject == nil then 			
		--JointTranslation Anpassung an das Objekt
		local xw, yw, zw = getWorldTranslation(node.components[1].node);		
		local x,y,z = worldToLocal(getParent(self.Attachers[k].node), xw, yw, zw);	
		setTranslation(self.Attachers[k].node, x,y,z);			
		--JointRotation Anpassung an das Objekt
		local zX, zY, zZ = localDirectionToWorld(node.components[1].node, 0,0,1);
		local zX, zY, zZ = worldDirectionToLocal(getParent(self.Attachers[k].node), zX, zY, zZ);
		local yX, yY, yZ = localDirectionToWorld(node.components[1].node, 0,1,0);
		local yX, yY, yZ = worldDirectionToLocal(getParent(self.Attachers[k].node), yX, yY, yZ);
		setDirection(self.Attachers[k].node, zX, zY, zZ, yX, yY, yZ);
		
		if node.enterReferenceNode == nil then
			node:onAttach(self);
		end;
		--anhaengen
		local constr = JointConstructor:new();					
		constr:setActors(self.components[1].node, node.components[1].node);
		constr:setJointTransforms(self.Attachers[k].node,  node.components[1].node);
		for i=1, 3 do		                    
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1, 0, 0);
		end;		
		self.Attachers[k].attachedObject = constr:finalize();
	end;
end;

function lemtrailer:detachVehicles(node, k)
	if self.Attachers[k].attachedObject ~= nil then	
		node.attacherVehicle = nil;
		
		if node.enterReferenceNode == nil then
			node:onDetach(self);
		end;		
		removeJoint(self.Attachers[k].attachedObject);
		self.Attachers[k].attachedObject = nil;
		
		setTranslation(self.Attachers[k].node,0,0,0);
		setRotation(self.Attachers[k].node,0,0,0);
	end;
end;

function lemtrailer:GetVehiclesInRange()
	local nearestNode = {};
	local nearestDistance = 2;
	for u,obj in pairs(self.PF) do
		local px, py, pz = getWorldTranslation(obj.Transform);
		
		for k,v in pairs(g_currentMission.vehicles) do
			if v ~= self and v ~= self.attacherVehicle then
				local x,y,z = getWorldTranslation(v.components[1].node);
				local distance = Utils.vector3Length(px-x, py-y, pz-z);
				if distance < nearestDistance then
					if table.getn(nearestNode)+1 <= table.getn(self.Attachers) then
						nearestNode[table.getn(nearestNode)+1] = v;
						print("eingetragen");
					end;
				end;
			end;
		end;
	end;
	return unpack(nearestNode)
end;

function lemtrailer:onDetach()

	setVisibility(self.trig[2], true);
	setVisibility(self.trig[1], false);
	self.onceActive = false;
	self.isTurnedOn = false;
end;

function lemtrailer:onAttach(attacherVehicle)
	setVisibility(self.trig[1], true);
	setVisibility(self.trig[2], false);
	self.isTurnedOn = true;
end;
