--
-- BuyableTwinWheelsAttacher
-- Specialization for BuyableTwinWheelsAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
-- Edit By Ufolec

BuyableTwinWheelsAttacher = {};

function BuyableTwinWheelsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableTwinWheelsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.buyableTwinWheels = {};
	self.buyableTwinWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#twinWheelsCheckString"), "standart");
	self.buyableTwinWheels.twinWheels = nil;
	self.buyableTwinWheels.wheelsInRange = nil;	
end;

function BuyableTwinWheelsAttacher:delete()
	if self.buyableTwinWheels.twinWheels ~= nil then
		self.buyableTwinWheels.twinWheels:disassembleWheels(true);
	end;
end;

function BuyableTwinWheelsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableTwinWheelsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableTwinWheelsAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.buyableTwinWheels;
		if wheels.wheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_TWINWHEELS_ATTACH) then
					if wheels.twinWheels == nil then
						wheels.wheelsInRange:assembleWheels(self);
					else
						if wheels.wheelsInRange.twinWheelsUser == self then
							wheels.wheelsInRange:disassembleWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableTwinWheelsAttacher:draw()
	local wheels = self.buyableTwinWheels;
	if wheels.wheelsInRange ~= nil then
		if wheels.twinWheels ~= nil then
			if wheels.wheelsInRange.twinWheelsUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_disassemble"), InputBinding.BUYABLE_TWINWHEELS_ATTACH);
			end;
		else
			if wheels.wheelsInRange.twinWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_assemble"), InputBinding.BUYABLE_TWINWHEELS_ATTACH);
			end;
		end;
	end;
end;

function BuyableTwinWheelsAttacher:onAssembling(buyableTwinWheels)
	self.buyableTwinWheels.twinWheels = buyableTwinWheels;
end;

function BuyableTwinWheelsAttacher:onDisassembling()
	self.buyableTwinWheels.twinWheels = nil;
end;
